/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.pde.api.tools.internal.AbstractApiComponent;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ArchiveClassFileContainer;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.IApiFilterStore;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.IRequiredComponentDescription;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IPackageDescriptor;

public class SystemLibraryApiComponent
extends AbstractApiComponent {
    private String[] fExecEnv;
    private LibraryLocation[] fLibraries;
    private String fLocation;
    private String[] fSystemPackages;
    private String fVersion;

    public SystemLibraryApiComponent(IApiProfile profile, File description, String[] systemPackages) {
        super(profile);
        this.init(description);
        this.fSystemPackages = systemPackages;
    }

    protected IApiDescription createApiDescription() throws CoreException {
        ApiDescription api = new ApiDescription(this.getId());
        int i = 0;
        while (i < this.fSystemPackages.length) {
            IPackageDescriptor pkg = Factory.packageDescriptor(this.fSystemPackages[i]);
            api.setVisibility(pkg, 1);
            ++i;
        }
        String[] packageNames = this.getPackageNames();
        int i2 = 0;
        while (i2 < packageNames.length) {
            if (packageNames[i2].startsWith("java.")) {
                IPackageDescriptor pkg = Factory.packageDescriptor(packageNames[i2]);
                api.setVisibility(pkg, 1);
            }
            ++i2;
        }
        return api;
    }

    protected IApiFilterStore createApiFilterStore() {
        return null;
    }

    protected List createClassFileContainers() throws CoreException {
        ArrayList<ArchiveClassFileContainer> libs = new ArrayList<ArchiveClassFileContainer>(this.fLibraries.length);
        int i = 0;
        while (i < this.fLibraries.length) {
            LibraryLocation lib = this.fLibraries[i];
            libs.add(new ArchiveClassFileContainer(lib.getSystemLibraryPath().toOSString(), null));
            ++i;
        }
        return libs;
    }

    public String[] getExecutionEnvironments() {
        return this.fExecEnv;
    }

    public String getId() {
        return this.fExecEnv[0];
    }

    public String getLocation() {
        return this.fLocation;
    }

    public String getName() {
        return this.fExecEnv[0];
    }

    public IRequiredComponentDescription[] getRequiredComponents() {
        return new IRequiredComponentDescription[0];
    }

    public String getVersion() {
        return this.fVersion;
    }

    private void init(File description) {
        EEVMType.clearProperties((File)description);
        this.fLibraries = EEVMType.getLibraryLocations((File)description);
        this.fExecEnv = new String[]{EEVMType.getProperty((String)"-Dee.class.library.level", (File)description)};
        this.fVersion = this.fExecEnv[0];
        this.fLocation = EEVMType.getProperty((String)"-Djava.home", (File)description);
    }

    public boolean isSourceComponent() {
        return false;
    }

    public boolean isSystemComponent() {
        return true;
    }

    public boolean isFragment() {
        return false;
    }

    public boolean hasFragments() {
        return false;
    }

    public String getOrigin() {
        return null;
    }

    public boolean hasApiDescription() {
        return false;
    }
}

