/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.pde.api.tools.internal.builder.BuilderMessages;
import org.eclipse.pde.api.tools.internal.comparator.Delta;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;

public class BuildState {
    private IDelta[] EMPTY_DELTAS = new IDelta[0];
    private static final int VERSION = 4;
    private Map compatibleChanges = new HashMap();
    private Map breakingChanges = new HashMap();

    public static BuildState read(DataInputStream in) throws IOException {
        String pluginID = in.readUTF();
        if (!pluginID.equals("org.eclipse.pde.api.tools")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        String kind = in.readUTF();
        if (!kind.equals("STATE")) {
            throw new IOException(BuilderMessages.build_wrongFileFormat);
        }
        if (in.readInt() != 4) {
            return null;
        }
        if (in.readBoolean()) {
            BuildState state = new BuildState();
            int numberOfCompatibleDeltas = in.readInt();
            int i = 0;
            while (i < numberOfCompatibleDeltas) {
                state.addCompatibleChange(BuildState.readDelta(in));
                ++i;
            }
            int numberOfBreakingDeltas = in.readInt();
            int i2 = 0;
            while (i2 < numberOfBreakingDeltas) {
                state.addBreakingChange(BuildState.readDelta(in));
                ++i2;
            }
            return state;
        }
        return null;
    }

    public static void write(BuildState state, DataOutputStream out) throws IOException {
        out.writeUTF("org.eclipse.pde.api.tools");
        out.writeUTF("STATE");
        out.writeInt(4);
        out.writeBoolean(true);
        IDelta[] compatibleChangesDeltas = state.getCompatibleChanges();
        int length = compatibleChangesDeltas.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            BuildState.writeDelta(compatibleChangesDeltas[i], out);
            ++i;
        }
        IDelta[] breakingChangesDeltas = state.getBreakingChanges();
        int length2 = breakingChangesDeltas.length;
        out.writeInt(length2);
        int i2 = 0;
        while (i2 < length2) {
            BuildState.writeDelta(breakingChangesDeltas[i2], out);
            ++i2;
        }
    }

    private static IDelta readDelta(DataInputStream in) throws IOException {
        boolean hasComponentID = in.readBoolean();
        String componentID = null;
        if (hasComponentID) {
            in.readUTF();
        }
        int elementType = in.readInt();
        int kind = in.readInt();
        int flags = in.readInt();
        int restrictions = in.readInt();
        int modifiers = in.readInt();
        String typeName = in.readUTF();
        String key = in.readUTF();
        int length = in.readInt();
        String[] datas = null;
        if (length != 0) {
            ArrayList<String> arguments = new ArrayList<String>();
            int i = 0;
            while (i < length) {
                arguments.add(in.readUTF());
                ++i;
            }
            datas = new String[length];
            arguments.toArray(datas);
        } else {
            datas = new String[]{typeName.replace('$', '.')};
        }
        return new Delta(componentID, elementType, kind, flags, restrictions, modifiers, typeName, key, datas);
    }

    private static void writeDelta(IDelta delta, DataOutputStream out) throws IOException {
        String apiComponentID = delta.getApiComponentID();
        boolean hasComponentID = apiComponentID != null;
        out.writeBoolean(hasComponentID);
        if (hasComponentID) {
            out.writeUTF(apiComponentID);
        }
        out.writeInt(delta.getElementType());
        out.writeInt(delta.getKind());
        out.writeInt(delta.getFlags());
        out.writeInt(delta.getRestrictions());
        out.writeInt(delta.getModifiers());
        out.writeUTF(delta.getTypeName());
        out.writeUTF(delta.getKey());
        String[] arguments = delta.getArguments();
        int length = arguments.length;
        out.writeInt(length);
        int i = 0;
        while (i < length) {
            out.writeUTF(arguments[i]);
            ++i;
        }
    }

    BuildState() {
    }

    public void addCompatibleChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.compatibleChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.compatibleChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public void addBreakingChange(IDelta delta) {
        String typeName = delta.getTypeName();
        Set object = (Set)this.breakingChanges.get(typeName);
        if (object == null) {
            HashSet<IDelta> changes = new HashSet<IDelta>();
            changes.add(delta);
            this.breakingChanges.put(typeName, changes);
        } else {
            object.add(delta);
        }
    }

    public IDelta[] getBreakingChanges() {
        if (this.breakingChanges == null || this.breakingChanges.size() == 0) {
            return this.EMPTY_DELTAS;
        }
        ArrayList collector = new ArrayList();
        Collection values = this.breakingChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            HashSet set = (HashSet)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                collector.add(iterator2.next());
            }
        }
        IDelta[] result = new IDelta[collector.size()];
        collector.toArray(result);
        return result;
    }

    public IDelta[] getCompatibleChanges() {
        if (this.compatibleChanges == null || this.compatibleChanges.size() == 0) {
            return this.EMPTY_DELTAS;
        }
        ArrayList collector = new ArrayList();
        Collection values = this.compatibleChanges.values();
        Iterator iterator = values.iterator();
        while (iterator.hasNext()) {
            HashSet set = (HashSet)iterator.next();
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                collector.add(iterator2.next());
            }
        }
        IDelta[] result = new IDelta[collector.size()];
        collector.toArray(result);
        return result;
    }

    public void cleanup(String typeName) {
        this.breakingChanges.remove(typeName);
        this.compatibleChanges.remove(typeName);
    }
}

