/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.comparator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.comparator.ClassFileDescriptorBuilder;
import org.eclipse.pde.api.tools.internal.comparator.ElementDescriptor;
import org.eclipse.pde.api.tools.internal.comparator.MemberTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IClassFile;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class TypeDescriptor
extends ElementDescriptor {
    public static final int ANONYMOUS = 1;
    public static final int LOCAL = 2;
    public static final int MEMBER = 4;
    Map fields;
    Set interfaces;
    Map methods;
    String signature;
    List typeMembers;
    String superName;
    int version;
    public IClassFile classFile;
    public int bits;

    public TypeDescriptor(IClassFile classFile) throws CoreException {
        this.classFile = classFile;
        this.fields = new HashMap();
        this.methods = new HashMap();
        this.initialize(classFile.getContents());
    }

    TypeDescriptor(byte[] bytes) {
        this.fields = new HashMap();
        this.methods = new HashMap();
        this.initialize(bytes);
    }

    public void addTypeMember(String memberName, int access) {
        if (this.typeMembers == null) {
            this.typeMembers = new ArrayList(4);
        }
        this.typeMembers.add(new MemberTypeDescriptor(memberName, access));
    }

    private void initialize(byte[] bytes) {
        ClassFileDescriptorBuilder visitor = new ClassFileDescriptorBuilder((ClassVisitor)new ClassNode(), this);
        try {
            ClassReader classReader = new ClassReader(bytes);
            classReader.accept((ClassVisitor)visitor, 5);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            ApiPlugin.log(e);
        }
    }

    public void initialize(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.name = name.replace('/', '.');
        this.handle = Factory.typeDescriptor(this.name);
        this.signature = signature;
        if (superName != null) {
            this.superName = superName.replace('/', '.');
        }
        if (interfaces != null && interfaces.length != 0) {
            this.interfaces = new HashSet();
            int i = 0;
            int max = interfaces.length;
            while (i < max) {
                this.interfaces.add(interfaces[i].replace('/', '.'));
                ++i;
            }
        }
    }

    public boolean isAnnotation() {
        return (this.access & 0x2000) != 0;
    }

    public boolean isEnum() {
        return (this.access & 0x4000) != 0;
    }

    public boolean isInterface() {
        return (this.access & 0x200) != 0;
    }

    public boolean isNestedType() {
        return (this.bits & 7) != 0;
    }

    public void setAnonymous() {
        this.bits |= 1;
    }

    public void setLocal() {
        this.bits |= 2;
    }

    public void setMember() {
        this.bits |= 4;
    }

    public String toString() {
        Iterator iterator2;
        List list;
        StringBuffer buffer = new StringBuffer();
        buffer.append("Type : access(").append(this.access).append(") ").append(this.name);
        if (this.superName != null) {
            buffer.append(" superclass: ").append(this.superName);
        }
        if (this.interfaces != null) {
            buffer.append(" interfaces : ");
            int length = this.interfaces.size();
            if (length != 0) {
                int i = 0;
                Iterator iterator = this.interfaces.iterator();
                while (iterator.hasNext()) {
                    if (i > 0) {
                        buffer.append(',');
                    }
                    ++i;
                    buffer.append(iterator.next());
                }
            } else {
                buffer.append("none");
            }
        }
        buffer.append(';').append(Util.LINE_DELIMITER);
        if (this.signature != null) {
            buffer.append(" Signature : ").append(this.signature).append(Util.LINE_DELIMITER);
        }
        buffer.append(Util.LINE_DELIMITER).append("Methods : ").append(Util.LINE_DELIMITER);
        Iterator iterator = this.methods.values().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof List) {
                list = (List)next;
                iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    buffer.append(iterator2.next());
                }
                continue;
            }
            buffer.append(next);
        }
        buffer.append(Util.LINE_DELIMITER).append("Fields : ").append(Util.LINE_DELIMITER);
        iterator = this.fields.values().iterator();
        while (iterator.hasNext()) {
            Object next = iterator.next();
            if (next instanceof List) {
                list = (List)next;
                iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    buffer.append(iterator2.next());
                }
                continue;
            }
            buffer.append(next);
        }
        return String.valueOf(buffer);
    }

    int getElementType() {
        if ((this.access & 0x4000) != 0) {
            return 6;
        }
        if ((this.access & 0x2000) != 0) {
            return 1;
        }
        if ((this.access & 0x200) != 0) {
            return 8;
        }
        return 4;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TypeDescriptor) {
            TypeDescriptor typeDescriptor = (TypeDescriptor)obj;
            return this.name.equals(typeDescriptor.name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

