/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.internal.search.SearchCriteria;
import org.eclipse.pde.api.tools.internal.util.Util;

public class MethodSearchCriteria
extends SearchCriteria {
    public MethodSearchCriteria(int referencekind, Object userdata) {
        this.setReferencedRestrictions(2, 65535);
        this.setReferenceKinds(referencekind);
        this.setUserData(userdata);
        this.fSourceVisibility = 1;
    }

    protected boolean matchesSourceModifiers(ILocation location) {
        for (IMemberDescriptor member = location.getMember(); member != null; member = member.getEnclosingType()) {
            int modifiers = member.getModifiers();
            if (Util.isPublic(modifiers) || Util.isProtected(modifiers)) {
                continue;
            }
            return false;
        }
        return true;
    }

    protected boolean matchesSourceApiRestrictions(ILocation location) {
        block8: {
            IMemberDescriptor member = location.getMember();
            if (member.getElementType() != 6) {
                return false;
            }
            IApiComponent apiComponent = location.getApiComponent();
            try {
                IMethodDescriptor method = (IMethodDescriptor)member;
                IApiAnnotations annotations = apiComponent.getApiDescription().resolveAnnotations(method);
                if (annotations != null) {
                    if ((annotations.getVisibility() & this.fSourceVisibility) > 0) {
                        int ares = annotations.getRestrictions();
                        if (ares != 0) {
                            if (method.isConstructor()) {
                                return (ares & 0x800) == 0;
                            }
                            if ((ares & 0x1000) == 0) {
                                return (ares & 0x800) != 0 && !Util.isFinal(method.getModifiers());
                            }
                            return (ares & 0x800) == 0;
                        }
                        return this.fSourceRestriction != 0;
                    }
                    break block8;
                }
                return true;
            }
            catch (CoreException e) {
                ApiPlugin.log(e);
            }
        }
        return false;
    }
}

