/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.Activator;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryIO;
import org.eclipse.equinox.internal.p2.metadata.repository.MetadataRepositoryManager;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.repository.RepositoryEvent;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.AbstractMetadataRepository;
import org.eclipse.equinox.internal.provisional.spi.p2.metadata.repository.RepositoryReference;
import org.osgi.framework.BundleContext;

public class LocalMetadataRepository
extends AbstractMetadataRepository {
    private static final String CONTENT_FILENAME = "content";
    private static final String REPOSITORY_TYPE;
    private static final Integer REPOSITORY_VERSION;
    private static final String JAR_EXTENSION = ".jar";
    private static final String XML_EXTENSION = ".xml";
    protected HashSet units = new LinkedHashSet();
    protected HashSet repositories = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.LocalMetadataRepository");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    private static File getActualLocation(URL location, String extension) {
        String spec = location.getFile();
        if (spec.endsWith(CONTENT_FILENAME + extension)) {
            return new File(String.valueOf(spec) + extension);
        }
        spec = spec.endsWith("/") ? String.valueOf(spec) + CONTENT_FILENAME : String.valueOf(spec) + "/content";
        return new File(String.valueOf(spec) + extension);
    }

    public static File getActualLocation(URL location) {
        return LocalMetadataRepository.getActualLocation(location, XML_EXTENSION);
    }

    public LocalMetadataRepository() {
    }

    public LocalMetadataRepository(URL location, String name, Map properties) {
        super(name == null ? (location != null ? location.toExternalForm() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        if (!location.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Invalid local repository location: " + location);
        }
        this.save();
    }

    public synchronized void addInstallableUnits(IInstallableUnit[] installableUnits) {
        if (installableUnits == null || installableUnits.length == 0) {
            return;
        }
        this.units.addAll(Arrays.asList(installableUnits));
        this.save();
    }

    public synchronized void addReference(URL repositoryLocation, int repositoryType, int options) {
        this.assertModifiable();
        this.repositories.add(new RepositoryReference(repositoryLocation, repositoryType, options));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        LocalMetadataRepository localMetadataRepository = this;
        synchronized (localMetadataRepository) {
            this.name = state.Name;
            this.type = state.Type;
            this.version = state.Version.toString();
            this.provider = state.Provider;
            this.description = state.Description;
            this.location = state.Location;
            this.properties = state.Properties;
            this.units.addAll(Arrays.asList(state.Units));
            this.repositories.addAll(Arrays.asList(state.Repositories));
        }
        this.publishRepositoryReferences();
    }

    private void publishRepositoryReferences() {
        IProvisioningEventBus bus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (bus == null) {
            return;
        }
        List repositoriesSnapshot = this.createRepositoriesSnapshot();
        Iterator it = repositoriesSnapshot.iterator();
        while (it.hasNext()) {
            RepositoryReference reference = (RepositoryReference)it.next();
            boolean isEnabled = (reference.Options & 1) != 0;
            bus.publishEvent((EventObject)new RepositoryEvent(reference.Location, reference.Type, 4, isEnabled));
        }
    }

    private synchronized List createRepositoriesSnapshot() {
        if (this.repositories.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return new ArrayList(this.repositories);
    }

    public synchronized void initializeAfterLoad(URL aLocation) {
        this.location = aLocation;
    }

    public boolean isModifiable() {
        return true;
    }

    public synchronized Collector query(Query query, Collector collector, IProgressMonitor monitor) {
        return query.perform(this.units.iterator(), collector);
    }

    public synchronized void removeAll() {
        this.units.clear();
        this.save();
    }

    public synchronized boolean removeInstallableUnits(Query query, IProgressMonitor monitor) {
        boolean changed = false;
        Iterator it = this.units.iterator();
        while (it.hasNext()) {
            if (!query.isMatch(it.next())) continue;
            it.remove();
            changed = true;
        }
        if (changed) {
            this.save();
        }
        return changed;
    }

    public synchronized void revertToBackup(LocalMetadataRepository backup) {
        this.name = backup.name;
        this.type = backup.type;
        this.version = backup.version;
        this.location = backup.location;
        this.description = backup.description;
        this.provider = backup.provider;
        this.properties = backup.properties;
        this.units = backup.units;
    }

    private void save() {
        File file = LocalMetadataRepository.getActualLocation(this.location);
        File jarFile = LocalMetadataRepository.getActualLocation(this.location, JAR_EXTENSION);
        boolean compress = "true".equalsIgnoreCase((String)this.properties.get("p2.compressed"));
        try {
            OutputStream output = null;
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                output = new FileOutputStream(file);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarEntry jarEntry = new JarEntry(file.getName());
                JarOutputStream jOutput = new JarOutputStream(new FileOutputStream(jarFile));
                jOutput.putNextEntry(jarEntry);
                output = jOutput;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
            new MetadataRepositoryIO().write(this, output);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1003, "Error saving metadata repository: " + this.location, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setProperty(String key, String newValue) {
        MetadataRepositoryManager manager;
        String oldValue = null;
        LocalMetadataRepository localMetadataRepository = this;
        synchronized (localMetadataRepository) {
            oldValue = super.setProperty(key, newValue);
            if (oldValue == newValue || oldValue != null && oldValue.equals(newValue)) {
                return oldValue;
            }
            this.save();
        }
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (MetadataRepositoryManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName())).removeRepository(this.getLocation())) {
            manager.addRepository(this);
        }
        return oldValue;
    }
}

