/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.junit.launcher.AssertionVMArg;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jdt.internal.junit.ui.JUnitPreferencesConstants;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public class JUnitPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    private static final Image IMG_CUNIT = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    private static final Image IMG_PKG = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    private Button fEnableAssertionsCheckBox;
    private Label fFilterViewerLabel;
    private CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    private Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    private Text fEditorText;
    private String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewStackFilter;
    private StackFilterContentProvider fStackFilterContentProvider;

    public JUnitPreferencePage() {
        this.setDescription(JUnitMessages.JUnitPreferencePage_description);
        this.setPreferenceStore(JUnitPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.jdt.junit.junit_preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createEnableAssertionsCheckbox(composite);
        this.createStackFilterPreferences(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createEnableAssertionsCheckbox(Composite container) {
        this.fEnableAssertionsCheckBox = new Button(container, 96);
        this.fEnableAssertionsCheckBox.setText(JUnitMessages.JUnitPreferencePage_enableassertionscheckbox_label);
        this.fEnableAssertionsCheckBox.setToolTipText(JUnitMessages.JUnitPreferencePage_enableassertionscheckbox_tooltip);
        GridData gd = this.getButtonGridData(this.fEnableAssertionsCheckBox);
        this.fEnableAssertionsCheckBox.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fEnableAssertionsCheckBox);
        this.setAssertionCheckBoxSelection(AssertionVMArg.getEnableAssertionsPreference());
    }

    public boolean getAssertionCheckBoxSelection() {
        return this.fEnableAssertionsCheckBox.getSelection();
    }

    public void setAssertionCheckBoxSelection(boolean selected) {
        this.fEnableAssertionsCheckBox.setSelection(selected);
    }

    private void createStackFilterPreferences(Composite composite) {
        this.fFilterViewerLabel = new Label(composite, 16388);
        this.fFilterViewerLabel.setText(JUnitMessages.JUnitPreferencePage_filter_label);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createFilterTable(container);
        this.createStepFilterButtons(container);
    }

    private void createFilterTable(Composite container) {
        TableLayoutComposite layouter = new TableLayoutComposite(container, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        layouter.setLayoutData((Object)new GridData(1808));
        this.fFilterTable = new Table((Composite)layouter, 67618);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setComparator((ViewerComparator)new FilterViewerSorter());
        this.fStackFilterContentProvider = new StackFilterContentProvider();
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStackFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                JUnitPreferencePage.this.fStackFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                JUnitPreferencePage.this.fRemoveFilterButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    private void createStepFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(JUnitMessages.JUnitPreferencePage_addfilterbutton_label);
        this.fAddFilterButton.setToolTipText(JUnitMessages.JUnitPreferencePage_addfilterbutton_tooltip);
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint(this.fAddFilterButton);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.editFilter();
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(JUnitMessages.JUnitPreferencePage_addtypebutton_label);
        this.fAddTypeButton.setToolTipText(JUnitMessages.JUnitPreferencePage_addtypebutton_tooltip);
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint(this.fAddTypeButton);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.addType();
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(JUnitMessages.JUnitPreferencePage_addpackagebutton_label);
        this.fAddPackageButton.setToolTipText(JUnitMessages.JUnitPreferencePage_addpackagebutton_tooltip);
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fAddPackageButton);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(JUnitMessages.JUnitPreferencePage_removefilterbutton_label);
        this.fRemoveFilterButton.setToolTipText(JUnitMessages.JUnitPreferencePage_removefilterbutton_tooltip);
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fRemoveFilterButton);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        this.fEnableAllButton = new Button(buttonContainer, 8);
        this.fEnableAllButton.setText(JUnitMessages.JUnitPreferencePage_enableallbutton_label);
        this.fEnableAllButton.setToolTipText(JUnitMessages.JUnitPreferencePage_enableallbutton_tooltip);
        gd = this.getButtonGridData(this.fEnableAllButton);
        this.fEnableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fEnableAllButton);
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.checkAllFilters(true);
            }
        });
        this.fDisableAllButton = new Button(buttonContainer, 8);
        this.fDisableAllButton.setText(JUnitMessages.JUnitPreferencePage_disableallbutton_label);
        this.fDisableAllButton.setToolTipText(JUnitMessages.JUnitPreferencePage_disableallbutton_tooltip);
        gd = this.getButtonGridData(this.fDisableAllButton);
        this.fDisableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fDisableAllButton);
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                JUnitPreferencePage.this.checkAllFilters(false);
            }
        });
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    private void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewStackFilter = this.fStackFilterContentProvider.addFilter(DEFAULT_NEW_FILTER_TEXT, true);
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        String platform = SWT.getPlatform();
        if ("win32".equals(platform) || "gtk".equals(platform)) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        this.fEditorText.setFont(JFaceResources.getDialogFont());
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewStackFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (JUnitPreferencePage.this.fInvalidEditorText != null) {
                        JUnitPreferencePage.this.fEditorText.setText(JUnitPreferencePage.this.fInvalidEditorText);
                        JUnitPreferencePage.this.fInvalidEditorText = null;
                    } else {
                        JUnitPreferencePage.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    JUnitPreferencePage.this.removeNewFilter();
                    JUnitPreferencePage.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (JUnitPreferencePage.this.fInvalidEditorText != null) {
                    JUnitPreferencePage.this.fEditorText.setText(JUnitPreferencePage.this.fInvalidEditorText);
                    JUnitPreferencePage.this.fInvalidEditorText = null;
                } else {
                    JUnitPreferencePage.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    private void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(JUnitMessages.JUnitPreferencePage_invalidstepfilterreturnescape);
                this.getShell().getDisplay().beep();
                return;
            }
            Object[] filters = this.fStackFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewStackFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private void cleanupEditor() {
        if (this.fEditorText == null) {
            return;
        }
        this.fNewStackFilter = null;
        this.fNewTableItem = null;
        this.fTableEditor.setEditor(null, null, 0);
        this.fEditorText.dispose();
        this.fEditorText = null;
    }

    private void removeNewFilter() {
        this.fStackFilterContentProvider.removeFilters(new Object[]{this.fNewStackFilter});
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) || firstChar == '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = JUnitMessages.JUnitPreferencePage_addtypedialog_title;
            String message = JUnitMessages.JUnitPreferencePage_addtypedialog_error_message;
            ExceptionHandler.handle((CoreException)((Object)jme), shell, title, message);
            return;
        }
        dialog.setTitle(JUnitMessages.JUnitPreferencePage_addtypedialog_title);
        dialog.setMessage(JUnitMessages.JUnitPreferencePage_addtypedialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            this.fStackFilterContentProvider.addFilter(type.getFullyQualifiedName('.'), true);
        }
    }

    private void addPackage() {
        Shell shell = this.getShell();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        IJavaSearchScope createWorkspaceScope = SearchEngine.createWorkspaceScope();
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)createWorkspaceScope, (boolean)true, (boolean)true, (String)DEFAULT_NEW_FILTER_TEXT);
        dialog.setTitle(JUnitMessages.JUnitPreferencePage_addpackagedialog_title);
        dialog.setMessage(JUnitMessages.JUnitPreferencePage_addpackagedialog_message);
        if (dialog.open() != 0) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages == null) {
            return;
        }
        int i = 0;
        while (i < packages.length) {
            IJavaElement pkg = (IJavaElement)packages[i];
            String filter = pkg.getElementName();
            filter = filter.length() < 1 ? JUnitMessages.JUnitMainTab_label_defaultpackage : String.valueOf(filter) + ".*";
            this.fStackFilterContentProvider.addFilter(filter, true);
            ++i;
        }
    }

    private void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fStackFilterContentProvider.removeFilters(selection.toArray());
    }

    private void checkAllFilters(boolean check) {
        Object[] filters = this.fStackFilterContentProvider.getElements(null);
        int i = filters.length - 1;
        while (i >= 0) {
            ((Filter)filters[i]).setChecked(check);
            --i;
        }
        this.fFilterViewer.setAllChecked(check);
    }

    public boolean performOk() {
        AssertionVMArg.setEnableAssertionsPreference(this.getAssertionCheckBoxSelection());
        this.fStackFilterContentProvider.saveFilters();
        return true;
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    private void setDefaultValues() {
        this.fEnableAssertionsCheckBox.setSelection(false);
        this.fStackFilterContentProvider.setDefaults();
    }

    protected List createActiveStackFiltersList() {
        return Arrays.asList(JUnitPreferencePage.getFilterPatterns());
    }

    protected List createInactiveStackFiltersList() {
        String[] strings = JUnitPreferencePage.parseList(this.getPreferenceStore().getString("org.eclipse.jdt.junit.inactive_filters"));
        return Arrays.asList(strings);
    }

    protected void updateActions() {
        if (this.fEnableAllButton == null) {
            return;
        }
        boolean enabled = this.fFilterViewer.getTable().getItemCount() > 0;
        this.fEnableAllButton.setEnabled(enabled);
        this.fDisableAllButton.setEnabled(enabled);
    }

    public static String[] getFilterPatterns() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return JUnitPreferencePage.parseList(store.getString("org.eclipse.jdt.junit.active_filters"));
    }

    public static boolean getFilterStack() {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.jdt.junit.do_filter_stack");
    }

    public static void setFilterStack(boolean filter) {
        IPreferenceStore store = JUnitPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.jdt.junit.do_filter_stack", filter);
    }

    private static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    private static class Filter {
        private String fName;
        private boolean fChecked;

        public Filter(String name, boolean checked) {
            this.setName(name);
            this.setChecked(checked);
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            this.fName = name;
        }

        public boolean isChecked() {
            return this.fChecked;
        }

        public void setChecked(boolean checked) {
            this.fChecked = checked;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            return this.getName().equals(other.getName());
        }

        public int hashCode() {
            return this.fName.hashCode();
        }
    }

    private static class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FilterLabelProvider() {
        }

        public String getColumnText(Object object, int column) {
            return column == 0 ? this.getText(object) : JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
        }

        public String getText(Object element) {
            return TextProcessor.process((String)((Filter)element).getName());
        }

        public Image getColumnImage(Object object, int column) {
            String name = ((Filter)object).getName();
            if (name.indexOf(".*") != -1 || name.equals(JUnitMessages.JUnitMainTab_label_defaultpackage)) {
                return IMG_PKG;
            }
            if (JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT.equals(name)) {
                return null;
            }
            if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) < 0) {
                return IMG_CUNIT;
            }
            int lastDotIndex = name.lastIndexOf(46);
            if (-1 != lastDotIndex && name.length() - 1 != lastDotIndex && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
                return IMG_CUNIT;
            }
            return null;
        }
    }

    private static class FilterViewerSorter
    extends ViewerComparator {
        private FilterViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            ILabelProvider lprov = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 == null) {
                name1 = JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name2 == null) {
                name2 = JUnitPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name1.length() > 0 && name2.length() > 0) {
                boolean isPackage2;
                boolean isPackage1 = name1.indexOf(42) != -1;
                boolean bl = isPackage2 = name2.indexOf(42) != -1;
                if (isPackage1 && !isPackage2) {
                    return -1;
                }
                if (isPackage2 && !isPackage1) {
                    return 1;
                }
            }
            return this.getComparator().compare(name1, name2);
        }
    }

    private class StackFilterContentProvider
    implements IStructuredContentProvider {
        private List fFilters;

        public StackFilterContentProvider() {
            List active = JUnitPreferencePage.this.createActiveStackFiltersList();
            List inactive = JUnitPreferencePage.this.createInactiveStackFiltersList();
            this.populateFilters(active, inactive);
        }

        public void setDefaults() {
            JUnitPreferencePage.this.fFilterViewer.remove(this.fFilters.toArray());
            List active = JUnitPreferencesConstants.createDefaultStackFiltersList();
            ArrayList inactive = new ArrayList();
            this.populateFilters(active, inactive);
        }

        protected void populateFilters(List activeList, List inactiveList) {
            this.fFilters = new ArrayList(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            if (inactiveList.size() != 0) {
                this.populateList(inactiveList, false);
            }
        }

        protected void populateList(List list, boolean checked) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.addFilter(name, checked);
            }
        }

        public Filter addFilter(String name, boolean checked) {
            Filter filter = new Filter(name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                JUnitPreferencePage.this.fFilterViewer.add((Object)filter);
                JUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, checked);
            }
            JUnitPreferencePage.this.updateActions();
            return filter;
        }

        public void saveFilters() {
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            Iterator iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                String name = filter.getName();
                if (filter.isChecked()) {
                    active.add(name);
                    continue;
                }
                inactive.add(name);
            }
            String pref = JUnitPreferencesConstants.serializeList(active.toArray(new String[active.size()]));
            JUnitPreferencePage.this.getPreferenceStore().setValue("org.eclipse.jdt.junit.active_filters", pref);
            pref = JUnitPreferencesConstants.serializeList(inactive.toArray(new String[inactive.size()]));
            JUnitPreferencePage.this.getPreferenceStore().setValue("org.eclipse.jdt.junit.inactive_filters", pref);
        }

        public void removeFilters(Object[] filters) {
            int i = filters.length - 1;
            while (i >= 0) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                --i;
            }
            JUnitPreferencePage.this.fFilterViewer.remove(filters);
            JUnitPreferencePage.this.updateActions();
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            JUnitPreferencePage.this.fFilterViewer.setChecked((Object)filter, newState);
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }
}

