/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.IApiProfile;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMemberDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IMethodDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.descriptors.IReferenceTypeDescriptor;
import org.eclipse.pde.api.tools.internal.provisional.search.ILocation;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.Messages;
import org.eclipse.pde.api.tools.ui.internal.wizards.ApiProfileWizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ApiToolsLabelProvider
extends BaseLabelProvider
implements ILabelProvider,
IFontProvider {
    private Font font = null;

    public void dispose() {
        if (this.font != null) {
            this.font.dispose();
        }
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element instanceof IApiComponent) {
            IApiComponent comp = (IApiComponent)element;
            if (comp.isSystemComponent()) {
                return ApiUIPlugin.getSharedImage("IMG_OBJ_API_SYSTEM_LIBRARY");
            }
            if (comp.isFragment()) {
                return ApiUIPlugin.getSharedImage("IMG_OBJ_FRAGMENT");
            }
            return ApiUIPlugin.getSharedImage("IMG_OBJ_BUNDLE");
        }
        if (element instanceof File) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (element instanceof IApiProfile) {
            return ApiUIPlugin.getSharedImage("IMG_OBJ_ECLIPSE_PROFILE");
        }
        if (element instanceof ApiProfileWizardPage.EEEntry) {
            return ApiUIPlugin.getSharedImage("IMG_OBJ_API_SYSTEM_LIBRARY");
        }
        if (element instanceof ILocation) {
            ILocation location = (ILocation)element;
            IMemberDescriptor member = location.getMember();
            switch (member.getElementType()) {
                case 2: {
                    return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
                }
            }
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof IApiComponent) {
            IApiComponent comp = (IApiComponent)element;
            return MessageFormat.format((String)Messages.ApiToolsLabelProvider_0, (Object[])new String[]{comp.getId(), comp.getVersion()});
        }
        if (element instanceof File) {
            try {
                return ((File)element).getCanonicalPath();
            }
            catch (IOException iOException) {
                return ((File)element).getName();
            }
        }
        if (element instanceof IApiProfile) {
            IApiProfile profile = (IApiProfile)element;
            return profile.getName();
        }
        if (element instanceof ApiProfileWizardPage.EEEntry) {
            return ((ApiProfileWizardPage.EEEntry)element).toString();
        }
        if (element instanceof ILocation) {
            ILocation location = (ILocation)element;
            IMemberDescriptor member = location.getMember();
            switch (member.getElementType()) {
                case 2: {
                    return ((IReferenceTypeDescriptor)member).getQualifiedName();
                }
                case 6: {
                    IMethodDescriptor method = (IMethodDescriptor)member;
                    StringBuffer buf = new StringBuffer();
                    buf.append(member.getEnclosingType().getQualifiedName());
                    buf.append('.');
                    buf.append(Signature.toString((String)method.getSignature(), (String)method.getName(), null, (boolean)false, (boolean)false));
                    return buf.toString();
                }
            }
            return member.getName();
        }
        return "<unknown>";
    }

    protected boolean isDefaultProfile(Object element) {
        if (element instanceof IApiProfile) {
            IApiProfile profile = (IApiProfile)element;
            IApiProfile def = ApiPlugin.getDefault().getApiProfileManager().getDefaultApiProfile();
            if (def != null) {
                return profile.getName().equals(def.getName());
            }
        }
        return false;
    }

    public Font getFont(Object element) {
        if (this.isDefaultProfile(element)) {
            if (this.font == null) {
                Font dialogFont = JFaceResources.getDialogFont();
                FontData[] fontData = dialogFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    FontData data = fontData[i];
                    data.setStyle(1);
                    ++i;
                }
                Display display = ApiUIPlugin.getShell().getDisplay();
                this.font = new Font((Device)display, fontData);
            }
            return this.font;
        }
        return null;
    }
}

