/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.markers;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.markers.CreateApiFilterOperation;
import org.eclipse.pde.api.tools.ui.internal.markers.MarkerMessages;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;

public class FilterProblemResolution
implements IMarkerResolution2 {
    protected IMarker fBackingMarker = null;
    protected IJavaElement fResolvedElement = null;
    protected String fCategory = null;

    public FilterProblemResolution(IMarker marker) {
        this.fBackingMarker = marker;
    }

    public String getDescription() {
        try {
            String value = (String)this.fBackingMarker.getAttribute("messagearguments");
            String[] args = new String[]{};
            if (value != null) {
                args = value.split("#");
            }
            int id = this.fBackingMarker.getAttribute("problemid", 0);
            return ApiProblemFactory.getLocalizedMessage((int)ApiProblemFactory.getProblemMessageId((int)id), (String[])args);
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_FILTER");
    }

    public String getLabel() {
        IJavaElement element = this.resolveElementFromMarker();
        if (element != null) {
            return MessageFormat.format((String)MarkerMessages.FilterProblemResolution_0, (Object[])new String[]{JavaElementLabels.getTextLabel((Object)element, (long)1L), this.resolveCategoryName()});
        }
        IResource res = this.fBackingMarker.getResource();
        return MessageFormat.format((String)MarkerMessages.FilterProblemResolution_0, (Object[])new String[]{res.getFullPath().removeFileExtension().lastSegment(), this.resolveCategoryName()});
    }

    protected String resolveCategoryName() {
        if (this.fCategory == null) {
            int problemid = this.fBackingMarker.getAttribute("problemid", -1);
            int category = ApiProblemFactory.getProblemCategory((int)problemid);
            switch (category) {
                case 0x10000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_compatible;
                    break;
                }
                case 0x50000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_default_profile;
                    break;
                }
                case 0x40000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_since_tag;
                    break;
                }
                case 0x20000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_usage;
                    break;
                }
                case 0x30000000: {
                    this.fCategory = MarkerMessages.FilterProblemResolution_version_number;
                }
            }
        }
        return this.fCategory;
    }

    protected IJavaElement resolveElementFromMarker() {
        if (this.fResolvedElement == null) {
            try {
                String handle = (String)this.fBackingMarker.getAttribute("org.eclipse.jdt.internal.core.JavaModelManager.handleId");
                if (handle != null) {
                    this.fResolvedElement = JavaCore.create((String)handle);
                }
            }
            catch (CoreException ce) {
                ApiUIPlugin.log(ce);
            }
        }
        return this.fResolvedElement;
    }

    public void run(IMarker marker) {
        CreateApiFilterOperation op = new CreateApiFilterOperation(this.fBackingMarker);
        op.setSystem(true);
        op.schedule();
    }
}

