/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.p2.ui.provisioner;

import java.io.File;
import java.net.URL;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningContext;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.ui.IRepositoryManipulator;
import org.eclipse.equinox.internal.provisional.p2.ui.actions.PropertyDialogAction;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.AvailableIUGroup;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.DefaultMetadataURLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.dialogs.URLValidator;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.AddColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.ProvisioningUtil;
import org.eclipse.equinox.internal.provisional.p2.ui.operations.RemoveColocatedRepositoryOperation;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.ProvPolicies;
import org.eclipse.equinox.internal.provisional.p2.ui.sdk.RepositoryManipulationDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.p2.ui.Activator;
import org.eclipse.pde.internal.p2.ui.SWTUtil;
import org.eclipse.pde.internal.p2.ui.provisioner.ProvisionerMessages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class P2TargetProvisionerWizardPage
extends WizardPage {
    private static final String DEFAULT_DIR_NAME = ".metadata/.plugins/org.eclipse.pde.core/target_plugins";
    private static final String USE_DEFAULT = "useDefault";
    private static final String CLEAR_CONTENTS = "clearContents";
    private static final String FOLDER_NAME = "folderName";
    static final IStatus BAD_IU_SELECTION = new Status(4, Activator.getUniqueIdentifier(), ProvisionerMessages.P2TargetProvisionerWizardPage_1);
    private static final IStatus DIR_DOES_NOT_EXIST = new Status(4, Activator.getUniqueIdentifier(), ProvisionerMessages.P2TargetProvisionerWizardPage_3);
    private IStatus fDirectoryStatus = Status.OK_STATUS;
    IStatus fSelectedIUStatus = BAD_IU_SELECTION;
    private String previousLocation;
    IInstallableUnit[] fUnits;
    private Link fLocationLink;
    private Text fInstallLocation;
    private Button fUseDefaultsButton;
    private Button fBrowseButton;
    private Button fClearContentsButton;
    AvailableIUGroup fAvailableIUGroup;
    Button fPropertiesButton;
    private IAction fPropertyAction;
    private IRepositoryManipulator fManipulator;

    protected P2TargetProvisionerWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createInstallFolderArea(composite);
        this.createAvailableIUArea(composite);
        this.setPageComplete(false);
        this.restoreWidgetState();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.p2_provisioning_page");
    }

    private void createInstallFolderArea(Composite composite) {
        Composite locationComp = new Composite(composite, 0);
        locationComp.setLayout((Layout)new GridLayout(3, false));
        locationComp.setFont(composite.getFont());
        locationComp.setLayoutData((Object)new GridData(768));
        this.fUseDefaultsButton = new Button(locationComp, 131104);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fUseDefaultsButton.setLayoutData((Object)gd);
        this.fUseDefaultsButton.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_4);
        this.fUseDefaultsButton.setSelection(true);
        this.fUseDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                if (button.getSelection()) {
                    P2TargetProvisionerWizardPage.this.fInstallLocation.setEnabled(false);
                    P2TargetProvisionerWizardPage.this.fBrowseButton.setEnabled(false);
                    P2TargetProvisionerWizardPage.this.previousLocation = P2TargetProvisionerWizardPage.this.fInstallLocation.getText();
                    P2TargetProvisionerWizardPage.this.fInstallLocation.setText(P2TargetProvisionerWizardPage.this.getDefaultDownloadLocation());
                } else {
                    P2TargetProvisionerWizardPage.this.fInstallLocation.setEnabled(true);
                    P2TargetProvisionerWizardPage.this.fBrowseButton.setEnabled(true);
                    P2TargetProvisionerWizardPage.this.fInstallLocation.setText(P2TargetProvisionerWizardPage.this.previousLocation);
                }
            }
        });
        this.fUseDefaultsButton.setSelection(true);
        this.fLocationLink = new Link(locationComp, 0);
        this.fLocationLink.setText("<a>" + ProvisionerMessages.P2TargetProvisionerWizardPage_0 + "</a>");
        this.fLocationLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    File file = P2TargetProvisionerWizardPage.this.getDownloadLocation(true);
                    if (file != null && file.isDirectory()) {
                        Program.launch((String)file.getCanonicalPath());
                    } else {
                        P2TargetProvisionerWizardPage.this.setErrorMessage(ProvisionerMessages.P2TargetProvisionerWizardPage_5);
                    }
                }
                catch (Exception ex) {
                    P2TargetProvisionerWizardPage.this.setErrorMessage(String.valueOf(ProvisionerMessages.P2TargetProvisionerWizardPage_6) + ex.getMessage());
                }
            }
        });
        this.fInstallLocation = new Text(locationComp, 2048);
        gd = new GridData(768);
        this.fInstallLocation.setLayoutData((Object)gd);
        this.previousLocation = this.getDefaultDownloadLocation();
        this.fInstallLocation.setText(this.previousLocation);
        this.fInstallLocation.setEnabled(false);
        this.fInstallLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                File location = P2TargetProvisionerWizardPage.this.getDownloadLocation(false);
                if (location == null || !location.exists() && !P2TargetProvisionerWizardPage.this.fUseDefaultsButton.getSelection()) {
                    P2TargetProvisionerWizardPage.this.fDirectoryStatus = DIR_DOES_NOT_EXIST;
                } else {
                    P2TargetProvisionerWizardPage.this.fDirectoryStatus = Status.OK_STATUS;
                }
                P2TargetProvisionerWizardPage.this.pageChanged();
            }
        });
        this.fBrowseButton = new Button(locationComp, 8);
        this.fBrowseButton.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_7);
        this.fBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                P2TargetProvisionerWizardPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.fBrowseButton.setEnabled(false);
        this.fBrowseButton.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.fBrowseButton);
        this.fClearContentsButton = new Button(locationComp, 131104);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fClearContentsButton.setLayoutData((Object)gd);
        this.fClearContentsButton.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_8);
        this.fClearContentsButton.setSelection(false);
    }

    private void createAvailableIUArea(Composite composite) {
        Group mainGroup = new Group(composite, 0);
        mainGroup.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_9);
        mainGroup.setLayout((Layout)new GridLayout(2, false));
        mainGroup.setFont(composite.getFont());
        mainGroup.setLayoutData((Object)new GridData(1808));
        this.fAvailableIUGroup = new AvailableIUGroup((Composite)mainGroup, ProvPolicies.getDefault().getQueryProvider(), mainGroup.getFont(), new ProvisioningContext());
        this.fAvailableIUGroup.getStructuredViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                P2TargetProvisionerWizardPage.this.fUnits = P2TargetProvisionerWizardPage.this.fAvailableIUGroup.getSelectedIUs();
                P2TargetProvisionerWizardPage.this.fPropertiesButton.setEnabled(P2TargetProvisionerWizardPage.this.fUnits.length > 0);
                P2TargetProvisionerWizardPage.this.fSelectedIUStatus = P2TargetProvisionerWizardPage.this.fUnits.length > 0 ? Status.OK_STATUS : BAD_IU_SELECTION;
                P2TargetProvisionerWizardPage.this.pageChanged();
            }
        });
        this.fAvailableIUGroup.setUseBoldFontForFilteredItems(true);
        GridData data = (GridData)this.fAvailableIUGroup.getStructuredViewer().getControl().getLayoutData();
        data.heightHint = 200;
        Composite iuButtonComp = new Composite((Composite)mainGroup, 0);
        iuButtonComp.setLayout((Layout)new GridLayout(1, false));
        iuButtonComp.setFont(mainGroup.getFont());
        iuButtonComp.setLayoutData((Object)new GridData(1808));
        this.fPropertiesButton = new Button(iuButtonComp, 8);
        this.fPropertiesButton.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_10);
        this.fPropertiesButton.setLayoutData((Object)new GridData(768));
        this.fPropertiesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                P2TargetProvisionerWizardPage.this.fPropertyAction.run();
            }
        });
        this.fPropertyAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.getShell()), (ISelectionProvider)this.fAvailableIUGroup.getStructuredViewer());
        this.fManipulator = new IRepositoryManipulator(){

            public String getManipulatorLabel() {
                return ProvisionerMessages.P2TargetProvisionerWizardPage_11;
            }

            public boolean manipulateRepositories(Shell shell) {
                new RepositoryManipulationDialog(shell, (IRepositoryManipulator)this).open();
                return true;
            }

            public ProvisioningOperation getAddOperation(URL repoURL) {
                return new AddColocatedRepositoryOperation(this.getAddOperationLabel(), repoURL);
            }

            public String getAddOperationLabel() {
                return ProvisionerMessages.P2TargetProvisionerWizardPage_12;
            }

            public URL[] getKnownRepositories() {
                try {
                    return ProvisioningUtil.getMetadataRepositories((int)0);
                }
                catch (ProvisionException provisionException) {
                    return new URL[0];
                }
            }

            public ProvisioningOperation getRemoveOperation(URL[] reposToRemove) {
                return new RemoveColocatedRepositoryOperation(this.getRemoveOperationLabel(), reposToRemove);
            }

            public String getRemoveOperationLabel() {
                return ProvisionerMessages.P2TargetProvisionerWizardPage_13;
            }

            public URLValidator getURLValidator(Shell shell) {
                return new DefaultMetadataURLValidator();
            }
        };
        Button editReposButton = new Button(iuButtonComp, 8);
        editReposButton.setLayoutData((Object)new GridData(768));
        editReposButton.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_11);
        editReposButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                P2TargetProvisionerWizardPage.this.fManipulator.manipulateRepositories(P2TargetProvisionerWizardPage.this.getShell());
            }
        });
    }

    void pageChanged() {
        if (this.fDirectoryStatus.getSeverity() == 4) {
            this.setErrorMessage(this.fDirectoryStatus.getMessage());
            this.setPageComplete(false);
        } else if (this.fSelectedIUStatus.getSeverity() == 4) {
            this.setErrorMessage(this.fSelectedIUStatus.getMessage());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private String getDefaultDownloadLocation() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (path != null) {
            return new File(path.toFile(), DEFAULT_DIR_NAME).toString();
        }
        return "";
    }

    private void handleLocationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fInstallLocation.getText());
        dialog.setText(ProvisionerMessages.P2TargetProvisionerWizardPage_16);
        dialog.setMessage(ProvisionerMessages.P2TargetProvisionerWizardPage_17);
        String result = dialog.open();
        if (result != null) {
            this.fInstallLocation.setText(result);
        }
    }

    void saveWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            if (this.fUseDefaultsButton.getSelection()) {
                settings.put(USE_DEFAULT, true);
            } else {
                settings.put(USE_DEFAULT, false);
                settings.put(FOLDER_NAME, this.fInstallLocation.getText());
            }
            settings.put(CLEAR_CONTENTS, this.fClearContentsButton.getSelection());
        }
    }

    private void restoreWidgetState() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String useDefaults;
            String location = settings.get(FOLDER_NAME);
            if (location != null && location.length() > 0) {
                this.previousLocation = location;
            }
            if ((useDefaults = settings.get(USE_DEFAULT)) != null) {
                boolean useDefaultsBoolean = Boolean.valueOf(useDefaults);
                this.fUseDefaultsButton.setSelection(useDefaultsBoolean);
                if (!useDefaultsBoolean) {
                    this.fInstallLocation.setText(this.previousLocation);
                    this.fInstallLocation.setEnabled(true);
                    this.fBrowseButton.setEnabled(true);
                }
            }
            this.fClearContentsButton.setSelection(Boolean.valueOf(settings.get(CLEAR_CONTENTS)).booleanValue());
        }
    }

    public IInstallableUnit[] getUnits() {
        return this.fUnits;
    }

    public File getDownloadLocation(boolean createIfDefault) {
        if (this.fInstallLocation.getText().trim().length() > 0) {
            File file = new File(this.fInstallLocation.getText());
            if (createIfDefault && this.fUseDefaultsButton.getSelection() && !file.isDirectory()) {
                file.mkdirs();
            }
            return file;
        }
        return null;
    }

    public boolean isClearContentsBeforeDownloading() {
        return this.fClearContentsButton.getSelection();
    }
}

