/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.ui.fix.AbstractCleanUp;
import org.eclipse.jdt.internal.ui.fix.ICleanUp;
import org.eclipse.jdt.internal.ui.fix.IMultiFix;
import org.eclipse.jdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public abstract class AbstractMultiFix
extends AbstractCleanUp
implements IMultiFix {
    protected AbstractMultiFix() {
    }

    protected AbstractMultiFix(Map settings) {
        super(settings);
    }

    public final IFix createFix(ICleanUp.CleanUpContext context) throws CoreException {
        CompilationUnit unit = context.getAST();
        if (unit == null) {
            return null;
        }
        if (context instanceof IMultiFix.MultiFixContext) {
            return this.createFix(unit, ((IMultiFix.MultiFixContext)context).getProblemLocations());
        }
        return this.createFix(unit);
    }

    protected abstract IFix createFix(CompilationUnit var1) throws CoreException;

    protected abstract IFix createFix(CompilationUnit var1, IProblemLocation[] var2) throws CoreException;

    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        return -1;
    }

    protected static int getNumberOfProblems(IProblem[] problems, int problemId) {
        int result = 0;
        int i = 0;
        while (i < problems.length) {
            if (problems[i].getID() == problemId) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    protected static IProblemLocation[] convertProblems(IProblem[] problems) {
        IProblemLocation[] result = new IProblemLocation[problems.length];
        int i = 0;
        while (i < problems.length) {
            result[i] = new ProblemLocation(problems[i]);
            ++i;
        }
        return result;
    }

    protected static IProblemLocation[] filter(IProblemLocation[] problems, int[] problemIds) {
        ArrayList<IProblemLocation> result = new ArrayList<IProblemLocation>();
        int i = 0;
        while (i < problems.length) {
            IProblemLocation problem = problems[i];
            if (AbstractMultiFix.contains(problemIds, problem.getProblemId()) && !AbstractMultiFix.contains(result, problem)) {
                result.add(problem);
            }
            ++i;
        }
        return result.toArray(new IProblemLocation[result.size()]);
    }

    private static boolean contains(ArrayList problems, IProblemLocation problem) {
        int i = 0;
        while (i < problems.size()) {
            IProblemLocation existing = (IProblemLocation)problems.get(i);
            if (existing.getProblemId() == problem.getProblemId() && existing.getOffset() == problem.getOffset() && existing.getLength() == problem.getLength()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean contains(int[] ids, int id) {
        int i = 0;
        while (i < ids.length) {
            if (ids[i] == id) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

