/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.cleanup.ICleanUpTabPage;
import org.eclipse.jdt.internal.ui.preferences.formatter.IModifyDialogTabPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public abstract class CleanUpSelectionDialog
extends StatusDialog
implements IModifyDialogTabPage.IModificationListener {
    private static final String DS_KEY_PREFERRED_WIDTH = ".preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = ".preferred_height";
    private static final String DS_KEY_PREFERRED_X = ".preferred_x";
    private static final String DS_KEY_PREFERRED_Y = ".preferred_y";
    private static final String DS_KEY_LAST_FOCUS = ".last_focus";
    private final Map fWorkingValues;
    private final List fTabPages;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private ICleanUpTabPage[] fPages;
    private Label fCountLabel;

    public CleanUpSelectionDialog(Shell parent, Map settings, String title) {
        super(parent);
        this.setTitle(title);
        this.fWorkingValues = settings;
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
    }

    protected boolean isResizable() {
        return true;
    }

    protected abstract NamedCleanUpTabPage[] createTabPages(Map var1);

    protected abstract String getPreferenceKeyPrefix();

    protected abstract String getSelectionCountMessage(int var1, int var2);

    protected abstract String getEmptySelectionMessage();

    protected Map getWorkingValues() {
        return this.fWorkingValues;
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(this.getPreferenceKeyWidth(), shell.width);
        this.fDialogSettings.put(this.getPreferenceKeyHeight(), shell.height);
        this.fDialogSettings.put(this.getPreferenceKeyPositionX(), shell.x);
        this.fDialogSettings.put(this.getPreferenceKeyPositionY(), shell.y);
        return super.close();
    }

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(this.getPreferenceKeyFocus());
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            lastFocusNr = 0;
        }
        this.fTabFolder.setSelection(lastFocusNr);
        ((IModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        NamedCleanUpTabPage[] pages = this.createTabPages(this.fWorkingValues);
        this.fPages = new ICleanUpTabPage[pages.length];
        int i = 0;
        while (i < pages.length) {
            this.fPages[i] = pages[i].getPage();
            this.addTabPage(pages[i].getName(), this.fPages[i]);
            ++i;
        }
        this.fCountLabel = new Label(composite, 0);
        this.fCountLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.updateCountLabel();
        CleanUpSelectionDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                IModifyDialogTabPage page = (IModifyDialogTabPage)tabItem.getData();
                CleanUpSelectionDialog.this.fDialogSettings.put(CleanUpSelectionDialog.this.getPreferenceKeyFocus(), CleanUpSelectionDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        this.updateStatus(StatusInfo.OK_STATUS);
        return composite;
    }

    public void updateStatus(IStatus status) {
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        if (count == 0) {
            super.updateStatus((IStatus)new Status(4, "org.eclipse.jdt.ui", this.getEmptySelectionMessage()));
        } else if (status == null) {
            super.updateStatus(StatusInfo.OK_STATUS);
        } else {
            super.updateStatus(status);
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(this.getPreferenceKeyWidth());
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(this.getPreferenceKeyHeight()))) {
                lastHeight = initialSize.y;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(this.getPreferenceKeyPositionX()), this.fDialogSettings.getInt(this.getPreferenceKeyPositionY()));
        }
        catch (NumberFormatException numberFormatException) {
            return super.getInitialLocation(initialSize);
        }
    }

    private final void addTabPage(String title, IModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        CleanUpSelectionDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    public void valuesModified() {
        this.updateCountLabel();
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    private void updateCountLabel() {
        int size = 0;
        int count = 0;
        int i = 0;
        while (i < this.fPages.length) {
            size += this.fPages[i].getCleanUpCount();
            count += this.fPages[i].getSelectedCleanUpCount();
            ++i;
        }
        this.fCountLabel.setText(this.getSelectionCountMessage(count, size));
    }

    private String getPreferenceKeyWidth() {
        return String.valueOf(this.getPreferenceKeyPrefix()) + DS_KEY_PREFERRED_WIDTH;
    }

    private String getPreferenceKeyHeight() {
        return String.valueOf(this.getPreferenceKeyPrefix()) + DS_KEY_PREFERRED_HEIGHT;
    }

    private String getPreferenceKeyPositionY() {
        return String.valueOf(this.getPreferenceKeyPrefix()) + DS_KEY_PREFERRED_Y;
    }

    private String getPreferenceKeyFocus() {
        return String.valueOf(this.getPreferenceKeyPrefix()) + DS_KEY_LAST_FOCUS;
    }

    private String getPreferenceKeyPositionX() {
        return String.valueOf(this.getPreferenceKeyPrefix()) + DS_KEY_PREFERRED_X;
    }

    protected final class NamedCleanUpTabPage {
        private final String fName;
        private final ICleanUpTabPage fPage;

        public NamedCleanUpTabPage(String name, ICleanUpTabPage page) {
            this.fName = name;
            this.fPage = page;
        }

        public ICleanUpTabPage getPage() {
            return this.fPage;
        }

        public String getName() {
            return this.fName;
        }
    }
}

