/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.JavaElementMatch;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchResultPage;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ColoringLabelProvider;
import org.eclipse.jdt.internal.ui.viewsupport.ImageImageDescriptor;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public abstract class SearchLabelProvider
extends AppearanceAwareLabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.jdt.search.matchCount";
    private static final String EMPHASIZE_POTENTIAL_MATCHES = "org.eclipse.search.potentialMatch.emphasize";
    private static final String POTENTIAL_MATCH_FG_COLOR = "org.eclipse.search.potentialMatch.fgColor";
    protected static final long DEFAULT_SEARCH_TEXTFLAGS = 36421324767241L;
    protected static final int DEFAULT_SEARCH_IMAGEFLAGS = 1;
    private Color fPotentialMatchFgColor;
    private Map fLabelProviderMap;
    protected JavaSearchResultPage fPage;
    private ScopedPreferenceStore fSearchPreferences;
    private IPropertyChangeListener fSearchPropertyListener;
    private Map fImages;

    public SearchLabelProvider(JavaSearchResultPage page) {
        super(36421324767241L, 1);
        this.addLabelDecorator(new ProblemsLabelDecorator(null));
        this.fPage = page;
        this.fLabelProviderMap = new HashMap(5);
        this.fSearchPreferences = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.search");
        this.fSearchPropertyListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SearchLabelProvider.this.doSearchPropertyChange(event);
            }
        };
        this.fSearchPreferences.addPropertyChangeListener(this.fSearchPropertyListener);
        this.fImages = null;
    }

    final void doSearchPropertyChange(PropertyChangeEvent event) {
        if (this.fPotentialMatchFgColor == null) {
            return;
        }
        if (POTENTIAL_MATCH_FG_COLOR.equals(event.getProperty()) || EMPHASIZE_POTENTIAL_MATCHES.equals(event.getProperty())) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
            LabelProviderChangedEvent lpEvent = new LabelProviderChangedEvent((IBaseLabelProvider)this, null);
            this.fireLabelProviderChanged(lpEvent);
        }
    }

    public Color getForeground(Object element) {
        if (this.arePotentialMatchesEmphasized() && this.getNumberOfPotentialMatches(element) > 0) {
            return this.getForegroundColor();
        }
        return super.getForeground(element);
    }

    private Color getForegroundColor() {
        if (this.fPotentialMatchFgColor == null) {
            this.fPotentialMatchFgColor = new Color((Device)JavaPlugin.getActiveWorkbenchShell().getDisplay(), this.getPotentialMatchForegroundColor());
        }
        return this.fPotentialMatchFgColor;
    }

    protected final int getNumberOfPotentialMatches(Object element) {
        int res = 0;
        AbstractTextSearchResult result = this.fPage.getInput();
        if (result != null) {
            Match[] matches = result.getMatches(element);
            int i = 0;
            while (i < matches.length) {
                if (matches[i] instanceof JavaElementMatch && ((JavaElementMatch)matches[i]).getAccuracy() == 1) {
                    ++res;
                }
                ++i;
            }
        }
        return res;
    }

    protected final StyledString getColoredLabelWithCounts(Object element, StyledString coloredName) {
        String name = coloredName.getString();
        String decorated = this.getLabelWithCounts(element, name);
        if (decorated.length() > name.length()) {
            ColoringLabelProvider.decorateStyledString(coloredName, decorated, StyledString.COUNTER_STYLER);
        }
        return coloredName;
    }

    protected final String getLabelWithCounts(Object element, String elementName) {
        int matchCount = this.fPage.getDisplayedMatchCount(element);
        int potentialCount = this.getNumberOfPotentialMatches(element);
        if (matchCount < 2) {
            if (matchCount == 1 && this.hasChildren(element)) {
                if (potentialCount > 0) {
                    return Messages.format(SearchMessages.SearchLabelProvider_potential_singular, elementName);
                }
                return Messages.format(SearchMessages.SearchLabelProvider_exact_singular, elementName);
            }
            if (potentialCount > 0) {
                return Messages.format(SearchMessages.SearchLabelProvider_potential_noCount, elementName);
            }
            return Messages.format(SearchMessages.SearchLabelProvider_exact_noCount, elementName);
        }
        int exactCount = matchCount - potentialCount;
        if (potentialCount > 0 && exactCount > 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount), String.valueOf(exactCount), String.valueOf(potentialCount)};
            return Messages.format(SearchMessages.SearchLabelProvider_exact_and_potential_plural, args);
        }
        if (exactCount == 0) {
            Object[] args = new String[]{elementName, String.valueOf(matchCount)};
            return Messages.format(SearchMessages.SearchLabelProvider_potential_plural, args);
        }
        Object[] args = new String[]{elementName, String.valueOf(matchCount)};
        return Messages.format(SearchMessages.SearchLabelProvider_exact_plural, args);
    }

    protected boolean hasChildren(Object elem) {
        return false;
    }

    public void dispose() {
        if (this.fPotentialMatchFgColor != null) {
            this.fPotentialMatchFgColor.dispose();
            this.fPotentialMatchFgColor = null;
        }
        this.fSearchPreferences.removePropertyChangeListener(this.fSearchPropertyListener);
        Iterator labelProviders = this.fLabelProviderMap.values().iterator();
        while (labelProviders.hasNext()) {
            ILabelProvider labelProvider = (ILabelProvider)labelProviders.next();
            labelProvider.dispose();
        }
        if (this.fImages != null) {
            Iterator iterator = this.fImages.values().iterator();
            while (iterator.hasNext()) {
                Image image = (Image)iterator.next();
                image.dispose();
            }
            this.fImages = null;
        }
        this.fSearchPreferences = null;
        this.fSearchPropertyListener = null;
        this.fLabelProviderMap.clear();
        super.dispose();
    }

    public void addListener(ILabelProviderListener listener) {
        super.addListener(listener);
        Iterator labelProviders = this.fLabelProviderMap.values().iterator();
        while (labelProviders.hasNext()) {
            ILabelProvider labelProvider = (ILabelProvider)labelProviders.next();
            labelProvider.addListener(listener);
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        if (PROPERTY_MATCH_COUNT.equals(property)) {
            return true;
        }
        return this.getLabelProvider(element).isLabelProperty(element, property);
    }

    public void removeListener(ILabelProviderListener listener) {
        super.removeListener(listener);
        Iterator labelProviders = this.fLabelProviderMap.values().iterator();
        while (labelProviders.hasNext()) {
            ILabelProvider labelProvider = (ILabelProvider)labelProviders.next();
            labelProvider.removeListener(listener);
        }
    }

    protected String getParticipantText(Object element) {
        ILabelProvider labelProvider = this.getLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        return "";
    }

    protected Image getParticipantImage(Object element) {
        ILabelProvider lp = this.getLabelProvider(element);
        if (lp == null) {
            return null;
        }
        Image image = lp.getImage(element);
        if (image != null) {
            // empty if block
        }
        return image;
    }

    private Image getSizeCorrectedImage(Image image, Point expectedWidth) {
        if (this.fImages != null) {
            Image newImage = (Image)this.fImages.get(image);
            if (newImage != null) {
                return newImage;
            }
        } else {
            this.fImages = new HashMap();
        }
        ImageImageDescriptor desc = new ImageImageDescriptor(image);
        Image newImage = new JavaElementImageDescriptor(desc, 0, expectedWidth).createImage();
        this.fImages.put(image, newImage);
        return newImage;
    }

    private ILabelProvider getLabelProvider(Object element) {
        AbstractTextSearchResult input = this.fPage.getInput();
        if (!(input instanceof JavaSearchResult)) {
            return null;
        }
        IMatchPresentation participant = ((JavaSearchResult)input).getSearchParticpant(element);
        if (participant == null) {
            return null;
        }
        ILabelProvider lp = (ILabelProvider)this.fLabelProviderMap.get(participant);
        if (lp == null) {
            lp = participant.createLabelProvider();
            this.fLabelProviderMap.put(participant, lp);
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                lp.addListener((ILabelProviderListener)listeners[i]);
                ++i;
            }
        }
        return lp;
    }

    private boolean arePotentialMatchesEmphasized() {
        return this.fSearchPreferences.getBoolean(EMPHASIZE_POTENTIAL_MATCHES);
    }

    private RGB getPotentialMatchForegroundColor() {
        return PreferenceConverter.getColor((IPreferenceStore)this.fSearchPreferences, (String)POTENTIAL_MATCH_FG_COLOR);
    }
}

