/****************************************************************************
**
** Copyright (C) 2006-2008 fullmetalcoder <fullmetalcoder@hotmail.fr>
**
** This file is part of the Edyuk project <http://edyuk.org>
** 
** This file may be used under the terms of the GNU General Public License
** version 3 as published by the Free Software Foundation and appearing in the
** file GPL.txt included in the packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef _QDEBUGGING_ENGINE_H_
#define _QDEBUGGING_ENGINE_H_

#include "edyuk.h"

/*!
	\file qdebuggingengine.h
	
	\brief Definition of the QDebuggingEngine class
*/

#include <QObject>
#include <QStringList>

#include "qmdiclient.h"

#include "qdebugger.h"

struct QLineMark;

class EDYUK_EXPORT QDebuggingEngine : public QObject
{
	friend class QDebugger;
	
	Q_OBJECT
	
	public:
		QDebuggingEngine(QObject *p = 0);
		virtual ~QDebuggingEngine();
		
		static QDebuggingEngine* instance();
		
	public slots:
		void retranslate();
		
		void addDebugger(QDebugger *b);
		void setActiveTarget(const QString& target);
		void setTargets(const QString& src, const QStringList& targets);
		
	signals:
		void started();
		void log(const QString& line);
		void mergingRequested(qmdiClient *c, bool on);
		void widgetInsertionRequested(QWidget *w, bool on);
		
	private slots:
		void lineMarkAdded(const QLineMark& mark);
		void lineMarkRemoved(const QLineMark& mark);
		
	private:
		QDebugger *m_cdbg;
		QList<QDebugger*> m_debuggers;
		
		QStringList m_targets;
		QString m_activeTarget, m_activeSource;
};

#endif // !_QDEBUGGING_ENGINE_H_
