/****************************************************************************
**
** Copyright (C) 2006-2008 fullmetalcoder <fullmetalcoder@hotmail.fr>
**
** This file is part of the Edyuk project <http://edyuk.org>
** 
** This file may be used under the terms of the GNU General Public License
** version 3 as published by the Free Software Foundation and appearing in the
** file GPL.txt included in the packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef _QDOCUMENT_CURSOR_H_
#define _QDOCUMENT_CURSOR_H_

#include "qce-config.h"

class QString;

class QDocument;
class QDocumentLine;
struct QDocumentSelection;
class QDocumentCursorHandle;

class QCE_EXPORT QDocumentCursor
{
	public:
		enum MoveMode
		{
			MoveAnchor,
			KeepAnchor
		};
		
		enum MoveOperation
		{
			NoMove,
			Up,
			Down,
			Left,
			PreviousCharacter = Left,
			Right,
			NextCharacter = Right,
			Start,
			StartOfLine,
			StartOfBlock = StartOfLine,
			StartOfWord,
			PreviousBlock,
			PreviousLine = PreviousBlock,
			PreviousWord,
			WordLeft,
			WordRight,
			End,
			EndOfLine,
			EndOfBlock = EndOfLine,
			EndOfWord,
			NextWord,
			NextBlock,
			NextLine = NextBlock
		};
		
		enum SelectionType
		{
			WordUnderCursor,
			LineUnderCursor
		};
		
		explicit QDocumentCursor(QDocument *doc);
		QDocumentCursor(const QDocumentCursor& cursor);
		QDocumentCursor(QDocument *doc, int line, int column = 0);
		//QDocumentCursor(const QDocumentLine& line, int column = 0);
		QDocumentCursor(QDocumentCursorHandle* handle = 0);
		
		~QDocumentCursor();
		
		QDocumentCursor clone() const;
		
		QDocumentCursor& operator = (const QDocumentCursor& c);
		
		bool operator == (const QDocumentCursor& c) const;
		bool operator != (const QDocumentCursor& c) const;
		
		bool operator < (const QDocumentCursor& c) const;
		bool operator > (const QDocumentCursor& c) const;
		
		bool operator <= (const QDocumentCursor& c) const;
		bool operator >= (const QDocumentCursor& c) const;
		
		bool isNull() const;
		bool isValid() const;
		
		bool atEnd() const;
		bool atStart() const;
		
		bool atBlockEnd() const;
		bool atBlockStart() const;
		
		bool atLineEnd() const;
		bool atLineStart() const;
		
		bool hasSelection() const;
		
		bool isSilent() const;
		void setSilent(bool y);
		
		bool isAutoUpdated() const;
		void setAutoUpdated(bool y);
		
		int position() const;
		
		int lineNumber() const;
		int anchorColumn() const;
		int visualColumn() const;
		int columnNumber() const;
		void setColumnNumber(int c, MoveMode m = MoveAnchor);
		
		QDocumentLine line() const;
		
		void shift(int offset);
		void setPosition(int pos, MoveMode m = MoveAnchor);
		bool movePosition(int offset, MoveOperation op = NextCharacter, MoveMode m = MoveAnchor);
		
		void moveTo(int line, int column);
		void moveTo(const QDocumentCursor &c);
		void moveTo(const QDocumentLine &l, int column);
		
		void insertLine();
		void insertText(const QString& s);
		
		QDocumentCursor selectionStart() const;
		QDocumentCursor selectionEnd() const;
		
		QString selectedText() const;
		
		void clearSelection();
		void removeSelectedText();
		
		void select(SelectionType t);
		void setSelectionBoundary(const QDocumentCursor& c);
		
		bool isWithinSelection(const QDocumentCursor& c) const;
		
		void deleteChar();
		void deletePreviousChar();
		
		void beginEditBlock();
		void endEditBlock();
		
		QDocumentSelection selection() const;
		
		QDocument* document() const;
		
		inline QDocumentCursorHandle* handle() const
		{ return m_handle; }
		
	private:
		QDocumentCursorHandle *m_handle;
};

#endif
