/****************************************************************************
**
** Copyright (C) 2006-2008 fullmetalcoder <fullmetalcoder@hotmail.fr>
**
** This file is part of the Edyuk project <http://edyuk.org>
** 
** This file may be used under the terms of the GNU General Public License
** version 3 as published by the Free Software Foundation and appearing in the
** file GPL.txt included in the packaging of this file.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
****************************************************************************/

#ifndef _QMDI_HOST_H_
#define _QMDI_HOST_H_

/*!
	\file qmdihost.h
	\brief Definition of the qmdi host class
	
	modification of Elcuco's qmdilib for use with Edyuk
	
	\see qmdiHost
*/

class QMainWindow;
class qmdiClient;

#include "actiongrouplist.h"

class QMDI_API qmdiHost
{
	public:
		qmdiHost();
		virtual ~qmdiHost();
		
		void updateGUI(QMainWindow *window);
		
		void mergeClient(qmdiClient *client);
		void unmergeClient(qmdiClient *client);
		
		virtual QString filters() const;
		
		virtual qmdiClient* createEmptyClient();
		
		virtual void clientOpened(qmdiClient *c);
		virtual void clientClosed(qmdiClient *c);
		virtual void currentClientChanged(qmdiClient *c);
		
	protected:
		bool m_locked;
		
		qmdiActionGroupList toolbars;
		qmdiActionGroupList menus;
		
		QList<QToolBar*> toolBarList;
};

#endif // _QMDI_CLIENT_H_
