#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (c) 2002 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Eric4 Helpviewer

This is the main Python script that performs the neccessary initialization
of the helpviewer and starts the Qt event loop. This is a standalone version
of the integrated helpviewer.
"""

import sys, os
import os

# disable the usage of KDE widgets, if requested
sys.e4nokde = False
if "--nokde" in sys.argv:
    del sys.argv[sys.argv.index("--nokde")]
    os.environ["e4nokde"] = "1"
    sys.e4nokde = True
else:
    sys.e4nokde = os.getenv("e4nokde") is not None and os.getenv("e4nokde") == "1"

from Utilities import Startup
import Utilities

def createMainWidget(argv):
    """
    Function to create the main widget.
    
    @param argv list of commandline parameters (list of strings)
    @return reference to the main widget (QWidget)
    """
    from Helpviewer.HelpWindow import HelpWindow
    
    try:
        home = argv[1]
    except IndexError:
        home = None
    if (home and not os.path.exists(home)) or home is None:
        import Preferences
        home = Utilities.normjoinpath(\
            unicode(Preferences.getQt4DocDir()), 'index.html')
        if not os.path.exists(home):
            home = None
    
    help = HelpWindow(home, '.', None, 'help viewer')
    return help

def main():
    """
    Main entry point into the application.
    """
    options = [\
        ("--nokde" , "don't use KDE widgets"),
    ]
    appinfo = Startup.makeAppInfo(sys.argv,
                                  "Eric4 help viewer",
                                  "file",
                                  "HTML help browser",
                                  options)
    res = Startup.simpleAppStartup(sys.argv,
                                   appinfo,
                                   createMainWidget,
                                   [('!+file', '')])
    sys.exit(res)

if __name__ == '__main__':
    main()
