# -*- coding: utf-8 -*-
#
# This module contains the configuration of the individual eric4 installation
#

_pkg_config = {
    'ericDir'              : r'/usr/lib/python2.5/site-packages/eric4',
    'ericPixDir'           : r'/usr/lib/python2.5/site-packages/eric4/pixmaps',
    'ericIconDir'          : r'/usr/lib/python2.5/site-packages/eric4/icons',
    'ericDTDDir'           : r'/usr/lib/python2.5/site-packages/eric4/DTDs',
    'ericCSSDir'           : r'/usr/lib/python2.5/site-packages/eric4/CSSs',
    'ericStylesDir'        : r'/usr/lib/python2.5/site-packages/eric4/Styles',
    'ericDocDir'           : r'/usr/lib/python2.5/site-packages/eric4/Documentation',
    'ericExamplesDir'      : r'/usr/lib/python2.5/site-packages/eric4/Examples',
    'ericTranslationsDir'  : r'/usr/lib/python2.5/site-packages/eric4/i18n',
    'ericTemplatesDir'     : r'/usr/lib/python2.5/site-packages/eric4/DesignerTemplates',
    'ericCodeTemplatesDir' : r'/usr/lib/python2.5/site-packages/eric4/CodeTemplates',
    'ericOthersDir'        : r'/usr/lib/python2.5/site-packages/eric4',
    'bindir'               : r'/usr/bin',
    'mdir'                 : r'/usr/lib/python2.5/site-packages',
    'apidir'               : r'/opt/qt4/qsci/api',
    'apis'                 : ['zope-2.10.5.api', 'zope-3.3.1.api', 'eric4.api', 'Ruby-1.8.7.api', 'eric4.api'],
}

def getConfig(name):
    '''
    Module function to get a configuration value.

    @param name the name of the configuration value (string).
    '''
    try:
        return _pkg_config[name]
    except KeyError:
        pass

    raise AttributeError, '"%s" is not a valid configuration value' % name
