# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Application configuration page.
"""

import os

from PyQt4.QtCore import QVariant, pyqtSignature
from PyQt4.QtGui import QFileDialog

from KdeQt import KQFileDialog

from E4Gui.E4Completers import E4DirCompleter

from ConfigurationPageBase import ConfigurationPageBase
from Ui_ApplicationPage import Ui_ApplicationPage

import Preferences
import Utilities

class ApplicationPage(ConfigurationPageBase, Ui_ApplicationPage):
    """
    Class implementing the Application configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("ApplicationPage")
        
        self.downloadDirCompleter = E4DirCompleter(self.downloadDirEdit)
        
        self.proxyTypeCombo.addItem(self.trUtf8("Transparent HTTP"), QVariant(0))
        self.proxyTypeCombo.addItem(self.trUtf8("Caching HTTP"), QVariant(1))
        self.proxyTypeCombo.addItem(self.trUtf8("Socks5"), QVariant(2))
        
        # set initial values
        self.singleApplicationCheckBox.setChecked(\
            Preferences.getUI("SingleApplicationMode"))
        self.splashScreenCheckBox.setChecked(\
            Preferences.getUI("ShowSplash"))
        
        openOnStartup = Preferences.getUI("OpenOnStartup")
        if openOnStartup == 0:
            self.noOpenRadioButton.setChecked(True)
        elif openOnStartup == 1:
            self.lastFileRadioButton.setChecked(True)
        elif openOnStartup == 2:
            self.lastProjectRadioButton.setChecked(True)
        elif openOnStartup == 3:
            self.lastMultiprojectRadioButton.setChecked(True)
        elif openOnStartup == 4:
            self.globalSessionRadioButton.setChecked(True)
        
        period = Preferences.getUI("PerformVersionCheck")
        if period == 0:
            self.noCheckRadioButton.setChecked(True)
        elif period == 1:
            self.alwaysCheckRadioButton.setChecked(True)
        elif period == 2:
            self.dailyCheckRadioButton.setChecked(True)
        elif period == 3:
            self.weeklyCheckRadioButton.setChecked(True)
        elif period == 4:
            self.monthlyCheckRadioButton.setChecked(True)
        
        self.downloadDirEdit.setText(Preferences.getUI("DownloadPath"))
        self.proxyGroup.setChecked(\
            Preferences.getUI("UseProxy"))
        self.proxyTypeCombo.setCurrentIndex(self.proxyTypeCombo.findData(\
            QVariant(Preferences.getUI("ProxyType"))))
        self.proxyHostEdit.setText(\
            Preferences.getUI("ProxyHost"))
        self.proxyUserEdit.setText(\
            Preferences.getUI("ProxyUser"))
        self.proxyPasswordEdit.setText(\
            Preferences.getUI("ProxyPassword"))
        self.proxyPortSpin.setValue(\
            Preferences.getUI("ProxyPort"))
        
    def save(self):
        """
        Public slot to save the Application configuration.
        """
        Preferences.setUI("SingleApplicationMode",
            int(self.singleApplicationCheckBox.isChecked()))
        Preferences.setUI("ShowSplash",
            int(self.splashScreenCheckBox.isChecked()))
        
        if self.noOpenRadioButton.isChecked():
            openOnStartup = 0
        elif self.lastFileRadioButton.isChecked():
            openOnStartup = 1
        elif self.lastProjectRadioButton.isChecked():
            openOnStartup = 2
        elif self.lastMultiprojectRadioButton.isChecked():
            openOnStartup = 3
        elif self.globalSessionRadioButton.isChecked():
            openOnStartup = 4
        Preferences.setUI("OpenOnStartup", openOnStartup)
        
        if self.noCheckRadioButton.isChecked():
            period = 0
        elif self.alwaysCheckRadioButton.isChecked():
            period = 1
        elif self.dailyCheckRadioButton.isChecked():
            period = 2
        elif self.weeklyCheckRadioButton.isChecked():
            period = 3
        elif self.monthlyCheckRadioButton.isChecked():
            period = 4
        Preferences.setUI("PerformVersionCheck", period)
        
        Preferences.setUI("DownloadPath", 
            self.downloadDirEdit.text())
        Preferences.setUI("UseProxy",
            int(self.proxyGroup.isChecked()))
        Preferences.setUI("ProxyType", 
            self.proxyTypeCombo.itemData(self.proxyTypeCombo.currentIndex()).toInt()[0])
        Preferences.setUI("ProxyHost",
            self.proxyHostEdit.text())
        Preferences.setUI("ProxyUser",
            self.proxyUserEdit.text())
        Preferences.setUI("ProxyPassword",
            self.proxyPasswordEdit.text())
        Preferences.setUI("ProxyPort",
            self.proxyPortSpin.value())
    
    @pyqtSignature("")
    def on_downloadDirButton_clicked(self):
        """
        Private slot to handle the directory selection via dialog.
        """
        directory = KQFileDialog.getExistingDirectory(\
            self,
            self.trUtf8("Select download directory"),
            self.downloadDirEdit.text(),
            QFileDialog.Options(QFileDialog.ShowDirsOnly))
            
        if not directory.isNull():
            dn = unicode(Utilities.toNativeSeparators(directory))
            while dn.endswith(os.sep):
                dn = dn[:-1]
            self.downloadDirEdit.setText(dn)
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = ApplicationPage()
    return page
