# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Editor General configuration page.
"""

import QScintilla.Lexers

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorFilePage import Ui_EditorFilePage

import Preferences

class EditorFilePage(ConfigurationPageBase, Ui_EditorFilePage):
    """
    Class implementing the Editor File configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorFilePage")
        
        self.openFilesFilterComboBox.addItems(\
            QScintilla.Lexers.getOpenFileFiltersList(True))
        self.saveFilesFilterComboBox.addItems(\
            QScintilla.Lexers.getSaveFileFiltersList(True))
        
        # set initial values
        self.autosaveSlider.setValue(\
            Preferences.getEditor("AutosaveInterval"))
        self.createBackupFileCheckBox.setChecked(\
            Preferences.getEditor("CreateBackupFile"))
        self.automaticSyntaxCheckCheckBox.setChecked(\
            Preferences.getEditor("AutoCheckSyntax"))
        self.defaultEncodingComboBox.setCurrentIndex(\
            self.defaultEncodingComboBox.findText(\
                Preferences.getEditor("DefaultEncoding")))
        self.warnFilesizeSpinBox.setValue(\
            Preferences.getEditor("WarnFilesize"))
        self.clearBreakpointsCheckBox.setChecked(\
            Preferences.getEditor("ClearBreaksOnClose"))
        self.automaticReopenCheckBox.setChecked(\
            Preferences.getEditor("AutoReopen"))
        self.stripWhitespaceCheckBox.setChecked(\
            Preferences.getEditor("StripTrailingWhitespace"))
        self.openFilesFilterComboBox.setCurrentIndex(\
            self.openFilesFilterComboBox.findText(\
                Preferences.getEditor("DefaultOpenFilter")))
        self.saveFilesFilterComboBox.setCurrentIndex(\
            self.saveFilesFilterComboBox.findText(\
                Preferences.getEditor("DefaultSaveFilter")))
        
    def save(self):
        """
        Public slot to save the Editor General configuration.
        """
        Preferences.setEditor("AutosaveInterval", 
            self.autosaveSlider.value())
        Preferences.setEditor("CreateBackupFile",
            int(self.createBackupFileCheckBox.isChecked()))
        Preferences.setEditor("AutoCheckSyntax",
            int(self.automaticSyntaxCheckCheckBox.isChecked()))
        Preferences.setEditor("DefaultEncoding",
            unicode(self.defaultEncodingComboBox.currentText()))
        Preferences.setEditor("WarnFilesize",
            self.warnFilesizeSpinBox.value())
        Preferences.setEditor("ClearBreaksOnClose",
            int(self.clearBreakpointsCheckBox.isChecked()))
        Preferences.setEditor("AutoReopen",
            int(self.automaticReopenCheckBox.isChecked()))
        Preferences.setEditor("StripTrailingWhitespace", 
            int(self.stripWhitespaceCheckBox.isChecked()))
        Preferences.setEditor("DefaultOpenFilter",
            self.openFilesFilterComboBox.currentText())
        Preferences.setEditor("DefaultSaveFilter",
            self.saveFilesFilterComboBox.currentText())
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorFilePage()
    return page
