# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Editor Properties configuration page.
"""

from PyQt4.Qsci import QsciScintilla

from ConfigurationPageBase import ConfigurationPageBase
from Ui_EditorPropertiesPage import Ui_EditorPropertiesPage

import Preferences

class EditorPropertiesPage(ConfigurationPageBase, Ui_EditorPropertiesPage):
    """
    Class implementing the Editor Properties configuration page.
    """
    def __init__(self):
        """
        Constructor
        
        @param lexers reference to the lexers dictionary
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("EditorPropertiesPage")
        
        # set initial values
        # All
        self.allFoldCompactCheckBox.setChecked(\
            Preferences.getEditor("AllFoldCompact"))
        
        # Bash
        self.foldBashCommentCheckBox.setChecked(\
            Preferences.getEditor("BashFoldComment"))
        
        # CMake
        self.cmakeFoldAtElseCheckBox.setChecked(\
            Preferences.getEditor("CMakeFoldAtElse"))
        
        # C++
        self.foldCppCommentCheckBox.setChecked(\
            Preferences.getEditor("CppFoldComment"))
        self.foldCppPreprocessorCheckBox.setChecked(\
            Preferences.getEditor("CppFoldPreprocessor"))
        self.foldCppAtElseCheckBox.setChecked(\
            Preferences.getEditor("CppFoldAtElse"))
        self.cppIndentOpeningBraceCheckBox.setChecked(\
            Preferences.getEditor("CppIndentOpeningBrace"))
        self.cppIndentClosingBraceCheckBox.setChecked(\
            Preferences.getEditor("CppIndentClosingBrace"))
        self.cppCaseInsensitiveCheckBox.setChecked(\
            Preferences.getEditor("CppCaseInsensitiveKeywords"))
        
        # CSS
        self.foldCssCommentCheckBox.setChecked(\
            Preferences.getEditor("CssFoldComment"))
        
        # D
        self.foldDCommentCheckBox.setChecked(\
            Preferences.getEditor("DFoldComment"))
        self.foldDAtElseCheckBox.setChecked(\
            Preferences.getEditor("DFoldAtElse"))
        self.dIndentOpeningBraceCheckBox.setChecked(\
            Preferences.getEditor("DIndentOpeningBrace"))
        self.dIndentClosingBraceCheckBox.setChecked(\
            Preferences.getEditor("DIndentClosingBrace"))
        
        # HTML
        self.foldHtmlPreprocessorCheckBox.setChecked(\
            Preferences.getEditor("HtmlFoldPreprocessor"))
        self.htmlCaseSensitiveTagsCheckBox.setChecked(\
            Preferences.getEditor("HtmlCaseSensitiveTags"))
        
        # Perl
        self.foldPerlCommentCheckBox.setChecked(\
            Preferences.getEditor("PerlFoldComment"))
        
        # Povray
        self.foldPovrayCommentCheckBox.setChecked(\
            Preferences.getEditor("PovFoldComment"))
        self.foldPovrayDirectivesCheckBox.setChecked(\
            Preferences.getEditor("PovFoldDirectives"))
        
        # Python
        self.foldPythonCommentCheckBox.setChecked(\
            Preferences.getEditor("PythonFoldComment"))
        self.foldPythonStringCheckBox.setChecked(\
            Preferences.getEditor("PythonFoldString"))
        self.pythonBadIndentationCheckBox.setChecked(\
            Preferences.getEditor("PythonBadIndentation"))
        self.pythonAutoindentCheckBox.setChecked(\
            Preferences.getEditor("PythonAutoIndent"))
        
        # SQL
        self.foldSqlCommentCheckBox.setChecked(\
            Preferences.getEditor("SqlFoldComment"))
        self.sqlBackslashEscapesCheckBox.setChecked(\
            Preferences.getEditor("SqlBackslashEscapes"))
        
        # VHDL
        self.vhdlFoldCommentCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldComment"))
        self.vhdlFoldAtElseCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtElse"))
        self.vhdlFoldAtBeginCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtBegin"))
        self.vhdlFoldAtParenthesisCheckBox.setChecked(\
            Preferences.getEditor("VHDLFoldAtParenthesis"))
        
    def save(self):
        """
        Public slot to save the Editor Properties (1) configuration.
        """
        # All
        Preferences.setEditor("AllFoldCompact",
            int(self.allFoldCompactCheckBox.isChecked()))
        
        # Bash
        Preferences.setEditor("BashFoldComment",
            int(self.foldBashCommentCheckBox.isChecked()))
        
        # CMake
        Preferences.setEditor("CMakeFoldAtElse",
            int(self.cmakeFoldAtElseCheckBox.isChecked()))
        
        # C++
        Preferences.setEditor("CppFoldComment",
            int(self.foldCppCommentCheckBox.isChecked()))
        Preferences.setEditor("CppFoldPreprocessor",
            int(self.foldCppPreprocessorCheckBox.isChecked()))
        Preferences.setEditor("CppFoldAtElse",
            int(self.foldCppAtElseCheckBox.isChecked()))
        Preferences.setEditor("CppIndentOpeningBrace",
            int(self.cppIndentOpeningBraceCheckBox.isChecked()))
        Preferences.setEditor("CppIndentClosingBrace",
            int(self.cppIndentClosingBraceCheckBox.isChecked()))
        Preferences.setEditor("CppCaseInsensitiveKeywords",
            int(self.cppCaseInsensitiveCheckBox.isChecked()))
        
        # CSS
        Preferences.setEditor("CssFoldComment",
            int(self.foldCssCommentCheckBox.isChecked()))
        
        # D
        Preferences.setEditor("DFoldComment",
            int(self.foldDCommentCheckBox.isChecked()))
        Preferences.setEditor("DFoldAtElse",
            int(self.foldDAtElseCheckBox.isChecked()))
        Preferences.setEditor("DIndentOpeningBrace",
            int(self.dIndentOpeningBraceCheckBox.isChecked()))
        Preferences.setEditor("DIndentClosingBrace",
            int(self.dIndentClosingBraceCheckBox.isChecked()))
        
        # HTML
        Preferences.setEditor("HtmlFoldPreprocessor",
            int(self.foldHtmlPreprocessorCheckBox.isChecked()))
        Preferences.setEditor("HtmlCaseSensitiveTags",
            int(self.htmlCaseSensitiveTagsCheckBox.isChecked()))
        
        # Perl
        Preferences.setEditor("PerlFoldComment",
            int(self.foldPerlCommentCheckBox.isChecked()))
        
        # Povray
        Preferences.setEditor("PovFoldComment",
            int(self.foldPovrayCommentCheckBox.isChecked()))
        Preferences.setEditor("PovFoldDirectives",
            int(self.foldPovrayDirectivesCheckBox.isChecked()))
        
        # Python
        Preferences.setEditor("PythonFoldComment",
            int(self.foldPythonCommentCheckBox.isChecked()))
        Preferences.setEditor("PythonFoldString",
            int(self.foldPythonStringCheckBox.isChecked()))
        Preferences.setEditor("PythonBadIndentation",
            int(self.pythonBadIndentationCheckBox.isChecked()))
        Preferences.setEditor("PythonAutoIndent",
            int(self.pythonAutoindentCheckBox.isChecked()))
        
        # SQL
        Preferences.setEditor("SqlFoldComment",
            int(self.foldSqlCommentCheckBox.isChecked()))
        Preferences.setEditor("SqlBackslashEscapes",
            int(self.sqlBackslashEscapesCheckBox.isChecked()))
        
        # VHDL
        Preferences.setEditor("VHDLFoldComment",
            int(self.vhdlFoldCommentCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtElse",
            int(self.vhdlFoldAtElseCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtBegin",
            int(self.vhdlFoldAtBeginCheckBox.isChecked()))
        Preferences.setEditor("VHDLFoldAtParenthesis",
            int(self.vhdlFoldAtParenthesisCheckBox.isChecked()))

def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = EditorPropertiesPage()
    return page
