#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    12/31/2004  - P. Harvey Created
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.04';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorBalance1',
	'Image::ExifTool::Canon::ColorBalance2',
	'Image::ExifTool::Canon::ColorBalance3',
	'Image::ExifTool::Canon::ColorBalance4',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewImage',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::Raw',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::Microsoft',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'abspeakaudiofilepath' => { 194 => 'absPeakAudioFilePath' },
	'accessorytype' => { 150 => 0x53 },
	'actionadvised' => { 60 => 0x2a },
	'activearea' => { 54 => 0xc68d },
	'actived-lighting' => { 112 => 0x22 },
	'addaspectratioinfo' => { 31 => 0x80e },
	'addoriginaldecisiondata' => { 31 => 0x80f, 32 => 0x11, 33 => 0x13, 36 => 0x14 },
	'address' => { 82 => 'Address' },
	'adjustmentmode' => { 175 => [0x15,0x22] },
	'adultcontentwarning' => { 190 => 'AdultContentWarning' },
	'advancedraw' => { 130 => 0x76a43203 },
	'advisory' => { 192 => 'Advisory' },
	'ae_iso' => { 152 => 0x2 },
	'aeaperture' => { 152 => 0x1 },
	'aebautocancel' => { 31 => 0x104 },
	'aebbracketvalue' => { 28 => 0x11 },
	'aebsequence' => { 29 => 0x9, 30 => 0x9, 31 => 0x105, 32 => 0x8, 33 => 0x9, 36 => 0x9, 37 => 0x7 },
	'aebshotcount' => { 31 => 0x106 },
	'aebxv' => { 152 => 0x4 },
	'aeexposuretime' => { 152 => 0x0 },
	'aeextra' => { 152 => 0x7 },
	'aelock' => { 120 => '733.3', 121 => '752.2', 136 => 0x201, 163 => 0x48 },
	'aelockbutton' => { 120 => '733.2', 121 => '752.1' },
	'aemaxaperture' => { 152 => 0x9 },
	'aemaxaperture2' => { 152 => 0xa },
	'aemeteringmode' => { 152 => 0xc },
	'aemeteringsegments' => { 163 => 0x209 },
	'aeminaperture' => { 152 => 0xb },
	'aeminexposuretime' => { 152 => 0x5 },
	'aeprogrammode' => { 152 => 0x6 },
	'aesetting' => { 9 => 0x21 },
	'aexv' => { 152 => 0x3 },
	'af-cpriorityselection' => { 119 => '791.1' },
	'af-onformb-d10' => { 119 => '793.1' },
	'af-spriorityselection' => { 119 => '791.2' },
	'afactivation' => { 119 => '792.1' },
	'afadjustment' => { 163 => 0x72 },
	'afaperture' => { 111 => 0x5 },
	'afareaillumination' => { 121 => '763.3' },
	'afareamode' => { 99 => 0x0, 100 => 0x5, 121 => 0x2fc },
	'afareamodesetting' => { 120 => 0x2e4 },
	'afareas' => { 136 => 0x304 },
	'afassist' => { 29 => 0x5, 37 => 0x5, 120 => '729.2', 121 => '748.2' },
	'afassistbeam' => { 31 => 0x50e, 32 => 0x4, 33 => 0x5, 34 => 0x4, 35 => 0x4, 36 => 0x5 },
	'afassistilluminator' => { 119 => '792.4' },
	'afdefocus' => { 153 => 0x6 },
	'afduringliveview' => { 31 => 0x511 },
	'afexpansionwithselectedpoint' => { 31 => 0x508 },
	'affinetuneadj' => { 119 => 0x2d1 },
	'afintegrationtime' => { 153 => 0x7 },
	'afmicroadjustment' => { 31 => 0x507 },
	'afmode' => { 150 => 0xf, 175 => 0x5 },
	'afonaelockbuttonswitch' => { 31 => 0x702 },
	'afpoint' => { 9 => 0x13, 50 => 0x18, 99 => 0x1, 139 => 0x308 },
	'afpointactivationarea' => { 30 => 0x11, 36 => 0x11 },
	'afpointautoselection' => { 31 => 0x50b },
	'afpointbrightness' => { 31 => 0x50d },
	'afpointdisplayduringfocus' => { 31 => 0x50c },
	'afpointillumination' => { 30 => 0xa, 119 => '792.3' },
	'afpointmode' => { 156 => 0x3 },
	'afpointposition' => { 51 => 0x2021 },
	'afpointregistration' => { 29 => 0x7 },
	'afpoints' => { 93 => 0x10 },
	'afpointselected' => { 163 => 0xe },
	'afpointselected2' => { 156 => 0x4 },
	'afpointselection' => { 30 => 0xb, 119 => '791.3' },
	'afpointselectionmethod' => { 31 => 0x50f, 32 => 0xc, 33 => 0xd, 36 => 0xd },
	'afpointsinfocus' => { 28 => 0xe, 99 => 0x2, 153 => 0xb, 163 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 7 => 0x38 },
	'afpointspotmetering' => { 30 => 0xd },
	'afpointsunknown1' => { 153 => 0x0 },
	'afpointsunknown2' => { 153 => 0x2 },
	'afpointsused' => { 100 => 0x8 },
	'afpredictor' => { 153 => 0x4 },
	'afresponse' => { 112 => 0xad },
	'afresult' => { 141 => 0x1038 },
	'afsearch' => { 136 => 0x303 },
	'aiservoimagepriority' => { 31 => 0x503 },
	'aiservotrackingmethod' => { 31 => 0x504 },
	'aiservotrackingsensitivity' => { 30 => 0x14, 31 => 0x502 },
	'album' => { 194 => 'album' },
	'alreadyapplied' => { 183 => 'AlreadyApplied' },
	'alttapename' => { 194 => 'altTapeName' },
	'alttimecodetimeformat' => { 194 => 'altTimecodeTimeFormat' },
	'alttimecodetimevalue' => { 194 => 'altTimecodeTimeValue' },
	'anti-blur' => { 176 => 0xb04b },
	'antialiasstrength' => { 54 => 0xc632 },
	'aperturerange' => { 31 => 0x10d },
	'apertureringuse' => { 156 => '1.4' },
	'aperturevalue' => { 40 => 0x2, 54 => 0x9202, 141 => 0x1002, 186 => 'ApertureValue' },
	'applekeywords' => { 145 => 'AAPL:Keywords' },
	'applicationnotes' => { 54 => 0x2bc },
	'applicationrecordversion' => { 60 => 0x0 },
	'applyshootingmeteringmode' => { 31 => 0x10e },
	'approximatefnumber' => { 148 => 0x313 },
	'armidentifier' => { 61 => 0x78 },
	'armversion' => { 61 => 0x7a },
	'artist' => { 54 => 0x13b, 147 => 'Artist', 191 => 'Artist', 194 => 'artist' },
	'asshoticcprofile' => { 54 => 0xc68f },
	'asshotneutral' => { 54 => 0xc628 },
	'asshotpreprofilematrix' => { 54 => 0xc690 },
	'asshotprofilename' => { 54 => 0xc6f6 },
	'asshotwhitexy' => { 54 => 0xc629 },
	'assistbuttonfunction' => { 29 => 0xd },
	'audio' => { 150 => 0x20 },
	'audiochanneltype' => { 194 => 'audioChannelType' },
	'audiocompression' => { 76 => 'Compression' },
	'audiocompressor' => { 194 => 'audioCompressor' },
	'audioduration' => { 60 => 0x99 },
	'audiomoddate' => { 194 => 'audioModDate' },
	'audiooutcue' => { 60 => 0x9a },
	'audiosamplerate' => { 194 => 'audioSampleRate' },
	'audiosampletype' => { 194 => 'audioSampleType' },
	'audiosamplingrate' => { 60 => 0x97 },
	'audiosamplingresolution' => { 60 => 0x98 },
	'audiotype' => { 60 => 0x96 },
	'author' => { 78 => 'Author', 145 => 'Author', 147 => 'Author', 171 => 'Author', 188 => 'Author' },
	'authorsposition' => { 189 => 'AuthorsPosition' },
	'autoaperture' => { 160 => '0.1' },
	'autobracket' => { 175 => 0x19 },
	'autobracketing' => { 58 => 0x1100, 163 => 0x18 },
	'autobracketmodem' => { 119 => '811.2' },
	'autobracketorder' => { 119 => '811.3', 121 => '750.2' },
	'autobracketrelease' => { 112 => 0x8a },
	'autobracketset' => { 119 => '811.1', 121 => '750.1' },
	'autobrightness' => { 183 => 'AutoBrightness' },
	'autocontrast' => { 183 => 'AutoContrast' },
	'autoexposure' => { 183 => 'AutoExposure' },
	'autoexposurebracketing' => { 28 => 0x10 },
	'autofocus' => { 100 => 0x6, 139 => 0x209 },
	'autofp' => { 121 => '755.2' },
	'autoiso' => { 28 => 0x1, 51 => 0x3008, 120 => '730.1', 121 => '749.1' },
	'autoisomax' => { 120 => '730.2', 121 => '749.2' },
	'autoisominshutterspeed' => { 120 => '730.3', 121 => '749.3' },
	'autolightingoptimizer' => { 31 => 0x204 },
	'autorotate' => { 28 => 0x1b },
	'autoshadows' => { 183 => 'AutoShadows' },
	'auxiliarylens' => { 112 => 0x82 },
	'avaperturesetting' => { 156 => 0x13 },
	'avsettingwithoutlens' => { 31 => 0x707 },
	'azimuth' => { 86 => 'Azimuth' },
	'babyage' => { 150 => [0x8010,0x33] },
	'baseexposurecompensation' => { 156 => 0x15 },
	'baseiso' => { 28 => 0x2, 44 => 0x101c },
	'baselineexposure' => { 54 => 0xc62a },
	'baselinenoise' => { 54 => 0xc62b },
	'baselinesharpness' => { 54 => 0xc62c },
	'baseurl' => { 192 => 'BaseURL' },
	'batteryadbodyload' => { 154 => 0x3 },
	'batteryadbodynoload' => { 154 => 0x2 },
	'batteryadgripload' => { 154 => 0x5 },
	'batteryadgripnoload' => { 154 => 0x4 },
	'batteryorder' => { 119 => '802.3' },
	'batterystates' => { 154 => 0x1 },
	'bayergreensplit' => { 54 => 0xc62d },
	'bayerpattern' => { 64 => 0xf902, 96 => 0x17 },
	'beatspliceparamsriseindecibel' => { 194 => 'beatSpliceParamsRiseInDecibel' },
	'beatspliceparamsriseintimeduration' => { 194 => 'beatSpliceParamsRiseInTimeDuration' },
	'beatspliceparamsusefilebeatsmarker' => { 194 => 'beatSpliceParamsUseFileBeatsMarker' },
	'beep' => { 119 => '803.1', 120 => '729.1', 121 => '748.1' },
	'bestqualityscale' => { 54 => 0xc65c },
	'bestshotmode' => { 51 => 0x3007 },
	'bitdepth' => { 83 => 'BitDepth', 96 => 0x11, 117 => 0x41 },
	'bitspercomponent' => { 62 => 0x87 },
	'bitspersample' => { 54 => 0x102, 191 => 'BitsPerSample' },
	'blacklevel' => { 54 => 0xc61a, 141 => 0x1012 },
	'blacklevel2' => { 140 => 0x600, 144 => 0x600 },
	'blackpoint' => { 163 => 0x200 },
	'bluebalance' => { 141 => 0x1018, 151 => 0x12, 163 => 0x1b },
	'bluecurvelimits' => { 48 => 0x1fe },
	'bluecurvepoints' => { 48 => 0x1d4 },
	'bluehue' => { 183 => 'BlueHue' },
	'bluesaturation' => { 183 => 'BlueSaturation' },
	'blurwarning' => { 58 => 0x1300 },
	'bodyfirmwareversion' => { 137 => 0x104, 138 => 0x100, 141 => 0x104 },
	'bracketmode' => { 18 => 0x3 },
	'bracketsequence' => { 51 => 0x301d },
	'bracketshotnumber' => { 18 => 0x5, 156 => 0x9 },
	'bracketstep' => { 91 => 0xe },
	'bracketvalue' => { 18 => 0x4 },
	'brightness' => { 54 => 0xfe53, 77 => 'Brightness', 91 => 0x2c, 114 => 0x34, 183 => 'Brightness' },
	'brightnessadj' => { 48 => 0x114, 125 => 0x0 },
	'brightnessvalue' => { 54 => 0x9203, 141 => 0x1003, 186 => 'BrightnessValue' },
	'bulbduration' => { 28 => 0x18 },
	'burstmode' => { 66 => 0xa, 150 => 0x2a },
	'burstmode2' => { 66 => 0x18 },
	'buttonfunctioncontroloff' => { 31 => 0x70a },
	'bwfilter' => { 91 => 0x2a, 97 => 0x39 },
	'bwmode' => { 141 => 0x203 },
	'by-line' => { 60 => 0x50 },
	'by-linetitle' => { 60 => 0x55 },
	'calibrationilluminant1' => { 54 => 0xc65a },
	'calibrationilluminant2' => { 54 => 0xc65b },
	'cameracalibrationsig' => { 54 => 0xc6f3 },
	'cameraid' => { 141 => 0x209, 174 => 0x209 },
	'cameraiso' => { 9 => 0x10 },
	'cameraparameters' => { 141 => 0x2050 },
	'cameraprofile' => { 183 => 'CameraProfile' },
	'cameraprofiledigest' => { 183 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 54 => 0xc62f, 180 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 136 => 0x0 },
	'cameratemperature' => { 148 => 0x320, 163 => 0x47 },
	'cameratype' => { 28 => 0x1a, 141 => 0x207 },
	'cameratype2' => { 137 => 0x100 },
	'canonexposuremode' => { 9 => 0x14 },
	'canonfiledescription' => { 44 => 0x805 },
	'canonfilelength' => { 21 => 0xe },
	'canonfirmwareversion' => { 21 => 0x7, 44 => 0x80b },
	'canonflashinfo' => { 44 => 0x1028 },
	'canonflashmode' => { 9 => 0x4 },
	'canonimagesize' => { 2 => 0x39, 9 => 0xa },
	'canonimagetype' => { 21 => 0x6, 44 => 0x815 },
	'canonmodelid' => { 21 => 0x10, 44 => 0x1834 },
	'canonvrd' => { 55 => 'CanonVRD' },
	'caption-abstract' => { 60 => 0x78 },
	'captiondigest' => { 169 => 0x425 },
	'captionwriter' => { 189 => 'CaptionWriter' },
	'casioimagesize' => { 51 => 0x9 },
	'catalogsets' => { 179 => 'CatalogSets' },
	'categories' => { 21 => 0x23 },
	'category' => { 60 => 0xf, 189 => 'Category' },
	'ccdboardversion' => { 148 => 0x331 },
	'ccdscanmode' => { 141 => 0x1039 },
	'ccdsensitivity' => { 122 => 0x6 },
	'ccdversion' => { 148 => 0x330 },
	'celllength' => { 54 => 0x109 },
	'cellwidth' => { 54 => 0x108 },
	'centerafarea' => { 121 => '763.1' },
	'centerweightedareasize' => { 119 => '797.1', 121 => '754.3' },
	'certificate' => { 197 => 'Certificate' },
	'cfapattern' => { 54 => 0xa302 },
	'cfapatterncolumns' => { 186 => 'CFAPatternColumns' },
	'cfapatternrows' => { 186 => 'CFAPatternRows' },
	'cfapatternvalues' => { 186 => 'CFAPatternValues' },
	'channels' => { 76 => 'Channels' },
	'checkmark' => { 48 => 0x26a },
	'chromablurradius' => { 54 => 0xc631 },
	'chromaticaberrationb' => { 183 => 'ChromaticAberrationB' },
	'chromaticaberrationr' => { 183 => 'ChromaticAberrationR' },
	'chrominancenoisereduction' => { 49 => 0xbc },
	'chrominancenr_tiff_jpeg' => { 49 => 0xc0 },
	'city' => { 60 => 0x5a, 82 => 'City', 189 => 'City' },
	'clarity' => { 183 => 'Clarity' },
	'classifystate' => { 60 => 0xe1 },
	'clmodeshootingspeed' => { 119 => '800.2' },
	'cmcontrast' => { 144 => 0x2022 },
	'cmexposurecompensation' => { 144 => 0x2000 },
	'cmhue' => { 144 => 0x2021 },
	'cmsaturation' => { 144 => 0x2020 },
	'cmsharpness' => { 144 => 0x2023 },
	'cmwhitebalance' => { 144 => 0x2001 },
	'cmwhitebalancecomp' => { 144 => 0x2002 },
	'cmwhitebalancegraypoint' => { 144 => 0x2010 },
	'codec' => { 90 => 'Codec' },
	'codedcharacterset' => { 61 => 0x5a },
	'coloraberrationcontrol' => { 130 => 0xc89224b },
	'coloradjustment' => { 175 => 0x14 },
	'coloradjustmentmode' => { 174 => 0x210 },
	'colorantsa' => { 198 => 'ColorantsA' },
	'colorantsb' => { 198 => 'ColorantsB' },
	'colorantsblack' => { 198 => 'ColorantsBlack' },
	'colorantsblue' => { 198 => 'ColorantsBlue' },
	'colorantscyan' => { 198 => 'ColorantsCyan' },
	'colorantsgreen' => { 198 => 'ColorantsGreen' },
	'colorantsl' => { 198 => 'ColorantsL' },
	'colorantsmagenta' => { 198 => 'ColorantsMagenta' },
	'colorantsmode' => { 198 => 'ColorantsMode' },
	'colorantsred' => { 198 => 'ColorantsRed' },
	'colorantsswatchname' => { 198 => 'ColorantsSwatchName' },
	'colorantstype' => { 198 => 'ColorantsType' },
	'colorantsyellow' => { 198 => 'ColorantsYellow' },
	'colorbalance' => { 77 => 'ColorBalance' },
	'colorbalance1' => { 112 => 0xc },
	'colorbalanceadj' => { 130 => 0x76a43202 },
	'colorbalanceblue' => { 91 => 0x1e },
	'colorbalancegreen' => { 91 => 0x1d },
	'colorbalancered' => { 91 => 0x1c },
	'colorbooster' => { 130 => 0x5f0e7d23 },
	'colorboostlevel' => { 126 => 0x1 },
	'colorboosttype' => { 126 => 0x0 },
	'colorclass' => { 166 => 0xde },
	'colorcontrol' => { 141 => 0x102b },
	'coloreffect' => { 150 => 0x28 },
	'colorfilter' => { 50 => 0x17, 91 => 0x29, 97 => 0x38, 165 => 0x17 },
	'colorgain' => { 117 => 0x51 },
	'colorhue' => { 112 => 0x8d },
	'colorimetricreference' => { 54 => 0xc6bf },
	'colormatrix' => { 140 => 0x200, 141 => 0x1011 },
	'colormatrix2' => { 144 => 0x200 },
	'colormatrixa' => { 163 => 0x203 },
	'colormatrixb' => { 163 => 0x204 },
	'colormatrixnumber' => { 141 => 0x1019 },
	'colormode' => { 51 => 0x3015, 58 => 0x1210, 66 => 0x66, 91 => 0x28, 94 => 0x16, 95 => 0x101, 97 => 0x7, 112 => 0x3, 122 => 0x4, 141 => 0x101, 150 => 0x32, 176 => 0xb029, 189 => 'ColorMode' },
	'colormoirereduction' => { 131 => 0x5 },
	'colornoisereduction' => { 183 => 'ColorNoiseReduction' },
	'colorplanes' => { 57 => 0x2 },
	'colorprofile' => { 91 => 0x33 },
	'colorrepresentation' => { 62 => 0x3c },
	'colorreproduction' => { 176 => 0xb020 },
	'colorsequence' => { 62 => 0x41 },
	'colorspace' => { 15 => 0x3, 21 => 0xb4, 44 => 0x10b4, 54 => 0xa001, 83 => 'ColorSpace', 92 => 0x2f, 93 => 0x25, 112 => 0x1e, 136 => 0x507, 163 => 0x37, 175 => 0xb, 186 => 'ColorSpace' },
	'colortempasshot' => { 11 => 0x1d, 12 => 0x1c, 13 => 0x43, 14 => 0x43 },
	'colortempauto' => { 11 => 0x22, 12 => 0x26, 13 => 0x48, 14 => 0x48 },
	'colortempcloudy' => { 11 => 0x31, 12 => 0x35, 13 => 0x5c, 14 => 0x61 },
	'colortempcustom' => { 13 => 0x84 },
	'colortempcustom1' => { 11 => 0x45 },
	'colortempcustom2' => { 11 => 0x4a },
	'colortempdaylight' => { 11 => 0x27, 12 => 0x2b, 13 => 0x52, 14 => 0x57 },
	'colortemperature' => { 1 => [0x48,0x4e], 2 => 0x37, 3 => 0x62, 4 => 0x37, 5 => 0x73, 6 => 0x73, 7 => 0x58, 21 => 0xae, 26 => 0x9, 44 => 0x10ae, 58 => 0x1005, 65 => 0x846, 77 => 'ColorTemperature', 92 => [0x6e,0x49], 93 => 0x3f, 94 => 0x5e, 95 => 0x10b, 97 => 0x3c, 148 => 0x321, 163 => 0x50, 176 => 0xb021 },
	'colortemperaturebg' => { 141 => 0x1013 },
	'colortemperaturerg' => { 141 => 0x1014 },
	'colortempflash' => { 11 => 0x40, 12 => 0x49, 13 => 0x70, 14 => 0x75 },
	'colortempfluorescent' => { 11 => 0x3b, 12 => 0x3f, 13 => 0x66, 14 => 0x6b },
	'colortempkelvin' => { 12 => 0x44, 13 => 0x6b, 14 => 0x70 },
	'colortempmeasured' => { 13 => 0x4d, 14 => 0x4d },
	'colortemppc1' => { 12 => 0x94, 13 => 0x75 },
	'colortemppc2' => { 12 => 0x99, 13 => 0x7a },
	'colortemppc3' => { 12 => 0x9e, 13 => 0x7f },
	'colortempshade' => { 11 => 0x2c, 12 => 0x30, 13 => 0x57, 14 => 0x5c },
	'colortemptungsten' => { 11 => 0x36, 12 => 0x3a, 13 => 0x61, 14 => 0x66 },
	'colortempunknown' => { 12 => 0x21 },
	'colortempunknown10' => { 12 => 0x76, 14 => 0xa2 },
	'colortempunknown11' => { 12 => 0x7b, 14 => 0xa7 },
	'colortempunknown12' => { 12 => 0x80 },
	'colortempunknown13' => { 12 => 0x85 },
	'colortempunknown14' => { 12 => 0x8a },
	'colortempunknown15' => { 12 => 0x8f },
	'colortempunknown16' => { 12 => 0xa3 },
	'colortempunknown2' => { 12 => 0x4e, 14 => 0x7a },
	'colortempunknown3' => { 12 => 0x53, 14 => 0x7f },
	'colortempunknown4' => { 12 => 0x58, 14 => 0x84 },
	'colortempunknown5' => { 12 => 0x5d, 14 => 0x89 },
	'colortempunknown6' => { 12 => 0x62, 14 => 0x8e },
	'colortempunknown7' => { 12 => 0x67, 14 => 0x93 },
	'colortempunknown8' => { 12 => 0x6c, 14 => 0x98 },
	'colortempunknown9' => { 12 => 0x71, 14 => 0x9d },
	'colortone' => { 2 => 0x6f, 4 => 0x77, 9 => 0x2a, 15 => 0x2 },
	'colortoneadj' => { 48 => 0x11e },
	'colortonefaithful' => { 7 => 0x107 },
	'colortonelandscape' => { 7 => 0x105 },
	'colortoneneutral' => { 7 => 0x106 },
	'colortoneportrait' => { 7 => 0x104 },
	'colortonestandard' => { 7 => 0x103 },
	'colortoneuserdef1' => { 7 => 0x109 },
	'colortoneuserdef2' => { 7 => 0x10a },
	'colortoneuserdef3' => { 7 => 0x10b },
	'commanddials' => { 121 => '753.1' },
	'commanddialsaperturesetting' => { 119 => '807.3' },
	'commanddialschangemainsub' => { 119 => '807.2' },
	'commanddialsmenuandplayback' => { 119 => '807.4' },
	'commanddialsreverserotation' => { 119 => '807.1' },
	'commanderchannel' => { 121 => '758.2' },
	'commandergroupa_manualoutput' => { 121 => '761.2' },
	'commandergroupa_ttl-aacomp' => { 121 => '761.1' },
	'commandergroupamode' => { 121 => '759.2' },
	'commandergroupb_manualoutput' => { 121 => '762.2' },
	'commandergroupb_ttl-aacomp' => { 121 => '762.1' },
	'commandergroupbmode' => { 121 => '759.3' },
	'commanderinternalflash' => { 121 => '759.1' },
	'commanderinternalmanualoutput' => { 121 => '760.2' },
	'commanderinternalttlcomp' => { 121 => '760.1' },
	'comment' => { 0 => 0x2, 55 => 'Comment', 78 => 'Comment', 147 => 'Comment' },
	'componentsconfiguration' => { 54 => 0x9101, 83 => 'Components', 186 => 'ComponentsConfiguration' },
	'componentversion' => { 44 => 0x80c },
	'composer' => { 194 => 'composer' },
	'compressedbitsperpixel' => { 54 => 0x9102, 186 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 95 => 0x40, 141 => 0x40 },
	'compression' => { 54 => 0x103, 191 => 'Compression' },
	'compressionfactor' => { 136 => 0x50d },
	'compressionratio' => { 83 => 'Compression', 141 => 0x1034 },
	'constrainedcropheight' => { 48 => 0x266, 166 => 0xd6 },
	'constrainedcropwidth' => { 48 => 0x262, 166 => 0xd5 },
	'contact' => { 60 => 0x76 },
	'contentlocationcode' => { 60 => 0x1a },
	'contentlocationname' => { 60 => 0x1b },
	'continuousdrive' => { 9 => 0x5 },
	'continuousshootingspeed' => { 31 => 0x610 },
	'continuousshotlimit' => { 31 => 0x611 },
	'contrast' => { 2 => 0x73, 4 => 0x75, 9 => 0xd, 50 => 0xc, 51 => [0x3012,0x20], 54 => [0xa408,0xfe54], 58 => [0x1004,0x1006], 77 => 'Contrast', 91 => 0x20, 92 => 0x31, 93 => 0x27, 94 => 0x19, 97 => 0x2, 114 => 0x33, 141 => 0x1029, 150 => [0x2c,0x39], 163 => 0x20, 165 => 0xc, 175 => 0xd, 183 => 'Contrast', 186 => 'Contrast' },
	'contrastadj' => { 48 => 0x115 },
	'contrastfaithful' => { 7 => 0xec },
	'contrastlandscape' => { 7 => 0xea },
	'contrastmonochrome' => { 7 => 0xed },
	'contrastneutral' => { 7 => 0xeb },
	'contrastportrait' => { 7 => 0xe9 },
	'contrastsetting' => { 136 => 0x505, 144 => 0x1012 },
	'contraststandard' => { 7 => 0xe8 },
	'contrastuserdef1' => { 7 => 0xee },
	'contrastuserdef2' => { 7 => 0xef },
	'contrastuserdef3' => { 7 => 0xf0 },
	'contributedmediaduration' => { 194 => 'contributedMediaDuration' },
	'contributedmediamanaged' => { 194 => 'contributedMediaManaged' },
	'contributedmediapath' => { 194 => 'contributedMediaPath' },
	'contributedmediastarttime' => { 194 => 'contributedMediaStartTime' },
	'contributedmediatrack' => { 194 => 'contributedMediaTrack' },
	'contributedmediawebstatement' => { 194 => 'contributedMediaWebStatement' },
	'contributor' => { 184 => 'contributor' },
	'contributors' => { 78 => 'Contributors' },
	'controllerboardversion' => { 148 => 0x332 },
	'controlmode' => { 28 => 0x12 },
	'conversionlens' => { 150 => 0x35 },
	'converter' => { 54 => 0xfe4d, 122 => 0xb },
	'converttograyscale' => { 183 => 'ConvertToGrayscale' },
	'copyright' => { 0 => 0x3, 54 => 0x8298, 78 => 'Copyright', 147 => 'Copyright', 171 => 'Copyright', 191 => 'Copyright', 194 => 'copyright' },
	'copyrightflag' => { 169 => 0x40a },
	'copyrightnotice' => { 60 => 0x74 },
	'copyrightownerid' => { 190 => 'CopyrightOwnerCopyrightOwnerID' },
	'copyrightownerimageid' => { 190 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 190 => 'CopyrightOwnerCopyrightOwnerName' },
	'copyrightregistrationnumber' => { 190 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 190 => 'CopyrightStatus' },
	'coringfilter' => { 140 => 0x310, 141 => 0x102d, 144 => 0x310 },
	'coringvalues' => { 140 => 0x311, 144 => 0x311 },
	'country' => { 82 => 'Country', 189 => 'Country' },
	'country-primarylocationcode' => { 60 => 0x64 },
	'country-primarylocationname' => { 60 => 0x65 },
	'countrycode' => { 167 => 'CountryCode', 187 => 'CountryCode' },
	'coverage' => { 184 => 'coverage' },
	'cpufirmwareversion' => { 163 => 0x28 },
	'crc32' => { 185 => 'crc32' },
	'createdate' => { 54 => 0x9004, 78 => 'CreateDate', 145 => 'CreationDate', 171 => 'CreationDate', 192 => 'CreateDate' },
	'creationdate' => { 188 => 'CreationDate' },
	'creationtime' => { 147 => 'Creation Time' },
	'creator' => { 145 => 'Creator', 171 => 'Creator', 184 => 'creator', 188 => 'Creator' },
	'creatorcontactinfociadrcity' => { 187 => 'CreatorContactInfoCiAdrCity' },
	'creatorcontactinfociadrctry' => { 187 => 'CreatorContactInfoCiAdrCtry' },
	'creatorcontactinfociadrextadr' => { 187 => 'CreatorContactInfoCiAdrExtadr' },
	'creatorcontactinfociadrpcode' => { 187 => 'CreatorContactInfoCiAdrPcode' },
	'creatorcontactinfociadrregion' => { 187 => 'CreatorContactInfoCiAdrRegion' },
	'creatorcontactinfociemailwork' => { 187 => 'CreatorContactInfoCiEmailWork' },
	'creatorcontactinfocitelwork' => { 187 => 'CreatorContactInfoCiTelWork' },
	'creatorcontactinfociurlwork' => { 187 => 'CreatorContactInfoCiUrlWork' },
	'creatortool' => { 192 => 'CreatorTool' },
	'credit' => { 60 => 0x6e, 189 => 'Credit' },
	'creditlinereq' => { 196 => 'CreditLineReq' },
	'creditlinerequired' => { 190 => 'CreditLineRequired' },
	'cropactive' => { 48 => 0x244 },
	'cropangle' => { 183 => 'CropAngle' },
	'cropaspectratio' => { 48 => 0x260 },
	'cropbottom' => { 57 => 0x9, 127 => 0x36, 166 => 0xdc, 183 => 'CropBottom' },
	'cropheight' => { 48 => 0x24c, 140 => 0x615, 144 => 0x615, 183 => 'CropHeight' },
	'crophispeed' => { 112 => 0x1b },
	'cropleft' => { 48 => 0x246, 57 => 0x6, 127 => 0x1e, 140 => 0x612, 144 => 0x612, 166 => 0xd9, 183 => 'CropLeft' },
	'cropoutputscale' => { 127 => 0xbe },
	'cropright' => { 57 => 0x8, 127 => 0x2e, 166 => 0xdb, 183 => 'CropRight' },
	'croprotation' => { 57 => 0xb },
	'croptop' => { 48 => 0x248, 57 => 0x7, 127 => 0x26, 140 => 0x613, 144 => 0x613, 166 => 0xda, 183 => 'CropTop' },
	'cropunits' => { 183 => 'CropUnits' },
	'cropwidth' => { 48 => 0x24a, 140 => 0x614, 144 => 0x614, 183 => 'CropWidth' },
	'currenticcprofile' => { 54 => 0xc691 },
	'currentpreprofilematrix' => { 54 => 0xc692 },
	'curves' => { 130 => 0x76a43201 },
	'custom1' => { 190 => 'Custom1' },
	'custom10' => { 190 => 'Custom10' },
	'custom2' => { 190 => 'Custom2' },
	'custom3' => { 190 => 'Custom3' },
	'custom4' => { 190 => 'Custom4' },
	'custom5' => { 190 => 'Custom5' },
	'custom6' => { 190 => 'Custom6' },
	'custom7' => { 190 => 'Custom7' },
	'custom8' => { 190 => 'Custom8' },
	'custom9' => { 190 => 'Custom9' },
	'customrendered' => { 54 => 0xa401, 186 => 'CustomRendered' },
	'customsaturation' => { 136 => 0x503 },
	'd-lightinghq' => { 130 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 128 => 0x2 },
	'd-lightinghqhighlight' => { 128 => 0x1 },
	'd-lightinghqselected' => { 130 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 128 => 0x0 },
	'd-lightinghs' => { 130 => 0xce5554aa },
	'd-lightinghsadjustment' => { 129 => 0x0 },
	'd-lightinghscolorboost' => { 129 => 0x1 },
	'datacompressionmethod' => { 62 => 0x6e },
	'dataimprint' => { 91 => 0x34 },
	'date' => { 163 => 0x6, 184 => 'date' },
	'dateacquired' => { 180 => 'DateAcquired' },
	'datecreated' => { 60 => 0x37, 189 => 'DateCreated' },
	'dateformat' => { 124 => 0x3 },
	'datesent' => { 61 => 0x46 },
	'datestampmode' => { 21 => 0x1c },
	'datetime' => { 191 => 'DateTime' },
	'datetimedigitized' => { 186 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 47 => 0x0, 54 => 0x9003, 78 => 'OriginalDate', 186 => 'DateTimeOriginal' },
	'datetimestamp' => { 66 => 0x64 },
	'daylightsavings' => { 124 => 0x2 },
	'declination' => { 86 => 'Declination' },
	'decposition' => { 91 => 0x32 },
	'defaultcroporigin' => { 54 => 0xc61f },
	'defaultcropsize' => { 54 => 0xc620 },
	'defaultscale' => { 54 => 0xc61e },
	'defringe' => { 183 => 'Defringe' },
	'deletedimagecount' => { 112 => 0xa6, 118 => 0x6e },
	'derivedfromdocumentid' => { 195 => 'DerivedFromDocumentID' },
	'derivedfrominstanceid' => { 195 => 'DerivedFromInstanceID' },
	'derivedfrommanager' => { 195 => 'DerivedFromManager' },
	'derivedfrommanagervariant' => { 195 => 'DerivedFromManagerVariant' },
	'derivedfrommanageto' => { 195 => 'DerivedFromManageTo' },
	'derivedfrommanageui' => { 195 => 'DerivedFromManageUI' },
	'derivedfromrenditionclass' => { 195 => 'DerivedFromRenditionClass' },
	'derivedfromrenditionparams' => { 195 => 'DerivedFromRenditionParams' },
	'derivedfromversionid' => { 195 => 'DerivedFromVersionID' },
	'description' => { 147 => 'Description', 184 => 'description' },
	'destination' => { 61 => 0x5 },
	'destinationcity' => { 163 => 0x24 },
	'destinationcitycode' => { 165 => 0x1001 },
	'destinationdst' => { 163 => 0x26 },
	'developmentdynamicrange' => { 58 => 0x1403 },
	'devicesettingdescriptioncolumns' => { 186 => 'DeviceSettingDescriptionColumns' },
	'devicesettingdescriptionrows' => { 186 => 'DeviceSettingDescriptionRows' },
	'devicesettingdescriptionsettings' => { 186 => 'DeviceSettingDescriptionSettings' },
	'dialdirectiontvav' => { 31 => 0x706 },
	'digitalcreationdate' => { 60 => 0x3e },
	'digitalcreationtime' => { 60 => 0x3f },
	'digitalgain' => { 26 => 0xb },
	'digitalgem' => { 108 => 0x0 },
	'digitalice' => { 117 => 0x100 },
	'digitalroc' => { 116 => 0x0 },
	'digitalzoom' => { 9 => 0xc, 50 => 0xa, 66 => 0x68, 77 => 'DigitalZoom', 91 => 0xc, 112 => 0x86, 122 => 0xa, 141 => 0x204, 163 => 0x1e, 165 => 0xa, 174 => 0x204 },
	'digitalzoomon' => { 174 => 0x21b },
	'digitalzoomratio' => { 54 => 0xa404, 186 => 'DigitalZoomRatio' },
	'directory' => { 55 => 'Directory' },
	'directoryindex' => { 3 => 0x17e, 5 => 0x13f },
	'directorynumber' => { 105 => 0x6 },
	'disclaimer' => { 147 => 'Disclaimer' },
	'displayaperture' => { 9 => 0x23 },
	'displayedunitsx' => { 170 => 0x2 },
	'displayedunitsy' => { 170 => 0x6 },
	'distance1' => { 66 => 0x28 },
	'distance2' => { 66 => 0x2c },
	'distance3' => { 66 => 0x30 },
	'distance4' => { 66 => 0x34 },
	'distortioncorrection' => { 136 => 0x50b },
	'distortioncorrection2' => { 140 => 0x1011 },
	'dngbackwardversion' => { 54 => 0xc613 },
	'dnglensinfo' => { 54 => 0xc630 },
	'dngversion' => { 54 => 0xc612 },
	'document' => { 147 => 'Document' },
	'documenthistory' => { 60 => 0xe7 },
	'documentid' => { 195 => 'DocumentID' },
	'documentname' => { 54 => 0x10d },
	'documentnotes' => { 60 => 0xe6 },
	'dotrange' => { 54 => 0x150 },
	'drivemode' => { 91 => 0x6, 94 => 0x1e, 136 => 0x600, 163 => 0x34, 175 => 0x3 },
	'drivemode2' => { 156 => 0x7 },
	'dspfirmwareversion' => { 163 => 0x27 },
	'duration' => { 76 => 'Duration', 90 => 'Duration', 194 => 'duration' },
	'dynamicafarea' => { 119 => '791.4' },
	'dynamicrange' => { 58 => 0x1400 },
	'dynamicrangeexpansion' => { 163 => 0x69 },
	'dynamicrangemax' => { 48 => 0x7c },
	'dynamicrangemin' => { 48 => 0x7a },
	'dynamicrangeoptimizer' => { 176 => 0xb025 },
	'dynamicrangesetting' => { 58 => 0x1402 },
	'e-dialinprogram' => { 156 => '1.3' },
	'easyexposurecompensation' => { 119 => '796.4' },
	'easymode' => { 9 => 0xb },
	'edgenoisereduction' => { 131 => 0x4 },
	'editorialupdate' => { 60 => 0x8 },
	'editstatus' => { 60 => 0x7, 167 => 'EditStatus' },
	'effectivelv' => { 163 => 0x2d },
	'effectivemaxaperture' => { 111 => 0x12 },
	'elevation' => { 86 => 'Elevation' },
	'email' => { 78 => 'EMail' },
	'enduserid' => { 190 => 'EndUserEndUserID' },
	'endusername' => { 190 => 'EndUserEndUserName' },
	'engineer' => { 194 => 'engineer' },
	'enhancedarktones' => { 125 => 0x8 },
	'enhancement' => { 50 => 0x16, 51 => 0x3016 },
	'enhancer' => { 140 => 0x300 },
	'enhancervalues' => { 140 => 0x301 },
	'envelopenumber' => { 61 => 0x28 },
	'envelopepriority' => { 61 => 0x3c },
	'enveloperecordversion' => { 61 => 0x0 },
	'epsonimageheight' => { 141 => 0x20c },
	'epsonimagewidth' => { 141 => 0x20b },
	'epsonsoftware' => { 141 => 0x20d },
	'equipmentinstitution' => { 177 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 177 => 'EquipmentManufacturer' },
	'equipmentversion' => { 137 => 0x0 },
	'ettlii' => { 31 => 0x304, 32 => 0xd, 33 => 0xe, 34 => 0x7, 35 => 0x7, 36 => 0xe },
	'event' => { 179 => 'Event' },
	'evsteps' => { 156 => '1.2', 158 => 0x0 },
	'evstepsize' => { 121 => '748.7' },
	'excursiontolerance' => { 62 => 0x82 },
	'exifbyteorder' => { 55 => 'ExifByteOrder' },
	'exifcamerainfo' => { 60 => 0xe8 },
	'exifimageheight' => { 54 => 0xa003, 186 => 'PixelYDimension' },
	'exifimagewidth' => { 54 => 0xa002, 186 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 55 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 54 => 0x9000, 186 => 'ExifVersion' },
	'exitpupilposition' => { 111 => 0x4 },
	'expirationdate' => { 60 => 0x25 },
	'expirationtime' => { 60 => 0x26 },
	'exposure' => { 54 => 0xfe51, 183 => 'Exposure' },
	'exposurebracketstepsize' => { 156 => 0x8 },
	'exposurebracketvalue' => { 112 => 0x19 },
	'exposurecompensation' => { 28 => 0x6, 40 => 0x0, 54 => 0x9204, 66 => 0x24, 77 => 'ExposureComp', 91 => 0xd, 92 => 0x53, 93 => 0x1e, 94 => 0x1, 141 => 0x1006, 163 => 0x16, 175 => [0xc,0x35], 186 => 'ExposureBiasValue' },
	'exposurecontrolstepsize' => { 119 => '796.2' },
	'exposuredelaymode' => { 119 => '800.1', 121 => '754.4' },
	'exposuredifference' => { 112 => 0xe },
	'exposureindex' => { 54 => 0xa215, 186 => 'ExposureIndex' },
	'exposurelevelincrements' => { 29 => 0x6, 30 => 0x6, 31 => 0x101, 32 => 0x5, 33 => 0x6, 34 => 0x5, 35 => 0x5, 36 => 0x6, 37 => 0x4 },
	'exposuremode' => { 54 => 0xa402, 77 => 'ExposureMode', 91 => 0x1, 92 => 0xa, 93 => 0x0, 94 => 0x0, 136 => 0x200, 175 => 0x8, 176 => 0xb041, 186 => 'ExposureMode' },
	'exposuremodeinmanual' => { 31 => 0x10b },
	'exposureprogram' => { 54 => 0x8822, 186 => 'ExposureProgram' },
	'exposuretime' => { 1 => 0x4, 2 => 0x4, 3 => 0x4, 4 => 0x4, 7 => 0x4, 8 => 0x6, 28 => 0x16, 54 => 0x829a, 64 => 0xfd05, 66 => 0x20, 67 => 0xfa24, 69 => 0xf104, 73 => 0x38, 77 => 'ExposureTime', 91 => 0x9, 92 => 0x35, 93 => 0x48, 163 => 0x12, 175 => 0x32, 186 => 'ExposureTime' },
	'exposuretime2' => { 175 => 0x33 },
	'exposurevalue' => { 65 => 0x3 },
	'exposurewarning' => { 58 => 0x1302 },
	'extendedwbdetect' => { 136 => 0x902 },
	'extender' => { 137 => 0x301 },
	'extenderfirmwareversion' => { 137 => 0x304 },
	'extendermagnification' => { 79 => 'Magnification' },
	'extendermake' => { 79 => 'Make' },
	'extendermodel' => { 79 => 'Model', 137 => 0x303 },
	'extenderserialnumber' => { 79 => 'SerialNumber', 137 => 0x302 },
	'externalflash' => { 139 => 0x1201 },
	'externalflashae1' => { 141 => 0x101f },
	'externalflashae1_0' => { 141 => 0x101b },
	'externalflashae2' => { 141 => 0x1020 },
	'externalflashae2_0' => { 141 => 0x101c },
	'externalflashbounce' => { 139 => 0x1204, 141 => 0x1026, 159 => 0x1a },
	'externalflashexposurecomp' => { 159 => 0x19 },
	'externalflashflags' => { 106 => 0x8, 107 => 0x8 },
	'externalflashguidenumber' => { 139 => 0x1203, 159 => '24.1' },
	'externalflashgvalue' => { 141 => 0x1025 },
	'externalflashmode' => { 141 => 0x1028, 159 => 0x2 },
	'externalflashzoom' => { 139 => 0x1205, 141 => 0x1027 },
	'externalsensorbrightnessvalue' => { 148 => 0x311 },
	'face0position' => { 16 => 0x8 },
	'face1position' => { 16 => 0xa },
	'face2position' => { 16 => 0xc },
	'face3position' => { 16 => 0xe },
	'face4position' => { 16 => 0x10 },
	'face5position' => { 16 => 0x12 },
	'face6position' => { 16 => 0x14 },
	'face7position' => { 16 => 0x16 },
	'face8position' => { 16 => 0x18 },
	'facedetect' => { 140 => 0x1200 },
	'facedetectarea' => { 140 => 0x1201 },
	'facedetectframeheight' => { 16 => 0x4 },
	'facedetectframewidth' => { 16 => 0x3 },
	'facesdetected' => { 16 => 0x2, 17 => 0x2 },
	'ffid' => { 185 => 'ffid' },
	'fieldcount' => { 141 => 0x103f },
	'filedatarate' => { 194 => 'fileDataRate' },
	'fileformat' => { 42 => 0x0, 61 => 0x14 },
	'fileindex' => { 3 => 0x172, 5 => 0x133 },
	'filemodifydate' => { 55 => 'FileModifyDate' },
	'filename' => { 55 => 'FileName' },
	'filenameasdelivered' => { 190 => 'FileNameAsDelivered' },
	'filenumber' => { 18 => 0x1, 21 => 0x8, 44 => 0x1817, 105 => 0x8 },
	'filenumbermemory' => { 91 => 0x1a },
	'filenumbersequence' => { 119 => '802.2' },
	'filesource' => { 54 => 0xa300, 58 => 0x8000, 186 => 'FileSource' },
	'fileversion' => { 61 => 0x16 },
	'fillflashautoreduction' => { 29 => 0xe, 30 => 0xe, 37 => 0xa },
	'filllight' => { 183 => 'FillLight' },
	'fillorder' => { 54 => 0x10a },
	'filmmode' => { 58 => 0x1401, 150 => 0x42 },
	'filmtype' => { 117 => 0x2 },
	'filter' => { 51 => 0x3017 },
	'filtereffect' => { 18 => 0xe, 114 => 0x37 },
	'filtereffectmonochrome' => { 7 => 0xff },
	'finderdisplayduringexposure' => { 30 => 0x1 },
	'finetuneoptcenterweighted' => { 119 => '797.2' },
	'finetuneoptmatrixmetering' => { 119 => '798.1' },
	'finetuneoptspotmetering' => { 119 => '798.2' },
	'finetunestepsize' => { 119 => '796.3' },
	'firmware' => { 141 => 0x405, 175 => [0x17,0x3b], 181 => 'Firmware' },
	'firmwaredate' => { 50 => 0x15, 51 => 0x2001 },
	'firmwareid' => { 96 => 0x0 },
	'firmwarerevision' => { 7 => 0xa4, 21 => 0x1e },
	'firmwareversion' => { 3 => 0x136, 5 => 0xff, 6 => [0x107,0x10b], 65 => 0xce5, 77 => 'FirmwareVersion', 150 => 0x2 },
	'firstpublicationdate' => { 190 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 60 => 0x16 },
	'flash' => { 54 => 0x9209, 92 => 0x1f, 93 => 0x15 },
	'flashactivity' => { 9 => 0x1c },
	'flashbias' => { 150 => 0x24 },
	'flashbits' => { 9 => 0x1d },
	'flashchargelevel' => { 141 => 0x1010 },
	'flashcommandermode' => { 106 => '9.1', 107 => '9.1' },
	'flashcompensation' => { 181 => 'FlashCompensation' },
	'flashcontrolmode' => { 106 => '9.2', 107 => '9.2' },
	'flashdevice' => { 141 => 0x1005 },
	'flashdistance' => { 51 => 0x2034 },
	'flashenergy' => { 54 => 0xa20b, 186 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 112 => 0x18 },
	'flashexposurecomp' => { 28 => 0xf, 58 => 0x1011, 80 => 'ExposureComp', 91 => 0x23, 95 => 0x104, 106 => 0xa, 107 => 0xa, 112 => 0x12, 136 => 0x401, 141 => 0x1023, 163 => 0x4d, 175 => 0x3a, 176 => 0x104 },
	'flashexposurecompset' => { 152 => 0xe },
	'flashfired' => { 66 => 0x5d, 80 => 'Fired', 91 => 0x14, 121 => '590.3', 186 => 'FlashFired' },
	'flashfiring' => { 31 => 0x306, 32 => 0x6, 33 => 0x7, 36 => 0x7 },
	'flashfirmwareversion' => { 137 => 0x1002 },
	'flashfocallength' => { 106 => 0xb, 107 => 0xc },
	'flashfunction' => { 186 => 'FlashFunction' },
	'flashgroupacontrolmode' => { 106 => 0xf, 107 => 0x10 },
	'flashgroupaexposurecomp' => { 106 => 0x11, 107 => 0x12 },
	'flashgroupaoutput' => { 106 => 0x11, 107 => 0x12 },
	'flashgroupbcontrolmode' => { 106 => 0x10, 107 => 0x11 },
	'flashgroupbexposurecomp' => { 106 => 0x12, 107 => 0x13 },
	'flashgroupboutput' => { 106 => 0x12, 107 => 0x13 },
	'flashguidenumber' => { 28 => 0xd, 41 => 0x0, 80 => 'GuideNumber' },
	'flashintensity' => { 50 => [0x19,0x5] },
	'flashlevel' => { 120 => 0x2e2 },
	'flashmake' => { 80 => 'Make' },
	'flashmanufacturer' => { 180 => 'FlashManufacturer' },
	'flashmetering' => { 91 => 0x3f },
	'flashmeteringsegments' => { 163 => 0x20a },
	'flashmode' => { 50 => 0x4, 66 => 0x5c, 80 => 'Mode', 91 => 0x2, 92 => 0x20, 93 => 0x16, 112 => 0x87, 136 => 0x400, 141 => 0x1004, 163 => 0xc, 165 => 0x4, 172 => 0x20, 174 => 0x225, 186 => 'FlashMode' },
	'flashmodel' => { 80 => 'Model', 137 => 0x1001, 180 => 'FlashModel' },
	'flashoptions' => { 156 => 0x2 },
	'flashoptions2' => { 156 => 0x10 },
	'flashoutput' => { 28 => 0x21, 106 => 0xa, 107 => 0xa },
	'flashpixversion' => { 54 => 0xa000, 186 => 'FlashpixVersion' },
	'flashredeyemode' => { 186 => 'FlashRedEyeMode' },
	'flashreturn' => { 186 => 'FlashReturn' },
	'flashserialnumber' => { 80 => 'SerialNumber', 137 => 0x1003 },
	'flashsetting' => { 112 => 0x8 },
	'flashshutterspeed' => { 119 => '810.2', 121 => '755.1' },
	'flashstatus' => { 159 => 0x0 },
	'flashsyncspeed' => { 119 => '810.1' },
	'flashsyncspeedav' => { 29 => 0x3, 31 => 0x10f, 32 => 0x2, 33 => 0x3, 34 => 0x2, 35 => 0x2, 36 => 0x3, 37 => 0x6 },
	'flashthreshold' => { 41 => 0x1 },
	'flashtype' => { 80 => 'Type', 112 => 0x9, 137 => 0x1000 },
	'flickerreduce' => { 174 => 0x218 },
	'fliphorizontal' => { 130 => 0x76a43206 },
	'fnumber' => { 3 => 0x3, 7 => 0x3, 8 => 0x5, 28 => 0x15, 54 => 0x829d, 64 => 0xfd04, 66 => 0x1e, 67 => 0xfa23, 69 => 0xf103, 73 => 0x3c, 84 => 'FNumber', 91 => 0xa, 92 => 0x36, 93 => 0x47, 163 => 0x13, 175 => 0x31, 186 => 'FNumber' },
	'focallength' => { 1 => 0xa, 2 => 0x9, 3 => 0x1d, 4 => 0x9, 5 => 0x1d, 6 => 0x1d, 7 => 0x28, 20 => 0x1, 51 => 0x1d, 54 => 0x920a, 84 => 'FocalLength', 91 => 0x12, 111 => 0xa, 160 => 0x9, 163 => 0x1d, 186 => 'FocalLength' },
	'focallengthin35mmformat' => { 54 => 0xa405, 186 => 'FocalLengthIn35mmFilm' },
	'focalplanediagonal' => { 137 => 0x103, 141 => 0x205 },
	'focalplaneresolutionunit' => { 54 => 0xa210, 186 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 54 => 0xa20e, 186 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 20 => 0x2 },
	'focalplanexunknown' => { 20 => 0x2 },
	'focalplaneyresolution' => { 54 => 0xa20f, 186 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 20 => 0x3 },
	'focalplaneyunknown' => { 20 => 0x3 },
	'focaltype' => { 2 => 0x2d, 20 => 0x0 },
	'focalunits' => { 9 => 0x19 },
	'focus' => { 122 => 0x8 },
	'focusarea' => { 91 => 0x31 },
	'focusareaselection' => { 121 => '763.2' },
	'focuscontinuous' => { 9 => 0x20 },
	'focusdistance' => { 84 => 'FocusDistance', 91 => 0x13, 111 => 0x9, 139 => 0x305 },
	'focusdistancelower' => { 3 => 0x45, 5 => 0x45, 6 => 0x45, 28 => 0x14 },
	'focusdistanceupper' => { 3 => 0x43, 5 => 0x43, 6 => 0x43, 28 => 0x13 },
	'focusinfoversion' => { 139 => 0x0 },
	'focusingscreen' => { 30 => 0x0, 31 => 0x80b, 36 => 0x0 },
	'focusmode' => { 9 => 0x7, 50 => 0x3, 51 => [0x3003,0xd], 58 => 0x1021, 66 => 0x38, 77 => 'FocusMode', 91 => 0x30, 93 => 0xe, 112 => 0x7, 136 => 0x301, 141 => 0x100b, 150 => 0x7, 163 => 0xd, 165 => 0x3 },
	'focusmode2' => { 156 => '3.1' },
	'focusmodesetting' => { 120 => 0x2e3 },
	'focuspixel' => { 58 => 0x1023 },
	'focuspointwrap' => { 119 => '792.2' },
	'focusposition' => { 111 => 0x8, 163 => 0x10 },
	'focusprocess' => { 136 => 0x302 },
	'focusrange' => { 9 => 0x12, 141 => 0x100a },
	'focussetting' => { 175 => 0x6 },
	'focusstepcount' => { 139 => 0x301, 141 => 0x100e },
	'focusstepinfinity' => { 139 => 0x303 },
	'focusstepnear' => { 139 => 0x304 },
	'focustrackinglockon' => { 119 => '791.5' },
	'focuswarning' => { 58 => 0x1301 },
	'foldername' => { 91 => 0x27 },
	'fontschildfontfiles' => { 198 => 'FontsChildFontFiles' },
	'fontscomposite' => { 198 => 'FontsComposite' },
	'fontsfontface' => { 198 => 'FontsFontFace' },
	'fontsfontfamily' => { 198 => 'FontsFontFamily' },
	'fontsfontfilename' => { 198 => 'FontsFontFileName' },
	'fontsfontname' => { 198 => 'FontsFontName' },
	'fontsfonttype' => { 198 => 'FontsFontType' },
	'fontsversionstring' => { 198 => 'FontsVersionString' },
	'for' => { 171 => 'For' },
	'format' => { 184 => 'format' },
	'forwardmatrix1' => { 54 => 0xc714 },
	'forwardmatrix2' => { 54 => 0xc715 },
	'framenum' => { 166 => 0xd7 },
	'framenumber' => { 58 => 0x8003, 163 => 0x29 },
	'freebytes' => { 44 => 0x1 },
	'freememorycardimages' => { 92 => [0x37,0x54], 93 => [0x2d,0x4a] },
	'fujiflashmode' => { 58 => 0x1010 },
	'fullsizeimage' => { 83 => 'data' },
	'fullsizeimagename' => { 83 => '1Name' },
	'fullsizeimagetype' => { 83 => '0Type' },
	'functionbutton' => { 121 => '753.2' },
	'gainbase' => { 140 => 0x610 },
	'gaincontrol' => { 54 => 0xa407, 186 => 'GainControl' },
	'gamma' => { 54 => 0xa500 },
	'gammacompensatedvalue' => { 62 => 0x91 },
	'genre' => { 194 => 'genre' },
	'globalaltitude' => { 169 => 0x419 },
	'globalangle' => { 169 => 0x40d },
	'gpsaltitude' => { 59 => 0x6, 81 => 'Altitude', 186 => 'GPSAltitude' },
	'gpsaltituderef' => { 59 => 0x5, 186 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 59 => 0x1c, 186 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 59 => 0x1d },
	'gpsdatetime' => { 81 => 'DateTime', 186 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 59 => 0x18, 81 => 'Bearing', 186 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 59 => 0x17, 186 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 59 => 0x1a, 81 => 'Distance', 186 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 59 => 0x19, 186 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 59 => 0x14, 186 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 59 => 0x13 },
	'gpsdestlongitude' => { 59 => 0x16, 186 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 59 => 0x15 },
	'gpsdifferential' => { 59 => 0x1e, 81 => 'Differential', 186 => 'GPSDifferential' },
	'gpsdop' => { 59 => 0xb, 186 => 'GPSDOP' },
	'gpsimgdirection' => { 59 => 0x11, 186 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 59 => 0x10, 186 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 59 => 0x2, 81 => 'Latitude', 186 => 'GPSLatitude' },
	'gpslatituderef' => { 59 => 0x1 },
	'gpslongitude' => { 59 => 0x4, 81 => 'Longitude', 186 => 'GPSLongitude' },
	'gpslongituderef' => { 59 => 0x3 },
	'gpsmapdatum' => { 59 => 0x12, 81 => 'Datum', 186 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 59 => 0xa, 81 => 'MeasureMode', 186 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 59 => 0x1b, 186 => 'GPSProcessingMethod' },
	'gpssatellites' => { 59 => 0x8, 81 => 'Satellites', 186 => 'GPSSatellites' },
	'gpsspeed' => { 59 => 0xd, 81 => 'Speed', 186 => 'GPSSpeed' },
	'gpsspeedref' => { 59 => 0xc, 186 => 'GPSSpeedRef' },
	'gpsstatus' => { 59 => 0x9, 186 => 'GPSStatus' },
	'gpstimestamp' => { 59 => 0x7 },
	'gpstrack' => { 59 => 0xf, 81 => 'Heading', 186 => 'GPSTrack' },
	'gpstrackref' => { 59 => 0xe, 186 => 'GPSTrackRef' },
	'gpsversionid' => { 59 => 0x0, 186 => 'GPSVersionID' },
	'gradation' => { 136 => 0x50f },
	'graymixeraqua' => { 183 => 'GrayMixerAqua' },
	'graymixerblue' => { 183 => 'GrayMixerBlue' },
	'graymixergreen' => { 183 => 'GrayMixerGreen' },
	'graymixermagenta' => { 183 => 'GrayMixerMagenta' },
	'graymixerorange' => { 183 => 'GrayMixerOrange' },
	'graymixerpurple' => { 183 => 'GrayMixerPurple' },
	'graymixerred' => { 183 => 'GrayMixerRed' },
	'graymixeryellow' => { 183 => 'GrayMixerYellow' },
	'grayresponseunit' => { 54 => 0x122 },
	'greencurvelimits' => { 48 => 0x1c4 },
	'greencurvepoints' => { 48 => 0x19a },
	'greenhue' => { 183 => 'GreenHue' },
	'greensaturation' => { 183 => 'GreenSaturation' },
	'griddisplay' => { 119 => '803.3', 121 => '754.1' },
	'halftonehints' => { 54 => 0x141 },
	'hascrop' => { 183 => 'HasCrop' },
	'hassettings' => { 183 => 'HasSettings' },
	'headline' => { 60 => 0x69, 189 => 'Headline' },
	'hierarchicalsubject' => { 178 => 'hierarchicalSubject' },
	'highisonoisereduction' => { 31 => 0x202, 112 => 0xb1, 163 => 0x71 },
	'highlight' => { 175 => 0xf },
	'highlightrecovery' => { 183 => 'HighlightRecovery' },
	'highlighttonepriority' => { 31 => 0x203 },
	'history' => { 189 => 'History' },
	'historyaction' => { 195 => 'HistoryAction' },
	'historyinstanceid' => { 195 => 'HistoryInstanceID' },
	'historyparameters' => { 195 => 'HistoryParameters' },
	'historysoftwareagent' => { 195 => 'HistorySoftwareAgent' },
	'historywhen' => { 195 => 'HistoryWhen' },
	'hometowncity' => { 51 => 0x3006, 163 => 0x23 },
	'hometowncitycode' => { 165 => 0x1000 },
	'hometowndst' => { 163 => 0x25 },
	'hostcomputer' => { 54 => 0x13c },
	'hue' => { 97 => 0x3b },
	'hueadjustment' => { 92 => 0x4a, 93 => 0x40, 112 => 0x92, 114 => 0x36 },
	'hueadjustmentaqua' => { 183 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 183 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 183 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 183 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 183 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 183 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 183 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 183 => 'HueAdjustmentYellow' },
	'huesetting' => { 144 => 0x1011 },
	'icc_profile' => { 55 => 'ICC_Profile' },
	'iccprofilename' => { 189 => 'ICCProfile' },
	'identifier' => { 184 => 'identifier', 192 => 'Identifier' },
	'illumination' => { 121 => '748.5' },
	'imageadjustment' => { 112 => 0x80, 122 => 0x5 },
	'imagealterationconstraints' => { 190 => 'ImageAlterationConstraints' },
	'imageareaoffset' => { 163 => 0x38 },
	'imageauthentication' => { 112 => 0x20 },
	'imageboundary' => { 112 => 0x16 },
	'imagecount' => { 112 => 0xa5 },
	'imagecreatorid' => { 190 => 'ImageCreatorImageCreatorID' },
	'imagecreatorimageid' => { 190 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 190 => 'ImageCreatorImageCreatorName' },
	'imagedatasize' => { 112 => 0xa2 },
	'imagedescription' => { 54 => 0x10e, 191 => 'ImageDescription' },
	'imageduplicationconstraints' => { 190 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 130 => 0xfe443a45 },
	'imagefileconstraints' => { 190 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 190 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 190 => 'ImageFileSizeAsDelivered' },
	'imageheight' => { 54 => 0x101, 96 => 0xc, 191 => 'ImageLength' },
	'imagehistory' => { 54 => 0x9213 },
	'imageidnumber' => { 148 => 0x340 },
	'imagenumber' => { 7 => 0xd0, 54 => 0x9211, 77 => 'ImageNumber', 92 => 0xae, 93 => 0x5e, 181 => 'ImageNumber' },
	'imagenumber2' => { 93 => 0x62 },
	'imageoptimization' => { 112 => 0xa9 },
	'imageorientation' => { 60 => 0x83 },
	'imageprocessing' => { 112 => 0x1a, 163 => 0x32 },
	'imageprocessingcount' => { 163 => 0x41 },
	'imageprocessingversion' => { 140 => 0x0 },
	'imagequality' => { 77 => 'ImageQuality', 150 => 0x1 },
	'imagequality2' => { 136 => 0x603 },
	'imagereview' => { 120 => '729.4', 121 => '748.4' },
	'imagereviewtime' => { 120 => 0x2db },
	'imagesize' => { 83 => 'ImageSize' },
	'imagesourcedata' => { 54 => 0x935c },
	'imagestabilization' => { 9 => 0x22, 51 => 0x3020, 77 => 'ImageStabilization', 92 => 0xbd, 93 => 0x71, 94 => 0x57, 95 => [0x18,0x107,0x113], 112 => 0xac, 139 => 0x1600, 150 => 0x1a, 176 => 0xb026 },
	'imagesupplierid' => { 190 => 'ImageSupplierImageSupplierID' },
	'imagesupplierimageid' => { 190 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 190 => 'ImageSupplierImageSupplierName' },
	'imagetone' => { 163 => 0x4f },
	'imagetype' => { 60 => 0x82, 190 => 'ImageType' },
	'imageuniqueid' => { 54 => 0xa420, 186 => 'ImageUniqueID' },
	'imagewidth' => { 54 => 0x100, 96 => 0xe, 191 => 'ImageWidth' },
	'incrementaltemperature' => { 183 => 'IncrementalTemperature' },
	'incrementaltint' => { 183 => 'IncrementalTint' },
	'infinitylensstep' => { 141 => 0x103b },
	'infobuttonwhenshooting' => { 31 => 0x409 },
	'initialzoomsetting' => { 119 => '799.3' },
	'inkset' => { 54 => 0x14c },
	'instanceid' => { 195 => 'InstanceID' },
	'instructions' => { 189 => 'Instructions' },
	'instrument' => { 194 => 'instrument' },
	'intellectualgenre' => { 187 => 'IntellectualGenre' },
	'interchangecolorspace' => { 62 => 0x40 },
	'internalflash' => { 91 => 0x2b, 119 => '813.1', 120 => '737.1', 121 => '756.1', 139 => 0x1208 },
	'internalflashae1' => { 141 => 0x1021 },
	'internalflashae1_0' => { 141 => 0x101d },
	'internalflashae2' => { 141 => 0x1022 },
	'internalflashae2_0' => { 141 => 0x101e },
	'internalflashmode' => { 159 => 0x1 },
	'internalflashstrength' => { 159 => 0x3 },
	'internalflashtable' => { 141 => 0x1024 },
	'internalserialnumber' => { 21 => 0x96, 27 => 0x9, 58 => 0x10, 137 => 0x102, 150 => 0x25, 155 => 0x4 },
	'interopindex' => { 54 => 0x1 },
	'interopversion' => { 54 => 0x2 },
	'intervallength' => { 91 => 0x10 },
	'intervalmode' => { 91 => 0x26 },
	'intervalnumber' => { 91 => 0x11 },
	'introtime' => { 194 => 'introTime' },
	'iptc-naa' => { 54 => 0x83bb },
	'iptcbitspersample' => { 62 => 0x56 },
	'iptcimageheight' => { 62 => 0x1e },
	'iptcimagerotation' => { 62 => 0x66 },
	'iptcimagewidth' => { 62 => 0x14 },
	'iptcpicturenumber' => { 62 => 0xa },
	'iptcpixelheight' => { 62 => 0x32 },
	'iptcpixelwidth' => { 62 => 0x28 },
	'iso' => { 2 => 0x75, 3 => 0x6, 4 => 0x79, 7 => 0x6, 8 => 0x0, 50 => 0x14, 51 => [0x3014,0x14], 54 => 0x8827, 64 => 0xfd06, 65 => 0x1784, 66 => 0x60, 67 => [0xfa2e,0xfa46], 68 => [0x27,0x28], 69 => 0xf105, 73 => 0x4e, 77 => 'ISO', 91 => 0x8, 109 => 0x0, 112 => 0x2, 151 => 0x17, 163 => 0x14, 165 => 0x14, 186 => 'ISOSpeedRatings' },
	'iso2' => { 109 => 0x6, 118 => 0x256, 119 => 0x25c },
	'isoexpansion' => { 31 => 0x103, 32 => 0x7, 33 => 0x8, 36 => 0x8, 109 => 0x4 },
	'isoexpansion2' => { 109 => 0xa },
	'isofloor' => { 156 => 0x6 },
	'isoselection' => { 112 => 0xf },
	'isosetting' => { 66 => 0x5e, 77 => 'ISOSetting', 91 => 0x24, 92 => 0x26, 93 => 0x1c, 97 => 0x6, 112 => 0x13, 156 => '17.3', 172 => 0x27 },
	'isospeedexpansion' => { 30 => 0x3 },
	'isospeedincrements' => { 31 => 0x102 },
	'isospeedrange' => { 31 => 0x103 },
	'isostepsize' => { 119 => '796.1' },
	'isovalue' => { 141 => 0x1001 },
	'jobid' => { 60 => 0xb8 },
	'jobrefid' => { 193 => 'JobRefId' },
	'jobrefname' => { 193 => 'JobRefName' },
	'jobrefurl' => { 193 => 'JobRefUrl' },
	'jpegquality' => { 2 => 0x66 },
	'jpgfromraw' => { 44 => 0x2007, 52 => 'JpgFromRaw' },
	'jpgfromrawlength' => { 54 => [0x117,0x202] },
	'jpgfromrawstart' => { 54 => [0x111,0x201] },
	'jpgrecordedpixels' => { 156 => 0xe },
	'key' => { 194 => 'key' },
	'keywords' => { 60 => 0x19, 78 => 'Keywords', 145 => 'Keywords', 171 => 'Keywords', 188 => 'Keywords' },
	'kodakimageheight' => { 64 => 0xf908, 66 => 0xe, 67 => [0xfa1e,0xfa52], 72 => 0x70 },
	'kodakimagewidth' => { 64 => 0xf907, 66 => 0xc, 67 => [0xfa1d,0xfa51], 72 => 0x6c },
	'kodakinfotype' => { 64 => 0xfa00 },
	'kodakmaker' => { 72 => 0x8 },
	'kodakmodel' => { 66 => 0x0, 72 => 0x28 },
	'label' => { 147 => 'Label', 192 => 'Label' },
	'language' => { 184 => 'language' },
	'languageidentifier' => { 60 => 0x87 },
	'lastfilenumber' => { 91 => 0x1b },
	'lastkeywordiptc' => { 180 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 180 => 'LastKeywordXMP' },
	'lasturl' => { 195 => 'LastURL' },
	'lc1' => { 160 => 0x2 },
	'lc10' => { 160 => 0xb },
	'lc11' => { 160 => 0xc },
	'lc12' => { 160 => 0xd },
	'lc14' => { 160 => 0xf },
	'lc15' => { 160 => 0x10 },
	'lc2' => { 160 => 0x3 },
	'lc3' => { 160 => 0x4 },
	'lc4' => { 160 => 0x5 },
	'lc5' => { 160 => 0x6 },
	'lc6' => { 160 => 0x7 },
	'lc7' => { 160 => 0x8 },
	'lcddisplayatpoweron' => { 31 => 0x811, 35 => 0xa },
	'lcddisplayreturntoshoot' => { 36 => 0x12 },
	'lcdillumination' => { 119 => '807.5' },
	'lcdilluminationduringbulb' => { 31 => 0x408 },
	'lcdpanels' => { 30 => 0x8 },
	'lcheditor' => { 130 => 0x8ae85e },
	'legacyiptcdigest' => { 189 => 'LegacyIPTCDigest' },
	'lens' => { 54 => 0xfdea, 112 => 0x84, 175 => 0xa, 181 => 'Lens' },
	'lensafstopbutton' => { 29 => 0x11, 30 => 0x13, 31 => 0x506, 32 => 0x10, 33 => 0x12, 36 => 0x13, 37 => 0x9 },
	'lensaperturerange' => { 175 => 0x30 },
	'lensdistortionparams' => { 141 => 0x206 },
	'lensdrivenoaf' => { 31 => 0x505 },
	'lensfirmwareversion' => { 137 => 0x204 },
	'lensfstops' => { 110 => 0x7, 111 => 0xc, 112 => 0x8b, 160 => '0.3' },
	'lensid' => { 181 => 'LensID' },
	'lensidnumber' => { 110 => 0x6, 111 => 0xb },
	'lensinfo' => { 181 => 'LensInfo' },
	'lenskind' => { 160 => 0x1 },
	'lensmake' => { 84 => 'Make' },
	'lensmanufacturer' => { 180 => 'LensManufacturer' },
	'lensmodel' => { 21 => 0x95, 84 => 'Model', 180 => 'LensModel' },
	'lensproperties' => { 137 => 0x20b },
	'lensserialnumber' => { 84 => 'SerialNumber', 137 => 0x202, 150 => 0x52 },
	'lenstemperature' => { 141 => 0x1008 },
	'lenstype' => { 1 => 0xd, 2 => 0xd, 3 => 0x112, 4 => 0xd, 5 => 0xd7, 7 => [0xd,0x98], 9 => 0x16, 95 => 0x10c, 112 => 0x83, 137 => 0x201, 148 => 0x310, 150 => 0x51, 161 => 0x0, 162 => 0x0, 163 => 0x3f, 176 => 0xb027 },
	'license' => { 182 => 'license' },
	'licenseeid' => { 190 => 'LicenseeLicenseeID' },
	'licenseeimageid' => { 190 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 190 => 'LicenseeImageNotes' },
	'licenseename' => { 190 => 'LicenseeLicenseeName' },
	'licenseenddate' => { 190 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 190 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 190 => 'LicenseeTransactionID' },
	'licenseid' => { 190 => 'LicenseID' },
	'licensestartdate' => { 190 => 'LicenseStartDate' },
	'licensetransactiondate' => { 190 => 'LicenseTransactionDate' },
	'licensetype' => { 185 => 'licensetype' },
	'licensorcity' => { 190 => 'LicensorLicensorCity' },
	'licensorcountry' => { 190 => 'LicensorLicensorCountry' },
	'licensoremail' => { 190 => 'LicensorLicensorEmail' },
	'licensorextendedaddress' => { 190 => 'LicensorLicensorExtendedAddress' },
	'licensorid' => { 190 => 'LicensorLicensorID' },
	'licensorimageid' => { 190 => 'LicensorImageID' },
	'licensorname' => { 190 => 'LicensorLicensorName' },
	'licensornotes' => { 190 => 'LicensorNotes' },
	'licensorpostalcode' => { 190 => 'LicensorLicensorPostalCode' },
	'licensorregion' => { 190 => 'LicensorLicensorRegion' },
	'licensorstreetaddress' => { 190 => 'LicensorLicensorStreetAddress' },
	'licensortelephone1' => { 190 => 'LicensorLicensorTelephone1' },
	'licensortelephone2' => { 190 => 'LicensorLicensorTelephone2' },
	'licensortelephonetype1' => { 190 => 'LicensorLicensorTelephoneType1' },
	'licensortelephonetype2' => { 190 => 'LicensorLicensorTelephoneType2' },
	'licensortransactionid' => { 190 => 'LicensorTransactionID' },
	'licensorurl' => { 190 => 'LicensorLicensorURL' },
	'lightcondition' => { 141 => 0x1009 },
	'lightreading' => { 163 => 0x15 },
	'lightsource' => { 54 => 0x9208, 112 => 0x90, 144 => 0x1000, 186 => 'LightSource' },
	'lightsourcespecial' => { 174 => 0x21d },
	'lightvaluecenter' => { 141 => 0x103d },
	'lightvalueperiphery' => { 141 => 0x103e },
	'linearresponselimit' => { 54 => 0xc62e },
	'liveviewexposuresimulation' => { 31 => 0x810 },
	'localcaption' => { 60 => 0x79 },
	'localizedcameramodel' => { 54 => 0xc615 },
	'location' => { 179 => 'Location', 187 => 'Location' },
	'lockmicrophonebutton' => { 31 => 0x709 },
	'logcomment' => { 194 => 'logComment' },
	'longexposurenoisereduction' => { 31 => 0x201, 32 => 0x1, 33 => 0x2, 34 => 0x1, 35 => 0x1, 36 => 0x2, 37 => 0x1, 176 => 0xb04e },
	'longfocal' => { 1 => 0x10, 2 => 0x13, 3 => 0x115, 4 => 0x13, 5 => 0xda, 7 => 0x95, 9 => 0x17 },
	'loop' => { 194 => 'loop' },
	'luminanceadjustmentaqua' => { 183 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 183 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 183 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 183 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 183 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 183 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 183 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 183 => 'LuminanceAdjustmentYellow' },
	'luminancenoisereduction' => { 49 => 0xbe },
	'luminancenr_tiff_jpeg' => { 49 => 0xda },
	'luminancesmoothing' => { 183 => 'LuminanceSmoothing' },
	'm16cversion' => { 148 => 0x333 },
	'macro' => { 58 => 0x1020, 141 => 0x202, 172 => 0x21, 174 => 0x202, 176 => 0xb040 },
	'macromode' => { 9 => 0x1, 91 => 0xb, 136 => 0x300, 150 => 0x1c },
	'magnifiedview' => { 33 => 0x11, 35 => 0x9 },
	'maindialexposurecomp' => { 121 => '748.6' },
	'make' => { 45 => 0x0, 54 => 0x10f, 77 => 'Make', 147 => 'Make', 151 => 0x10f, 191 => 'Make' },
	'makernote' => { 186 => 'MakerNote' },
	'makernotecanon' => { 53 => 'MakN', 54 => 0x927c },
	'makernotecasio' => { 53 => 'MakN', 54 => 0x927c },
	'makernotecasio2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotefujifilm' => { 53 => 'MakN', 54 => 0x927c },
	'makernotehp' => { 53 => 'MakN', 54 => 0x927c },
	'makernotehp2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotehp4' => { 53 => 'MakN', 54 => 0x927c },
	'makernotehp6' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteisl' => { 53 => 'MakN', 54 => 0x927c },
	'makernotejvc' => { 53 => 'MakN', 54 => 0x927c },
	'makernotejvctext' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak1a' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak1b' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak3' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak4' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak5' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak6a' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak6b' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak7' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak8a' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodak8b' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekodakunknown' => { 53 => 'MakN', 54 => 0x927c },
	'makernotekyocera' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteleica' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteleica2' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteleica3' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteminolta' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteminolta2' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteminolta3' => { 53 => 'MakN', 54 => 0x927c },
	'makernotenikon' => { 53 => 'MakN', 54 => 0x927c },
	'makernotenikon2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotenikon3' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteoffset' => { 174 => 0xff },
	'makernoteolympus' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteolympus2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepanasonic' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepanasonic2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepentax' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepentax2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepentax3' => { 53 => 'MakN', 54 => 0x927c },
	'makernotepentax4' => { 53 => 'MakN', 54 => 0x927c },
	'makernotericoh' => { 53 => 'MakN', 54 => 0x927c },
	'makernotericohtext' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesafety' => { 54 => 0xc635 },
	'makernotesanyo' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesanyoc4' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesanyopatch' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesigma' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesony' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesony2' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesony3' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesony4' => { 53 => 'MakN', 54 => 0x927c },
	'makernotesonysrf' => { 53 => 'MakN', 54 => 0x927c },
	'makernotetype' => { 173 => 0x1 },
	'makernoteunknown' => { 53 => 'MakN', 54 => 0x927c },
	'makernoteversion' => { 95 => 0x0, 112 => 0x1, 141 => 0x0, 150 => 0x8000, 173 => 0x2, 175 => 0x1d },
	'managedfromdocumentid' => { 195 => 'ManagedFromDocumentID' },
	'managedfrominstanceid' => { 195 => 'ManagedFromInstanceID' },
	'managedfrommanager' => { 195 => 'ManagedFromManager' },
	'managedfrommanagervariant' => { 195 => 'ManagedFromManagerVariant' },
	'managedfrommanageto' => { 195 => 'ManagedFromManageTo' },
	'managedfrommanageui' => { 195 => 'ManagedFromManageUI' },
	'managedfromrenditionclass' => { 195 => 'ManagedFromRenditionClass' },
	'managedfromrenditionparams' => { 195 => 'ManagedFromRenditionParams' },
	'managedfromversionid' => { 195 => 'ManagedFromVersionID' },
	'manager' => { 195 => 'Manager' },
	'managervariant' => { 195 => 'ManagerVariant' },
	'manageto' => { 195 => 'ManageTo' },
	'manageui' => { 195 => 'ManageUI' },
	'manometerpressure' => { 136 => 0x900 },
	'manometerreading' => { 136 => 0x901 },
	'manualflash' => { 139 => 0x1209 },
	'manualflashoutput' => { 9 => 0x29, 120 => '737.2', 121 => '756.2' },
	'manualfocusdistance' => { 112 => 0x85, 141 => 0x100c, 174 => 0x223 },
	'manualtv' => { 30 => 0x5, 31 => 0x705 },
	'manufacturedate' => { 155 => 0x1 },
	'marked' => { 197 => 'Marked' },
	'markerscomment' => { 194 => 'markersComment' },
	'markersduration' => { 194 => 'markersDuration' },
	'markerslocation' => { 194 => 'markersLocation' },
	'markersname' => { 194 => 'markersName' },
	'markersstarttime' => { 194 => 'markersStartTime' },
	'markerstarget' => { 194 => 'markersTarget' },
	'markerstype' => { 194 => 'markersType' },
	'maskedareas' => { 54 => 0xc68e },
	'masterdocumentid' => { 60 => 0xb9 },
	'mastergain' => { 117 => 0x50 },
	'maxaperture' => { 9 => 0x1a, 69 => 0x6103, 84 => 'MaxAperture', 91 => 0x17, 160 => '14.1' },
	'maxapertureatcurrentfocal' => { 137 => 0x20a },
	'maxapertureatmaxfocal' => { 58 => 0x1407, 84 => 'MaxApertureAtMaxFocal', 110 => 0xb, 111 => 0x10, 137 => 0x206 },
	'maxapertureatminfocal' => { 58 => 0x1406, 110 => 0xa, 111 => 0xf, 137 => 0x205 },
	'maxaperturevalue' => { 54 => 0x9205, 186 => 'MaxApertureValue' },
	'maxcontinuousrelease' => { 119 => '801.1' },
	'maxfocallength' => { 58 => 0x1405, 84 => 'MaxFocalLength', 110 => 0x9, 111 => 0xe, 137 => 0x208 },
	'maximumdensityrange' => { 62 => 0x8c },
	'maxpagesizeh' => { 198 => 'MaxPageSizeH' },
	'maxpagesizeunit' => { 198 => 'MaxPageSizeUnit' },
	'maxpagesizew' => { 198 => 'MaxPageSizeW' },
	'maxsamplevalue' => { 54 => 0x119 },
	'mb-d10batteries' => { 119 => '802.4' },
	'mb-d80batteries' => { 121 => '754.5' },
	'mcuversion' => { 110 => 0xc, 111 => 0x11 },
	'md5digest' => { 85 => 'zmd5' },
	'measuredev' => { 28 => 0x3, 44 => 0x1814, 77 => 'MeasuredEV' },
	'measuredlv' => { 148 => 0x312 },
	'mediaconstraints' => { 190 => 'MediaConstraints' },
	'mediasummarycode' => { 190 => 'MediaSummaryCode' },
	'menubuttondisplayposition' => { 29 => 0xb, 32 => 0xa, 33 => 0xb, 36 => 0xb },
	'menubuttonreturn' => { 37 => 0xb },
	'metadatadate' => { 192 => 'MetadataDate' },
	'metadatamoddate' => { 194 => 'metadataModDate' },
	'metering' => { 120 => 0x2df },
	'meteringmode' => { 9 => 0x11, 54 => 0x9207, 66 => 0x1c, 91 => 0x7, 92 => 0x25, 136 => 0x202, 163 => 0x17, 175 => 0x9, 186 => 'MeteringMode' },
	'meteringmode2' => { 156 => '2.1' },
	'meteringmode3' => { 156 => '16.1' },
	'meteringtime' => { 119 => '812.2', 120 => '732.2', 121 => '751.2' },
	'mieversion' => { 85 => '0Vers' },
	'minaperture' => { 9 => 0x1b, 84 => 'MinAperture', 160 => '0.2' },
	'minfocallength' => { 58 => 0x1404, 84 => 'MinFocalLength', 110 => 0x8, 111 => 0xd, 137 => 0x207 },
	'minoltadate' => { 91 => 0x15 },
	'minoltaimagesize' => { 91 => 0x4, 92 => 0xc, 93 => 0x2, 95 => 0x103 },
	'minoltamodelid' => { 91 => 0x25 },
	'minoltaquality' => { 91 => 0x5, 92 => 0xd, 93 => 0x3, 95 => [0x102,0x103], 141 => [0x102,0x103] },
	'minoltatime' => { 91 => 0x16 },
	'minormodelagedisclosure' => { 190 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 54 => 0x118 },
	'mirrorlockup' => { 29 => 0xc, 30 => 0xc, 31 => 0x60f, 32 => 0xb, 33 => 0xc, 34 => 0x6, 35 => 0x6, 36 => 0xc, 37 => 0x3 },
	'moddate' => { 188 => 'ModDate' },
	'model' => { 45 => 0x6, 54 => 0x110, 77 => 'Model', 147 => 'Model', 151 => 0x110, 191 => 'Model' },
	'modelingflash' => { 119 => '811.4', 121 => '755.3' },
	'modelreleaseid' => { 190 => 'ModelReleaseID' },
	'modelreleasestatus' => { 190 => 'ModelReleaseStatus' },
	'modifiedcolortemp' => { 22 => 0x9 },
	'modifieddigitalgain' => { 22 => 0xb },
	'modifiedparamflag' => { 19 => 0x1 },
	'modifiedpicturestyle' => { 22 => 0xa },
	'modifiedsaturation' => { 136 => 0x504 },
	'modifiedsensorbluelevel' => { 22 => 0x5 },
	'modifiedsensorredlevel' => { 22 => 0x4 },
	'modifiedsharpness' => { 22 => 0x2 },
	'modifiedsharpnessfreq' => { 22 => 0x3 },
	'modifiedtonecurve' => { 22 => 0x1 },
	'modifiedwhitebalance' => { 22 => 0x8 },
	'modifiedwhitebalanceblue' => { 22 => 0x7 },
	'modifiedwhitebalancered' => { 22 => 0x6 },
	'modifydate' => { 54 => 0x132, 78 => 'ModifyDate', 145 => 'ModDate', 146 => 'tIME', 171 => 'ModDate', 192 => 'ModifyDate' },
	'moirefilter' => { 54 => 0xfe58 },
	'monitorofftime' => { 119 => '808.2', 120 => '732.1', 121 => '751.1' },
	'monochromecontrast' => { 49 => 0x78 },
	'monochromefiltereffect' => { 49 => 0x74 },
	'monochromelinear' => { 49 => 0x7a },
	'monochromesharpness' => { 49 => 0x7c },
	'monochrometoningeffect' => { 49 => 0x76 },
	'monthdaycreated' => { 66 => 0x12, 73 => 0xe },
	'multiexposureautogain' => { 113 => 0x3 },
	'multiexposuremode' => { 113 => 0x1 },
	'multiexposureshots' => { 113 => 0x2 },
	'multipleexposureset' => { 156 => '10.1' },
	'multisample' => { 117 => 0x40 },
	'multiselector' => { 119 => '799.4' },
	'multiselectorplaybackmode' => { 119 => '799.2' },
	'multiselectorshootmode' => { 119 => '799.1' },
	'mycolormode' => { 23 => 0x2 },
	'nativedigest' => { 186 => 'NativeDigest', 191 => 'NativeDigest' },
	'ncdfileinfo' => { 65 => 0x414 },
	'ndfilter' => { 28 => 0x1c },
	'nearlensstep' => { 141 => 0x103c },
	'nefcompression' => { 112 => 0x93 },
	'newsphotoversion' => { 62 => 0x0 },
	'nickname' => { 192 => 'Nickname' },
	'nikon_0x00b9' => { 112 => 0xb9 },
	'nikoncaptureversion' => { 112 => 0xe09 },
	'nikoniccprofile' => { 112 => 0xe1d },
	'noisefilter' => { 136 => 0x527 },
	'noisereduction' => { 18 => 0x8, 58 => 0x100b, 92 => 0xb0, 93 => 0x60, 94 => 0x3f, 112 => 0x95, 130 => 0x753dcbc0, 136 => 0x50a, 141 => 0x103a, 150 => 0x2d, 163 => 0x49 },
	'noisereduction2' => { 140 => 0x1010 },
	'noisereductionapplied' => { 54 => 0xc6f7 },
	'noisereductionintensity' => { 131 => 0x9 },
	'noisereductionmethod' => { 131 => 0x11 },
	'noisereductionsharpness' => { 131 => 0xd },
	'nomemorycard' => { 119 => '812.1', 120 => '729.3', 121 => '748.3' },
	'nominalmaxaperture' => { 160 => 0xa },
	'nominalminaperture' => { 160 => '10.1' },
	'npages' => { 198 => 'NPages' },
	'nullrecord' => { 44 => 0x0 },
	'numberofbeats' => { 194 => 'numberOfBeats' },
	'numindexentries' => { 62 => 0x54 },
	'objectattributereference' => { 60 => 0x4 },
	'objectcycle' => { 60 => 0x4b },
	'objectdistance' => { 50 => 0x6, 51 => 0x2022 },
	'objectname' => { 60 => 0x5 },
	'objectpreviewdata' => { 60 => 0xca },
	'objectpreviewfileformat' => { 60 => 0xc8 },
	'objectpreviewfileversion' => { 60 => 0xc9 },
	'objecttypereference' => { 60 => 0x3 },
	'oecfcolumns' => { 186 => 'OECFColumns' },
	'oecfnames' => { 186 => 'OECFNames' },
	'oecfrows' => { 186 => 'OECFRows' },
	'oecfvalues' => { 186 => 'OECFValues' },
	'offsetschema' => { 54 => 0xea1d },
	'oldsubfiletype' => { 54 => 0xff },
	'olympusimageheight' => { 141 => 0x102f },
	'olympusimagewidth' => { 141 => 0x102e },
	'onetouchwb' => { 141 => 0x302 },
	'opticalzoom' => { 67 => 0xfa3d, 69 => [0x6006,0xf006], 70 => 0x1000, 71 => 0xf, 73 => 0x1e, 84 => 'OpticalZoom' },
	'opticalzoomcode' => { 28 => 0xa },
	'opticalzoommode' => { 150 => 0x34 },
	'opticalzoomon' => { 174 => 0x219 },
	'ordernumber' => { 58 => 0x8002 },
	'orientation' => { 54 => 0x112, 151 => 0x112, 191 => 'Orientation' },
	'originaldecisiondata' => { 52 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 21 => 0x83 },
	'originalfilename' => { 44 => 0x816, 65 => 0x3e9, 74 => 0x20 },
	'originalimageheight' => { 57 => 0x1 },
	'originalimagewidth' => { 57 => 0x0 },
	'originalrawfiledata' => { 54 => 0xc68c },
	'originalrawfiledigest' => { 54 => 0xc71d },
	'originalrawfilename' => { 54 => 0xc68b },
	'originaltransmissionreference' => { 60 => 0x67 },
	'originatingprogram' => { 60 => 0x41 },
	'os' => { 185 => 'os' },
	'otherconditions' => { 190 => 'OtherConditions' },
	'otherconstraints' => { 190 => 'OtherConstraints' },
	'otherimageinfo' => { 190 => 'OtherImageInfo' },
	'otherlicensedocuments' => { 190 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 190 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 190 => 'OtherLicenseRequirements' },
	'outcue' => { 194 => 'outCue' },
	'outputheight' => { 127 => 0xce },
	'outputheightinches' => { 127 => 0x96 },
	'outputpixels' => { 127 => 0xd6 },
	'outputresolution' => { 127 => 0xb6 },
	'outputwidth' => { 127 => 0xc6 },
	'outputwidthinches' => { 127 => 0x8e },
	'owner' => { 197 => 'Owner' },
	'ownerid' => { 60 => 0xbc },
	'ownername' => { 21 => 0x9, 44 => 0x810, 54 => 0xfde8, 77 => 'OwnerName', 181 => 'OwnerName' },
	'padding' => { 54 => 0xea1c },
	'pagename' => { 54 => 0x11d },
	'pagenumber' => { 54 => 0x129 },
	'panasonicexifversion' => { 150 => 0x26 },
	'panasonicrawversion' => { 151 => 0x1 },
	'panoramadirection' => { 24 => 0x5 },
	'panoramaframe' => { 24 => 0x2 },
	'panoramamode' => { 66 => 0x3c, 136 => 0x601 },
	'parametricdarks' => { 183 => 'ParametricDarks' },
	'parametrichighlights' => { 183 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 183 => 'ParametricHighlightSplit' },
	'parametriclights' => { 183 => 'ParametricLights' },
	'parametricmidtonesplit' => { 183 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 183 => 'ParametricShadows' },
	'parametricshadowsplit' => { 183 => 'ParametricShadowSplit' },
	'patientid' => { 177 => 'PatientID' },
	'patientsbirthdate' => { 177 => 'PatientDOB' },
	'patientsname' => { 177 => 'PatientName' },
	'patientssex' => { 177 => 'PatientSex' },
	'pdfversion' => { 188 => 'PDFVersion' },
	'pentaximagesize' => { 163 => 0x9 },
	'pentaxmodelid' => { 155 => 0x0, 163 => 0x5 },
	'pentaxmodeltype' => { 163 => 0x1 },
	'pentaxversion' => { 163 => 0x0 },
	'people' => { 179 => 'People' },
	'pf0customfuncregistration' => { 39 => 0x1 },
	'pf10retainprogramshift' => { 39 => 0xb },
	'pf13drivepriority' => { 39 => 0xe },
	'pf14disablefocussearch' => { 39 => 0xf },
	'pf15disableafassistbeam' => { 39 => 0x10 },
	'pf16autofocuspointshoot' => { 39 => 0x11 },
	'pf17disableafpointsel' => { 39 => 0x12 },
	'pf18enableautoafpointsel' => { 39 => 0x13 },
	'pf19continuousshootspeed' => { 39 => 0x14 },
	'pf19shootingspeedhigh' => { 38 => 0xa },
	'pf19shootingspeedlow' => { 38 => 0x9 },
	'pf1disableshootingmodes' => { 39 => 0x2 },
	'pf1value' => { 38 => 0x1 },
	'pf20limitcontinousshots' => { 39 => 0x15 },
	'pf20maxcontinousshots' => { 38 => 0xb },
	'pf21enablequietoperation' => { 39 => 0x16 },
	'pf23felocktime' => { 38 => 0xd },
	'pf23postreleasetime' => { 38 => 0xe },
	'pf23settimerlengths' => { 39 => 0x18 },
	'pf23shutterbuttontime' => { 38 => 0xc },
	'pf24lightlcdduringbulb' => { 39 => 0x19 },
	'pf25aemode' => { 38 => 0xf },
	'pf25afmode' => { 38 => 0x12 },
	'pf25afpointsel' => { 38 => 0x13 },
	'pf25colormatrix' => { 38 => 0x17 },
	'pf25defaultclearsettings' => { 39 => 0x1a },
	'pf25drivemode' => { 38 => 0x11 },
	'pf25imagesize' => { 38 => 0x14 },
	'pf25meteringmode' => { 38 => 0x10 },
	'pf25parameters' => { 38 => 0x16 },
	'pf25wbmode' => { 38 => 0x15 },
	'pf26shortenreleaselag' => { 39 => 0x1b },
	'pf27reversedialrotation' => { 39 => 0x1c },
	'pf27value' => { 38 => 0x18 },
	'pf28noquickdialexpcomp' => { 39 => 0x1d },
	'pf29quickdialswitchoff' => { 39 => 0x1e },
	'pf2disablemeteringmodes' => { 39 => 0x3 },
	'pf2value' => { 38 => 0x2 },
	'pf30enlargementmode' => { 39 => 0x1f },
	'pf31originaldecisiondata' => { 39 => 0x20 },
	'pf3manualexposuremetering' => { 39 => 0x4 },
	'pf3value' => { 38 => 0x3 },
	'pf4exposuretimelimits' => { 39 => 0x5 },
	'pf4exposuretimemax' => { 38 => 0x5 },
	'pf4exposuretimemin' => { 38 => 0x4 },
	'pf5aperturelimits' => { 39 => 0x6 },
	'pf5aperturemax' => { 38 => 0x7 },
	'pf5aperturemin' => { 38 => 0x6 },
	'pf6presetshootingmodes' => { 39 => 0x7 },
	'pf7bracketcontinuousshoot' => { 39 => 0x8 },
	'pf8bracketshots' => { 38 => 0x8 },
	'pf8setbracketshots' => { 39 => 0x9 },
	'pf9changebracketsequence' => { 39 => 0xa },
	'phonenumber' => { 78 => 'Phone' },
	'photoeffect' => { 9 => 0x28 },
	'photoeffects' => { 130 => 0xab5eca5e },
	'photoeffectsblue' => { 132 => 0x8 },
	'photoeffectsgreen' => { 132 => 0x6 },
	'photoeffectsred' => { 132 => 0x4 },
	'photoeffectstype' => { 132 => 0x0 },
	'photoinfoplayback' => { 119 => '807.6' },
	'photometricinterpretation' => { 54 => 0x106, 191 => 'PhotometricInterpretation' },
	'photoshopquality' => { 168 => 0x0 },
	'pictinfo' => { 174 => 0x208 },
	'picturecontroladjust' => { 114 => 0x30 },
	'picturecontrolbase' => { 114 => 0x18 },
	'picturecontrolname' => { 114 => 0x4 },
	'picturecontrolquickadjust' => { 114 => 0x31 },
	'picturefinish' => { 92 => 0x71 },
	'picturemode' => { 58 => 0x1031, 136 => 0x520, 163 => [0xb,0x33] },
	'picturemode2' => { 156 => 0x0 },
	'picturemodebwfilter' => { 136 => 0x525 },
	'picturemodecontrast' => { 136 => 0x523 },
	'picturemodehue' => { 136 => 0x522 },
	'picturemodesaturation' => { 136 => 0x521 },
	'picturemodesharpness' => { 136 => 0x524 },
	'picturemodetone' => { 136 => 0x526 },
	'picturestyle' => { 1 => [0x4b,0x51], 2 => 0x6c, 3 => 0x86, 4 => 0x73, 7 => 0x6c, 26 => 0xa, 49 => 0x4 },
	'planarconfiguration' => { 54 => 0x11c, 191 => 'PlanarConfiguration' },
	'platenames' => { 198 => 'PlateNames' },
	'plusversion' => { 190 => 'Version' },
	'pngwarning' => { 147 => 'Warning' },
	'postalcode' => { 82 => 'PostalCode' },
	'powersource' => { 154 => 0x0 },
	'precaptureframes' => { 141 => 0x300 },
	'predictor' => { 54 => 0x13d },
	'prefs' => { 60 => 0xdd, 167 => 'Prefs' },
	'preservedfilename' => { 195 => 'PreservedFileName' },
	'previewapplicationname' => { 54 => 0xc716 },
	'previewapplicationversion' => { 54 => 0xc717 },
	'previewcolorspace' => { 54 => 0xc71a },
	'previewdatetime' => { 54 => 0xc71b },
	'previewheight' => { 67 => 0xfa58 },
	'previewimage' => { 51 => 0x2000, 52 => 'PreviewImage', 53 => 'MakN', 54 => 0x927c, 56 => 0x4, 87 => 'data', 95 => 0x81, 141 => 0x280, 151 => 0x2e, 176 => 0x2001 },
	'previewimageborders' => { 163 => 0x3e },
	'previewimageheight' => { 25 => 0x4 },
	'previewimagelength' => { 25 => 0x2, 51 => 0x3, 54 => [0x117,0x202], 95 => 0x89, 115 => 0x202, 136 => 0x102, 141 => 0x1037, 163 => 0x3, 172 => 0x1e, 175 => 0x1b },
	'previewimagename' => { 87 => '1Name' },
	'previewimagesize' => { 51 => 0x2, 87 => 'ImageSize', 163 => 0x2, 175 => 0x1c },
	'previewimagestart' => { 25 => 0x5, 51 => 0x4, 54 => [0x111,0x201], 95 => 0x88, 115 => 0x201, 136 => 0x101, 141 => 0x1036, 163 => 0x4, 172 => 0x1c, 175 => 0x1a },
	'previewimagetype' => { 87 => '0Type' },
	'previewimagevalid' => { 136 => 0x100, 141 => 0x1035 },
	'previewimagewidth' => { 25 => 0x3 },
	'previewquality' => { 25 => 0x1 },
	'previewsettingsdigest' => { 54 => 0xc719 },
	'previewsettingsname' => { 54 => 0xc718 },
	'previewwidth' => { 67 => 0xfa57 },
	'primarychromaticities' => { 54 => 0x13f, 191 => 'PrimaryChromaticities' },
	'printim' => { 54 => 0xc4a5 },
	'privatertkinfo' => { 178 => 'privateRTKInfo' },
	'processingsoftware' => { 54 => 0xb },
	'producer' => { 145 => 'Producer', 188 => 'Producer' },
	'productid' => { 61 => 0x32 },
	'productioncode' => { 155 => 0x2 },
	'productorserviceconstraints' => { 190 => 'ProductOrServiceConstraints' },
	'profilecalibrationsig' => { 54 => 0xc6f4 },
	'profilecopyright' => { 54 => 0xc6fe },
	'profileembedpolicy' => { 54 => 0xc6fd },
	'profilehuesatmapdata1' => { 54 => 0xc6fa },
	'profilehuesatmapdata2' => { 54 => 0xc6fb },
	'profilehuesatmapdims' => { 54 => 0xc6f9 },
	'profilelooktabledata' => { 54 => 0xc726 },
	'profilelooktabledims' => { 54 => 0xc725 },
	'profilename' => { 54 => 0xc6f8 },
	'profiletonecurve' => { 54 => 0xc6fc },
	'programiso' => { 150 => 0x3c },
	'programline' => { 156 => '1.1' },
	'programmode' => { 97 => 0x5 },
	'programshift' => { 112 => 0xd },
	'programversion' => { 60 => 0x46 },
	'projectrefpath' => { 194 => 'projectRefPath' },
	'projectreftype' => { 194 => 'projectRefType' },
	'propertyreleaseid' => { 190 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 190 => 'PropertyReleaseStatus' },
	'province-state' => { 60 => 0x5f },
	'publisher' => { 184 => 'publisher' },
	'pulldown' => { 194 => 'pullDown' },
	'quality' => { 0 => 0x1, 9 => 0x3, 50 => 0x2, 51 => 0x3002, 58 => 0x1000, 66 => 0x9, 112 => 0x4, 122 => 0x3, 141 => 0x201, 148 => 0x300, 163 => 0x8, 165 => 0x2, 175 => 0x16, 176 => [0x102,0xb047] },
	'qualitymode' => { 51 => 0x8 },
	'quantizationmethod' => { 62 => 0x78 },
	'quickcontroldialinmeter' => { 31 => 0x703 },
	'quickshot' => { 174 => 0x213 },
	'rasterizedcaption' => { 60 => 0x7d },
	'rating' => { 54 => 0x4746, 166 => 0xdf, 185 => 'rating', 192 => 'Rating' },
	'ratingpercent' => { 54 => 0x4749, 180 => 'Rating' },
	'rawandjpgrecording' => { 29 => 0x8, 156 => 0xd },
	'rawbrightnessadj' => { 48 => 0x38 },
	'rawcoloradj' => { 48 => 0x2e },
	'rawcolortoneadj' => { 49 => 0x1a },
	'rawcontrastadj' => { 49 => 0x1e },
	'rawcropbottom' => { 166 => 0xd4 },
	'rawcropleft' => { 166 => 0xd1 },
	'rawcropright' => { 166 => 0xd3 },
	'rawcroptop' => { 166 => 0xd2 },
	'rawcustomsaturation' => { 48 => 0x30 },
	'rawcustomtone' => { 48 => 0x34 },
	'rawdatauniqueid' => { 54 => 0xc65d },
	'rawdepth' => { 96 => 0x10 },
	'rawdevautogradation' => { 143 => 0x119 },
	'rawdevcolorspace' => { 142 => 0x108, 143 => 0x109 },
	'rawdevcontrastvalue' => { 142 => 0x106, 143 => 0x105 },
	'rawdeveditstatus' => { 142 => 0x10b },
	'rawdevengine' => { 142 => 0x109, 143 => 0x10b },
	'rawdevexposurebiasvalue' => { 142 => 0x100, 143 => 0x100 },
	'rawdevgradation' => { 143 => 0x112 },
	'rawdevgraypoint' => { 142 => 0x103, 143 => 0x104 },
	'rawdevmemorycoloremphasis' => { 142 => 0x105, 143 => 0x108 },
	'rawdevnoisereduction' => { 142 => 0x10a, 143 => 0x10a },
	'rawdevpicturemode' => { 143 => 0x10c },
	'rawdevpm_bwfilter' => { 143 => 0x110 },
	'rawdevpmcontrast' => { 143 => 0x10e },
	'rawdevpmnoisefilter' => { 143 => 0x120 },
	'rawdevpmpicturetone' => { 143 => 0x111 },
	'rawdevpmsaturation' => { 143 => 0x10d },
	'rawdevpmsharpness' => { 143 => 0x10f },
	'rawdevsaturation3' => { 143 => 0x113 },
	'rawdevsaturationemphasis' => { 142 => 0x104, 143 => 0x107 },
	'rawdevsettings' => { 142 => 0x10c },
	'rawdevsharpnessvalue' => { 142 => 0x107, 143 => 0x106 },
	'rawdevversion' => { 142 => 0x0, 143 => 0x0 },
	'rawdevwbfineadjustment' => { 142 => 0x102, 143 => 0x103 },
	'rawdevwhitebalance' => { 143 => 0x101 },
	'rawdevwhitebalancevalue' => { 142 => 0x101, 143 => 0x102 },
	'rawfile' => { 54 => 0xfe4c },
	'rawfilename' => { 183 => 'RawFileName' },
	'rawhighlightpoint' => { 49 => 0x24 },
	'rawimagecenter' => { 112 => 0x99 },
	'rawimagedigest' => { 54 => 0xc71c },
	'rawimagesize' => { 163 => 0x39 },
	'rawinfoversion' => { 144 => 0x0 },
	'rawjpgheight' => { 46 => 0x4 },
	'rawjpgquality' => { 18 => 0x6, 46 => 0x1 },
	'rawjpgsize' => { 18 => 0x7, 46 => 0x2 },
	'rawjpgwidth' => { 46 => 0x3 },
	'rawlinear' => { 49 => 0x20 },
	'rawsaturationadj' => { 49 => 0x1c },
	'rawshadowpoint' => { 49 => 0x26 },
	'rawsharpnessadj' => { 49 => 0x22 },
	'recordid' => { 44 => 0x1804 },
	'recordingmode' => { 50 => 0x1, 165 => 0x1 },
	'recordmode' => { 9 => 0x9, 51 => 0x3000 },
	'recordshutterrelease' => { 174 => 0x217 },
	'redbalance' => { 141 => 0x1017, 151 => 0x11, 163 => 0x1c },
	'redcurvelimits' => { 48 => 0x18a },
	'redcurvepoints' => { 48 => 0x160 },
	'redeyecorrection' => { 133 => 0x0 },
	'redeyeinfo' => { 183 => 'RedEyeInfo' },
	'redhue' => { 183 => 'RedHue' },
	'redsaturation' => { 183 => 'RedSaturation' },
	'referenceblackwhite' => { 54 => 0x214, 191 => 'ReferenceBlackWhite' },
	'referencedate' => { 60 => 0x2f },
	'referencenumber' => { 60 => 0x32 },
	'references' => { 78 => 'References' },
	'referenceservice' => { 60 => 0x2d },
	'regionconstraints' => { 190 => 'RegionConstraints' },
	'relatedaudiofile' => { 76 => 'data' },
	'relatedaudiofilename' => { 76 => '1Name' },
	'relatedaudiofiletype' => { 76 => '0Type' },
	'relatedimagefileformat' => { 54 => 0x1000 },
	'relatedimageheight' => { 54 => 0x1002 },
	'relatedimagewidth' => { 54 => 0x1001 },
	'relatedsoundfile' => { 54 => 0xa004, 186 => 'RelatedSoundFile' },
	'relatedvideofile' => { 90 => 'data' },
	'relatedvideofilename' => { 90 => '1Name' },
	'relatedvideofiletype' => { 90 => '0Type' },
	'relation' => { 184 => 'relation' },
	'relativepeakaudiofilepath' => { 194 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 194 => 'relativeTimestamp' },
	'releasebuttontousedial' => { 119 => '807.8' },
	'releasedate' => { 60 => 0x1e, 194 => 'releaseDate' },
	'releasesetting' => { 44 => 0x1016 },
	'releasetime' => { 60 => 0x23 },
	'remoteonduration' => { 120 => '733.1', 121 => '752.3' },
	'renditionclass' => { 195 => 'RenditionClass' },
	'renditionofdocumentid' => { 195 => 'RenditionOfDocumentID' },
	'renditionofinstanceid' => { 195 => 'RenditionOfInstanceID' },
	'renditionofmanager' => { 195 => 'RenditionOfManager' },
	'renditionofmanagervariant' => { 195 => 'RenditionOfManagerVariant' },
	'renditionofmanageto' => { 195 => 'RenditionOfManageTo' },
	'renditionofmanageui' => { 195 => 'RenditionOfManageUI' },
	'renditionofrenditionclass' => { 195 => 'RenditionOfRenditionClass' },
	'renditionofrenditionparams' => { 195 => 'RenditionOfRenditionParams' },
	'renditionofversionid' => { 195 => 'RenditionOfVersionID' },
	'renditionparams' => { 195 => 'RenditionParams' },
	'repeatingflashcount' => { 106 => 0xd, 107 => 0xe, 121 => '757.2' },
	'repeatingflashoutput' => { 121 => '757.1' },
	'repeatingflashrate' => { 106 => 0xc, 107 => 0xd, 121 => '758.1' },
	'resampleparamsquality' => { 194 => 'resampleParamsQuality' },
	'resaved' => { 174 => 0x21e },
	'resolution' => { 83 => 'Resolution' },
	'resolutionmode' => { 175 => 0x4 },
	'resolutionunit' => { 54 => 0x128, 63 => 0x2, 191 => 'ResolutionUnit' },
	'retouchhistory' => { 112 => 0x9e },
	'retouchinfo' => { 183 => 'RetouchInfo' },
	'reuse' => { 190 => 'Reuse' },
	'reuseallowed' => { 196 => 'ReuseAllowed' },
	'reverseindicators' => { 119 => '802.1' },
	'revision' => { 185 => 'revision' },
	'rgbcurvelimits' => { 48 => 0x238 },
	'rgbcurvepoints' => { 48 => 0x20e },
	'ricohdate' => { 172 => 0x6 },
	'ricohimageheight' => { 172 => 0x2 },
	'ricohimagewidth' => { 172 => 0x0 },
	'rightascension' => { 86 => 'RightAscension' },
	'rights' => { 184 => 'rights' },
	'romoperationmode' => { 44 => 0x80d },
	'rotation' => { 8 => 0x17, 43 => 0x3, 48 => 0x26e, 57 => 0x4, 86 => 'Rotation', 92 => [0x65,0x50], 93 => 0x46, 94 => 0x5a, 121 => '590.1', 130 => 0x76a43207, 150 => 0x30, 156 => '17.2', 166 => 0xd8 },
	'routing' => { 171 => 'Routing' },
	'rowsperstrip' => { 54 => 0x116 },
	'safetyshift' => { 31 => 0x108 },
	'safetyshiftinavortv' => { 29 => 0x10, 30 => 0x10, 32 => 0xf, 33 => 0x10, 36 => 0x10 },
	'samplebits' => { 76 => 'SampleBits' },
	'samplerate' => { 76 => 'SampleRate' },
	'samplesperpixel' => { 54 => 0x115, 191 => 'SamplesPerPixel' },
	'samplestructure' => { 62 => 0x5a },
	'sanyoquality' => { 174 => 0x201 },
	'sanyothumbnail' => { 174 => 0x100 },
	'saturation' => { 2 => 0x6e, 4 => 0x76, 9 => 0xe, 15 => 0x1, 50 => 0xd, 51 => [0x3013,0x1f], 54 => [0xa409,0xfe55], 58 => 0x1003, 77 => 'Saturation', 91 => 0x1f, 92 => 0x32, 93 => 0x28, 94 => 0x1a, 97 => 0x1, 112 => [0x94,0xaa], 114 => 0x35, 150 => 0x40, 163 => 0x1f, 165 => 0xd, 172 => 0x28, 175 => 0x10, 183 => 'Saturation', 186 => 'Saturation' },
	'saturationadj' => { 48 => 0x116 },
	'saturationadjustmentaqua' => { 183 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 183 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 183 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 183 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 183 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 183 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 183 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 183 => 'SaturationAdjustmentYellow' },
	'saturationfaithful' => { 7 => 0xfe },
	'saturationinfo' => { 163 => 0x21b },
	'saturationlandscape' => { 7 => 0xfc },
	'saturationneutral' => { 7 => 0xfd },
	'saturationportrait' => { 7 => 0xfb },
	'saturationsetting' => { 144 => 0x1010 },
	'saturationstandard' => { 7 => 0xfa },
	'saturationuserdef1' => { 7 => 0x100 },
	'saturationuserdef2' => { 7 => 0x101 },
	'saturationuserdef3' => { 7 => 0x102 },
	'saveid' => { 195 => 'SaveID' },
	'scaledresolution' => { 127 => 0x9e },
	'scaletype' => { 194 => 'scaleType' },
	'scanningdirection' => { 62 => 0x64 },
	'scene' => { 187 => 'Scene', 194 => 'scene' },
	'scenearea' => { 139 => 0x211, 141 => 0x1031 },
	'sceneassist' => { 112 => 0x9c },
	'scenecapturetype' => { 54 => 0xa406, 186 => 'SceneCaptureType' },
	'scenedetect' => { 139 => 0x210, 141 => 0x1030 },
	'scenedetectdata' => { 139 => 0x212, 141 => 0x1033 },
	'scenemode' => { 67 => 0xfa02, 95 => 0x100, 112 => 0x8f, 136 => 0x509, 141 => 0x403, 150 => 0x8001, 176 => 0xb023 },
	'scenemodeused' => { 69 => [0x6002,0xf002] },
	'sceneselect' => { 174 => 0x21f },
	'scenetype' => { 54 => 0xa301, 186 => 'SceneType' },
	'securityclassification' => { 54 => 0x9212 },
	'selectableafpoint' => { 31 => 0x509 },
	'selftimer' => { 9 => 0x2, 51 => 0x3001, 150 => 0x2e, 174 => 0x214 },
	'selftimer2' => { 28 => 0x1d },
	'selftimermode' => { 54 => 0x882b },
	'selftimertime' => { 44 => 0x1806, 119 => '808.1', 120 => '732.3', 121 => '751.3' },
	'seminfo' => { 54 => 0x8546 },
	'sensingmethod' => { 54 => 0xa217, 186 => 'SensingMethod' },
	'sensitivityadjust' => { 163 => 0x40 },
	'sensitivitysteps' => { 156 => '17.4', 158 => 0x1 },
	'sensorbluelevel' => { 26 => 0x5 },
	'sensorcleaning' => { 37 => 0xd },
	'sensorfullheight' => { 64 => 0xf904 },
	'sensorfullwidth' => { 64 => 0xf903 },
	'sensorheight' => { 64 => 0xf901, 67 => 0xfa21, 96 => 0x8 },
	'sensorpixelsize' => { 112 => 0x9a },
	'sensorredlevel' => { 26 => 0x4 },
	'sensorsize' => { 77 => 'SensorSize' },
	'sensortemperature' => { 139 => 0x1500, 141 => 0x1007 },
	'sensorwidth' => { 64 => 0xf900, 67 => 0xfa20, 96 => 0xa },
	'sequencenumber' => { 28 => 0x9, 51 => 0x301c, 58 => 0x1101, 66 => 0x1d, 150 => 0x2b },
	'sequenceshotinterval' => { 174 => 0x224 },
	'sequentialshot' => { 174 => 0x20e },
	'serialnumber' => { 21 => 0xc, 44 => 0x180b, 54 => 0xfde9, 64 => 0xfa04, 67 => 0xfa19, 75 => 0x0, 77 => 'SerialNumber', 112 => 0xa0, 137 => 0x101, 141 => [0x404,0x101a], 148 => 0x303, 175 => 0x2, 181 => 'SerialNumber' },
	'serialnumberformat' => { 21 => 0x15, 44 => 0x183b },
	'seriesdatetime' => { 177 => 'SeriesDateTime' },
	'seriesdescription' => { 177 => 'SeriesDescription' },
	'seriesmodality' => { 177 => 'SeriesModality' },
	'seriesnumber' => { 177 => 'SeriesNumber' },
	'serviceidentifier' => { 61 => 0x1e },
	'setbuttoncrosskeysfunc' => { 34 => 0x0, 35 => 0x0 },
	'setbuttonfunction' => { 29 => 0x1, 37 => 0xc },
	'setbuttonwhenshooting' => { 31 => 0x704 },
	'setfunctionwhenshooting' => { 32 => 0x0, 33 => 0x1, 36 => 0x1 },
	'shadingcompensation' => { 136 => 0x50c },
	'shadingcompensation2' => { 140 => 0x1012 },
	'shadow' => { 175 => 0xe },
	'shadows' => { 54 => 0xfe52, 183 => 'Shadows' },
	'shadowscale' => { 54 => 0xc633 },
	'shadowtint' => { 183 => 'ShadowTint' },
	'shakereduction' => { 164 => 0x1 },
	'sharpendetail' => { 183 => 'SharpenDetail' },
	'sharpenedgemasking' => { 183 => 'SharpenEdgeMasking' },
	'sharpenradius' => { 183 => 'SharpenRadius' },
	'sharpness' => { 1 => [0x42,0x48], 2 => 0x72, 4 => 0x74, 9 => 0xf, 26 => 0x2, 50 => 0xb, 51 => [0x3011,0x21], 54 => [0xa40a,0xfe56], 58 => 0x1001, 66 => 0x6b, 73 => 0x37, 77 => 'Sharpness', 91 => 0x21, 92 => 0x30, 93 => 0x26, 94 => 0x18, 97 => 0x3, 112 => 0x6, 114 => 0x32, 141 => 0x100f, 150 => 0x41, 163 => 0x21, 165 => 0xb, 172 => 0x22, 173 => 0x1003, 175 => 0x11, 183 => 'Sharpness', 186 => 'Sharpness' },
	'sharpnessfactor' => { 141 => 0x102a },
	'sharpnessfaithful' => { 7 => 0xf5 },
	'sharpnessfrequency' => { 1 => [0x41,0x47], 26 => 0x3 },
	'sharpnesslandscape' => { 7 => 0xf3 },
	'sharpnessmonochrome' => { 7 => 0xf6 },
	'sharpnessneutral' => { 7 => 0xf4 },
	'sharpnessportrait' => { 7 => 0xf2 },
	'sharpnesssetting' => { 136 => 0x506, 144 => 0x1013 },
	'sharpnessstandard' => { 7 => 0xf1 },
	'sharpnessuserdef1' => { 7 => 0xf7 },
	'sharpnessuserdef2' => { 7 => 0xf8 },
	'sharpnessuserdef3' => { 7 => 0xf9 },
	'shootinginfodisplay' => { 119 => '803.2' },
	'shootingmode' => { 77 => 'ShootingMode', 112 => 0x89, 150 => 0x1f },
	'shootingmodesetting' => { 120 => '734.1' },
	'shortdescription' => { 185 => 'shortdescription' },
	'shortdocumentid' => { 60 => 0xba },
	'shortfocal' => { 1 => 0xe, 2 => 0x11, 3 => 0x113, 4 => 0x11, 5 => 0xd8, 7 => 0x93, 9 => 0x18 },
	'shortownername' => { 7 => 0xac },
	'shortreleasetimelag' => { 31 => 0x80d },
	'shotdate' => { 194 => 'shotDate' },
	'shotlocation' => { 194 => 'shotLocation' },
	'shotname' => { 194 => 'shotName' },
	'shutter-aelock' => { 29 => 0x4, 32 => 0x3, 33 => 0x4, 34 => 0x3, 35 => 0x3, 36 => 0x4, 37 => 0x2 },
	'shutteraelbutton' => { 30 => 0x4 },
	'shutterbuttonafonbutton' => { 31 => 0x701 },
	'shuttercount' => { 3 => 0x176, 18 => 0x1, 118 => [0x6a,0x157,0x276], 119 => 0x279, 120 => 0x246, 121 => 0x24a, 163 => 0x5d },
	'shuttercurtainsync' => { 29 => 0xf, 30 => 0xf, 31 => 0x305, 32 => 0xe, 33 => 0xf, 34 => 0x8, 35 => 0x8, 36 => 0xf, 37 => 0x8 },
	'shuttermode' => { 66 => 0x1b },
	'shutterreleasebuttonae-l' => { 119 => '807.7' },
	'shutterreleasemethod' => { 44 => 0x1010 },
	'shutterreleasenocfcard' => { 29 => 0x2, 30 => 0x2, 37 => 0xf },
	'shutterreleasetiming' => { 44 => 0x1011 },
	'shutterspeedrange' => { 31 => 0x10c },
	'shutterspeedvalue' => { 40 => 0x1, 54 => 0x9201, 141 => 0x1000, 186 => 'ShutterSpeedValue' },
	'sidecarforextension' => { 189 => 'SidecarForExtension' },
	'similarityindex' => { 60 => 0xe4 },
	'slaveflashmeteringsegments' => { 163 => 0x20b },
	'slowshutter' => { 28 => 0x8 },
	'slowsync' => { 58 => 0x1030 },
	'smoothness' => { 54 => 0xfe57 },
	'software' => { 54 => 0x131, 78 => 'Software', 147 => 'Software', 175 => 0x18, 191 => 'Software' },
	'softwareversion' => { 174 => 0x207 },
	'source' => { 60 => 0x73, 147 => 'Source', 184 => 'source', 185 => 'source', 189 => 'Source' },
	'sourceresolution' => { 127 => 0xae },
	'spatialfrequencyresponsecolumns' => { 186 => 'SpatialFrequencyResponseColumns' },
	'spatialfrequencyresponsenames' => { 186 => 'SpatialFrequencyResponseNames' },
	'spatialfrequencyresponserows' => { 186 => 'SpatialFrequencyResponseRows' },
	'spatialfrequencyresponsevalues' => { 186 => 'SpatialFrequencyResponseValues' },
	'speakerplacement' => { 194 => 'speakerPlacement' },
	'specialinstructions' => { 60 => 0x28 },
	'specialmode' => { 141 => 0x200, 174 => 0x200 },
	'spectralsensitivity' => { 54 => 0x8824, 186 => 'SpectralSensitivity' },
	'splittoningbalance' => { 183 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 183 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 183 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 183 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 183 => 'SplitToningShadowSaturation' },
	'spotfocuspointx' => { 91 => 0x2d },
	'spotfocuspointy' => { 91 => 0x2e },
	'spotmeteringmode' => { 9 => 0x27 },
	'spotmeterlinktoafpoint' => { 31 => 0x107 },
	'sractive' => { 156 => '17.1' },
	'srfocallength' => { 164 => 0x3 },
	'srhalfpresstime' => { 164 => 0x2 },
	'srresult' => { 164 => 0x0 },
	'starttimecodetimeformat' => { 194 => 'startTimecodeTimeFormat' },
	'starttimecodetimevalue' => { 194 => 'startTimecodeTimeValue' },
	'state' => { 82 => 'State', 189 => 'State' },
	'status' => { 179 => 'Status' },
	'storagemethod' => { 96 => 0x12 },
	'straightenangle' => { 130 => 0x2fc08431 },
	'stretchmode' => { 194 => 'stretchMode' },
	'studydatetime' => { 177 => 'StudyDateTime' },
	'studydescription' => { 177 => 'StudyDescription' },
	'studyid' => { 177 => 'StudyID' },
	'studyphysician' => { 177 => 'StudyPhysician' },
	'sub-location' => { 60 => 0x5c },
	'subfiledata' => { 85 => 'data' },
	'subfiledirectory' => { 85 => '1Directory' },
	'subfilemimetype' => { 85 => '2MIME' },
	'subfilename' => { 85 => '1Name' },
	'subfileresource' => { 85 => 'rsrc' },
	'subfiletype' => { 54 => 0xfe, 85 => '0Type' },
	'subject' => { 145 => 'Subject', 171 => 'Subject', 184 => 'subject', 188 => 'Subject' },
	'subjectarea' => { 186 => 'SubjectArea' },
	'subjectcode' => { 187 => 'SubjectCode' },
	'subjectdistance' => { 54 => 0x9206, 66 => 0x3e, 186 => 'SubjectDistance' },
	'subjectdistancerange' => { 54 => 0xa40c, 186 => 'SubjectDistanceRange' },
	'subjectlocation' => { 54 => [0x9214,0xa214], 186 => 'SubjectLocation' },
	'subjectprogram' => { 91 => 0x22 },
	'subjectreference' => { 60 => 0xc },
	'subsectime' => { 54 => 0x9290, 65 => 0x401 },
	'subsectimedigitized' => { 54 => 0x9292 },
	'subsectimeoriginal' => { 54 => 0x9291 },
	'superimposeddisplay' => { 29 => 0xa, 31 => 0x510, 32 => 0x9, 33 => 0xa, 36 => 0xa, 37 => 0xe },
	'supplementalcategories' => { 60 => 0x14, 189 => 'SupplementalCategories' },
	'supplementaltype' => { 62 => 0x37 },
	'svisosetting' => { 156 => 0x14 },
	'switchtoregisteredafpoint' => { 30 => 0x12, 31 => 0x50a },
	'tagged' => { 166 => 0xdd },
	'tapename' => { 194 => 'tapeName' },
	'targetaperture' => { 28 => 0x4 },
	'targetcompressionratio' => { 42 => 0x1 },
	'targetdistancesetting' => { 44 => 0x1807 },
	'targetexposuretime' => { 28 => 0x5 },
	'targetimagetype' => { 44 => 0x100a },
	'teleconverter' => { 95 => 0x105, 176 => 0x105 },
	'temperature' => { 183 => 'Temperature' },
	'tempo' => { 194 => 'tempo' },
	'termsandconditionstext' => { 190 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 190 => 'TermsAndConditionsURL' },
	'thresholding' => { 54 => 0x107 },
	'thumbnailfilename' => { 44 => 0x817 },
	'thumbnailheight' => { 67 => 0xfa55 },
	'thumbnailimage' => { 44 => 0x2008, 52 => 'ThumbnailImage', 56 => 0x3, 88 => 'data', 141 => 0x100 },
	'thumbnailimagename' => { 88 => '1Name' },
	'thumbnailimagesize' => { 88 => 'ImageSize' },
	'thumbnailimagetype' => { 88 => '0Type' },
	'thumbnailimagevalidarea' => { 21 => 0x13 },
	'thumbnaillength' => { 54 => 0x202 },
	'thumbnailoffset' => { 54 => 0x201 },
	'thumbnailsformat' => { 192 => 'ThumbnailsFormat' },
	'thumbnailsheight' => { 192 => 'ThumbnailsHeight' },
	'thumbnailsimage' => { 192 => 'ThumbnailsImage' },
	'thumbnailswidth' => { 192 => 'ThumbnailsWidth' },
	'thumbnailwidth' => { 67 => 0xfa54 },
	'tilelength' => { 54 => 0x143 },
	'tilewidth' => { 54 => 0x142 },
	'time' => { 163 => 0x7 },
	'timecreated' => { 60 => 0x3c, 66 => 0x14, 73 => 0x10, 167 => 'TimeCreated' },
	'timerfunctionbutton' => { 120 => '734.2' },
	'timerlength' => { 31 => 0x80c },
	'timescaleparamsframeoverlappingpercentage' => { 194 => 'timeScaleParamsFrameOverlappingPercentage' },
	'timescaleparamsframesize' => { 194 => 'timeScaleParamsFrameSize' },
	'timescaleparamsquality' => { 194 => 'timeScaleParamsQuality' },
	'timesent' => { 61 => 0x50 },
	'timesignature' => { 194 => 'timeSignature' },
	'timesincepoweron' => { 150 => 0x29 },
	'timestamp' => { 3 => 0x45e, 7 => 0x11c, 147 => 'TimeStamp' },
	'timestamp1' => { 3 => 0x45a },
	'timezone' => { 124 => 0x0 },
	'timezonecode' => { 47 => 0x1 },
	'timezoneinfo' => { 47 => 0x2 },
	'timezoneoffset' => { 54 => 0x882a },
	'tint' => { 183 => 'Tint' },
	'title' => { 54 => 0xc6d2, 78 => 'Title', 145 => 'Title', 147 => 'Title', 171 => 'Title', 184 => 'title', 188 => 'Title' },
	'tonecomp' => { 112 => 0x81 },
	'tonecurve' => { 26 => 0x1, 163 => 0x402, 183 => 'ToneCurve' },
	'tonecurveactive' => { 48 => 0x110 },
	'tonecurvefilename' => { 65 => 0x1391 },
	'tonecurvename' => { 183 => 'ToneCurveName' },
	'tonecurveproperty' => { 48 => 0x3c },
	'tonecurves' => { 163 => 0x403 },
	'toningeffect' => { 18 => 0xf, 112 => 0xb3, 114 => 0x38 },
	'toningeffectmonochrome' => { 7 => 0x108 },
	'toningsaturation' => { 114 => 0x39 },
	'totalzoom' => { 66 => 0x62 },
	'tracknumber' => { 194 => 'trackNumber' },
	'trailersignature' => { 85 => 'zmie' },
	'transferfunction' => { 191 => 'TransferFunction' },
	'transmissionreference' => { 189 => 'TransmissionReference' },
	'trapped' => { 188 => 'Trapped' },
	'travelday' => { 150 => 0x36 },
	'ttl_da_adown' => { 159 => 0x5 },
	'ttl_da_aup' => { 159 => 0x4 },
	'ttl_da_bdown' => { 159 => 0x7 },
	'ttl_da_bup' => { 159 => 0x6 },
	'tvexposuretimesetting' => { 156 => 0x12 },
	'type' => { 184 => 'type' },
	'uniquecameramodel' => { 54 => 0xc614 },
	'uniquedocumentid' => { 60 => 0xbb },
	'uniqueobjectname' => { 61 => 0x64 },
	'unknownblock' => { 140 => 0x1103 },
	'unknowncompensation' => { 175 => 0xc },
	'unknownev' => { 65 => 0x1 },
	'unknownnumber' => { 44 => 0x180b },
	'unsharp1color' => { 134 => 0x13 },
	'unsharp1halowidth' => { 134 => 0x19 },
	'unsharp1intensity' => { 134 => 0x17 },
	'unsharp1threshold' => { 134 => 0x1b },
	'unsharp2color' => { 134 => 0x2e },
	'unsharp2halowidth' => { 134 => 0x34 },
	'unsharp2intensity' => { 134 => 0x32 },
	'unsharp2threshold' => { 134 => 0x36 },
	'unsharp3color' => { 134 => 0x49 },
	'unsharp3halowidth' => { 134 => 0x4f },
	'unsharp3intensity' => { 134 => 0x4d },
	'unsharp3threshold' => { 134 => 0x51 },
	'unsharp4color' => { 134 => 0x64 },
	'unsharp4halowidth' => { 134 => 0x6a },
	'unsharp4intensity' => { 134 => 0x68 },
	'unsharp4threshold' => { 134 => 0x6c },
	'unsharpcount' => { 134 => 0x0 },
	'unsharpmask' => { 130 => 0x76a43200 },
	'urgency' => { 60 => 0xa, 189 => 'Urgency' },
	'url' => { 78 => 'URL', 147 => 'URL', 169 => 0x40b },
	'usablemeteringmodes' => { 31 => 0x10a },
	'usableshootingmodes' => { 31 => 0x109 },
	'usageterms' => { 197 => 'UsageTerms' },
	'usercomment' => { 44 => 0x805, 54 => 0x9286, 186 => 'UserComment' },
	'userdef1picturestyle' => { 7 => 0x10c },
	'userdef2picturestyle' => { 7 => 0x10e },
	'userdef3picturestyle' => { 7 => 0x110 },
	'userfields' => { 179 => 'UserFields' },
	'userprofile' => { 148 => 0x302 },
	'usmlenselectronicmf' => { 30 => 0x7, 31 => 0x501 },
	'utmeasting' => { 89 => 'Easting' },
	'utmmapdatum' => { 89 => 'Datum' },
	'utmnorthing' => { 89 => 'Northing' },
	'utmzone' => { 89 => 'Zone' },
	'uv-irfiltercorrection' => { 148 => 0x325 },
	'validbits' => { 140 => 0x611, 141 => 0x102c },
	'validpixeldepth' => { 144 => 0x611 },
	'variousmodes' => { 66 => 0x26 },
	'variousmodes2' => { 66 => 0x3a },
	'variprogram' => { 112 => 0xab },
	'version' => { 58 => 0x0, 171 => 'Version', 183 => 'Version' },
	'versionid' => { 195 => 'VersionID' },
	'versionscomments' => { 195 => 'VersionsComments' },
	'versionseventaction' => { 195 => 'VersionsEventAction' },
	'versionseventinstanceid' => { 195 => 'VersionsEventInstanceID' },
	'versionseventparameters' => { 195 => 'VersionsEventParameters' },
	'versionseventsoftwareagent' => { 195 => 'VersionsEventSoftwareAgent' },
	'versionseventwhen' => { 195 => 'VersionsEventWhen' },
	'versionsmodifier' => { 195 => 'VersionsModifier' },
	'versionsmodifydate' => { 195 => 'VersionsModifyDate' },
	'versionsversion' => { 195 => 'VersionsVersion' },
	'vibrance' => { 183 => 'Vibrance' },
	'vibrationreduction' => { 118 => [0x75,0x82,0x1ae], 120 => '586.1', 121 => '590.2', 123 => 0x4 },
	'videoalphamode' => { 194 => 'videoAlphaMode' },
	'videoalphapremultiplecolora' => { 194 => 'videoAlphaPremultipleColorA' },
	'videoalphapremultiplecolorb' => { 194 => 'videoAlphaPremultipleColorB' },
	'videoalphapremultiplecolorblack' => { 194 => 'videoAlphaPremultipleColorBlack' },
	'videoalphapremultiplecolorblue' => { 194 => 'videoAlphaPremultipleColorBlue' },
	'videoalphapremultiplecolorcyan' => { 194 => 'videoAlphaPremultipleColorCyan' },
	'videoalphapremultiplecolorgreen' => { 194 => 'videoAlphaPremultipleColorGreen' },
	'videoalphapremultiplecolorl' => { 194 => 'videoAlphaPremultipleColorL' },
	'videoalphapremultiplecolormagenta' => { 194 => 'videoAlphaPremultipleColorMagenta' },
	'videoalphapremultiplecolormode' => { 194 => 'videoAlphaPremultipleColorMode' },
	'videoalphapremultiplecolorred' => { 194 => 'videoAlphaPremultipleColorRed' },
	'videoalphapremultiplecolorswatchname' => { 194 => 'videoAlphaPremultipleColorSwatchName' },
	'videoalphapremultiplecolortype' => { 194 => 'videoAlphaPremultipleColorType' },
	'videoalphapremultiplecoloryellow' => { 194 => 'videoAlphaPremultipleColorYellow' },
	'videoalphaunityistransparent' => { 194 => 'videoAlphaUnityIsTransparent' },
	'videocolorspace' => { 194 => 'videoColorSpace' },
	'videocompressor' => { 194 => 'videoCompressor' },
	'videofieldorder' => { 194 => 'videoFieldOrder' },
	'videoframerate' => { 194 => 'videoFrameRate' },
	'videoframesizeh' => { 194 => 'videoFrameSizeH' },
	'videoframesizeunit' => { 194 => 'videoFrameSizeUnit' },
	'videoframesizew' => { 194 => 'videoFrameSizeW' },
	'videomoddate' => { 194 => 'videoModDate' },
	'videopixelaspectratio' => { 194 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 194 => 'videoPixelDepth' },
	'viewfinderwarning' => { 119 => '803.4', 121 => '754.2' },
	'viewinfoduringexposure' => { 31 => 0x407 },
	'vignetteamount' => { 183 => 'VignetteAmount' },
	'vignettecontrol' => { 112 => 0x2a, 130 => 0x76a43205 },
	'vignettecontrolintensity' => { 130 => 0xac6bd5c0 },
	'vignettemidpoint' => { 183 => 'VignetteMidpoint' },
	'voicememo' => { 174 => 0x216 },
	'vr_0x66' => { 118 => 0x66 },
	'vrdoffset' => { 21 => 0xd0 },
	'wb_glevel' => { 140 => 0x11f },
	'wb_glevel3000k' => { 140 => 0x113 },
	'wb_glevel3300k' => { 140 => 0x114 },
	'wb_glevel3600k' => { 140 => 0x115 },
	'wb_glevel3900k' => { 140 => 0x116 },
	'wb_glevel4000k' => { 140 => 0x117 },
	'wb_glevel4300k' => { 140 => 0x118 },
	'wb_glevel4500k' => { 140 => 0x119 },
	'wb_glevel4800k' => { 140 => 0x11a },
	'wb_glevel5300k' => { 140 => 0x11b },
	'wb_glevel6000k' => { 140 => 0x11c },
	'wb_glevel6600k' => { 140 => 0x11d },
	'wb_glevel7500k' => { 140 => 0x11e },
	'wb_grbglevels' => { 104 => 0x0 },
	'wb_rbgglevels' => { 101 => 0x0 },
	'wb_rblevels' => { 140 => 0x100 },
	'wb_rblevels3000k' => { 140 => 0x102 },
	'wb_rblevels3300k' => { 140 => 0x103 },
	'wb_rblevels3600k' => { 140 => 0x104 },
	'wb_rblevels3900k' => { 140 => 0x105 },
	'wb_rblevels4000k' => { 140 => 0x106 },
	'wb_rblevels4300k' => { 140 => 0x107 },
	'wb_rblevels4500k' => { 140 => 0x108 },
	'wb_rblevels4800k' => { 140 => 0x109 },
	'wb_rblevels5300k' => { 140 => 0x10a },
	'wb_rblevels6000k' => { 140 => 0x10b },
	'wb_rblevels6600k' => { 140 => 0x10c },
	'wb_rblevels7500k' => { 140 => 0x10d },
	'wb_rblevelsauto' => { 144 => 0x110 },
	'wb_rblevelscloudy' => { 144 => 0x121 },
	'wb_rblevelscoolwhitefluor' => { 144 => 0x132 },
	'wb_rblevelscwb1' => { 140 => 0x10e },
	'wb_rblevelscwb2' => { 140 => 0x10f },
	'wb_rblevelscwb3' => { 140 => 0x110 },
	'wb_rblevelscwb4' => { 140 => 0x111 },
	'wb_rblevelsdaylightfluor' => { 144 => 0x130 },
	'wb_rblevelsdaywhitefluor' => { 144 => 0x131 },
	'wb_rblevelseveningsunlight' => { 144 => 0x124 },
	'wb_rblevelsfineweather' => { 144 => 0x122 },
	'wb_rblevelsshade' => { 144 => 0x120 },
	'wb_rblevelstungsten' => { 144 => 0x123 },
	'wb_rblevelsused' => { 144 => 0x100 },
	'wb_rblevelswhitefluorescent' => { 144 => 0x133 },
	'wb_rgbglevels' => { 103 => 0x0 },
	'wb_rgblevels' => { 149 => 0xd },
	'wb_rggblevels' => { 102 => 0x0 },
	'wb_rggblevelsasshot' => { 11 => 0x19, 12 => 0x18, 13 => 0x3f, 14 => 0x3f },
	'wb_rggblevelsauto' => { 10 => 0x0, 11 => 0x1e, 12 => 0x22, 13 => 0x44, 14 => 0x44 },
	'wb_rggblevelscloudy' => { 10 => 0xc, 11 => 0x2d, 12 => 0x31, 13 => 0x58, 14 => 0x5d, 163 => 0x20f },
	'wb_rggblevelscustom' => { 10 => 0x1c, 13 => 0x80 },
	'wb_rggblevelscustom1' => { 11 => 0x41 },
	'wb_rggblevelscustom2' => { 11 => 0x46 },
	'wb_rggblevelsdaylight' => { 10 => 0x4, 11 => 0x23, 12 => 0x27, 13 => 0x4e, 14 => 0x53, 163 => 0x20d },
	'wb_rggblevelsflash' => { 10 => 0x18, 11 => 0x3c, 12 => 0x45, 13 => 0x6c, 14 => 0x71, 163 => 0x214 },
	'wb_rggblevelsfluorescent' => { 10 => 0x14, 11 => 0x37, 12 => 0x3b, 13 => 0x62, 14 => 0x67 },
	'wb_rggblevelsfluorescentd' => { 163 => 0x211 },
	'wb_rggblevelsfluorescentn' => { 163 => 0x212 },
	'wb_rggblevelsfluorescentw' => { 163 => 0x213 },
	'wb_rggblevelskelvin' => { 10 => 0x20, 12 => 0x40, 13 => 0x67, 14 => 0x6c },
	'wb_rggblevelsmeasured' => { 13 => 0x49, 14 => 0x49 },
	'wb_rggblevelspc1' => { 12 => 0x90, 13 => 0x71 },
	'wb_rggblevelspc2' => { 12 => 0x95, 13 => 0x76 },
	'wb_rggblevelspc3' => { 12 => 0x9a, 13 => 0x7b },
	'wb_rggblevelsshade' => { 10 => 0x8, 11 => 0x28, 12 => 0x2c, 13 => 0x53, 14 => 0x58, 163 => 0x20e },
	'wb_rggblevelstungsten' => { 10 => 0x10, 11 => 0x32, 12 => 0x36, 13 => 0x5d, 14 => 0x62, 163 => 0x210 },
	'wb_rggblevelsunknown' => { 12 => 0x1d },
	'wb_rggblevelsunknown10' => { 12 => 0x72, 14 => 0x9e },
	'wb_rggblevelsunknown11' => { 12 => 0x77, 14 => 0xa3 },
	'wb_rggblevelsunknown12' => { 12 => 0x7c },
	'wb_rggblevelsunknown13' => { 12 => 0x81 },
	'wb_rggblevelsunknown14' => { 12 => 0x86 },
	'wb_rggblevelsunknown15' => { 12 => 0x8b },
	'wb_rggblevelsunknown16' => { 12 => 0x9f },
	'wb_rggblevelsunknown2' => { 12 => 0x4a, 14 => 0x76 },
	'wb_rggblevelsunknown3' => { 12 => 0x4f, 14 => 0x7b },
	'wb_rggblevelsunknown4' => { 12 => 0x54, 14 => 0x80 },
	'wb_rggblevelsunknown5' => { 12 => 0x59, 14 => 0x85 },
	'wb_rggblevelsunknown6' => { 12 => 0x5e, 14 => 0x8a },
	'wb_rggblevelsunknown7' => { 12 => 0x63, 14 => 0x8f },
	'wb_rggblevelsunknown8' => { 12 => 0x68, 14 => 0x94 },
	'wb_rggblevelsunknown9' => { 12 => 0x6d, 14 => 0x99 },
	'wbadjbluebalance' => { 135 => 0x8 },
	'wbadjcolortemp' => { 48 => 0x1a },
	'wbadjlighting' => { 135 => 0x15 },
	'wbadjmode' => { 135 => 0x10 },
	'wbadjredbalance' => { 135 => 0x0 },
	'wbadjrgblevels' => { 48 => 0x8 },
	'wbadjtemperature' => { 135 => 0x18 },
	'wbadjustab' => { 150 => 0x46 },
	'wbadjustgm' => { 150 => 0x47 },
	'wbbluelevel' => { 148 => 0x324, 150 => 0x8006, 151 => 0x26 },
	'wbbracketmode' => { 18 => 0x9 },
	'wbbracketvalueab' => { 18 => 0xc },
	'wbbracketvaluegm' => { 18 => 0xd },
	'wbfinetuneactive' => { 48 => 0x24 },
	'wbfinetunesaturation' => { 48 => 0x28 },
	'wbfinetunetone' => { 48 => 0x2c },
	'wbgreenlevel' => { 148 => 0x323, 150 => 0x8005, 151 => 0x25 },
	'wblevels' => { 98 => 0x4 },
	'wbmediaimagesizesetting' => { 31 => 0x708 },
	'wbmode' => { 97 => 0x4, 141 => 0x1015 },
	'wbredlevel' => { 148 => 0x322, 150 => 0x8004, 151 => 0x24 },
	'wbscale' => { 98 => 0x0 },
	'wbshiftab' => { 26 => 0xc, 157 => 0x10 },
	'wbshiftgm' => { 26 => 0xd },
	'wbshiftmg' => { 157 => 0x11 },
	'webstatement' => { 197 => 'WebStatement' },
	'whitebalance' => { 1 => [0x44,0x4a], 2 => 0x36, 3 => 0x5e, 4 => 0x36, 5 => 0x6f, 6 => 0x6f, 7 => 0x54, 26 => 0x8, 28 => 0x7, 50 => 0x7, 51 => [0x19,0x2012], 54 => [0xa403,0xfe4e], 58 => 0x1002, 66 => 0x40, 91 => 0x3, 92 => 0xe, 93 => 0x4, 94 => 0xb, 112 => 0x5, 122 => 0x7, 148 => 0x304, 150 => 0x3, 163 => 0x19, 165 => 0x7, 172 => 0x26, 175 => [0x3c,0x7], 183 => 'WhiteBalance', 186 => 'WhiteBalance' },
	'whitebalance2' => { 136 => 0x500 },
	'whitebalanceadj' => { 48 => 0x18, 130 => 0x76a43204 },
	'whitebalancebias' => { 51 => 0x2011, 141 => 0x304, 150 => 0x23 },
	'whitebalanceblue' => { 26 => 0x7 },
	'whitebalancebracket' => { 136 => 0x502, 141 => 0x303 },
	'whitebalancecomp' => { 144 => 0x1001 },
	'whitebalancefinetune' => { 58 => 0x100a, 112 => 0xb },
	'whitebalancemode' => { 163 => 0x1a },
	'whitebalancered' => { 26 => 0x6 },
	'whitebalanceset' => { 156 => 0xa },
	'whitebalancetemperature' => { 136 => 0x501 },
	'whiteboard' => { 141 => 0x301 },
	'whitelevel' => { 54 => 0xc61d },
	'whitepoint' => { 54 => 0x13e, 163 => 0x201, 191 => 'WhitePoint' },
	'widefocuszone' => { 91 => 0x2f },
	'widerange' => { 174 => 0x20f },
	'workcolorspace' => { 48 => 0x270 },
	'worldtimelocation' => { 150 => 0x3a, 163 => 0x22 },
	'writer-editor' => { 60 => 0x7a },
	'x3filllight' => { 175 => 0x12 },
	'xmp' => { 55 => 'XMP' },
	'xpauthor' => { 54 => 0x9c9d },
	'xpcomment' => { 54 => 0x9c9c },
	'xpkeywords' => { 54 => 0x9c9e },
	'xposition' => { 54 => 0x11e },
	'xpsubject' => { 54 => 0x9c9f },
	'xptitle' => { 54 => 0x9c9b },
	'xresolution' => { 54 => 0x11a, 63 => 0x3, 170 => 0x0, 191 => 'XResolution' },
	'xyresolution' => { 57 => 0x3 },
	'ycbcrcoefficients' => { 54 => 0x211, 191 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 54 => 0x213, 191 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 54 => 0x212, 191 => 'YCbCrSubSampling' },
	'yearcreated' => { 66 => 0x10, 73 => 0xc },
	'yposition' => { 54 => 0x11f },
	'yresolution' => { 54 => 0x11b, 63 => 0x5, 170 => 0x4, 191 => 'YResolution' },
	'zonematching' => { 95 => 0x10a, 97 => 0x3a, 176 => 0xb024 },
	'zonematchingon' => { 93 => 0x75 },
	'zoomsourcewidth' => { 9 => 0x24 },
	'zoomstepcount' => { 139 => 0x300, 141 => 0x100d },
	'zoomtargetwidth' => { 9 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_stream' => 1,
	'abstract' => 1,
	'actualcompensation' => 1,
	'adobe' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobemrw' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'aeinfo' => 1,
	'afarea' => 1,
	'afareaheight' => 1,
	'afareaheights' => 1,
	'afareawidth' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'afimageheight' => 1,
	'afimagewidth' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afpointsinfocus1d' => 1,
	'afpointsselected' => 1,
	'albumartist' => 1,
	'albumcoverurl' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'aliaslayermetadata' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatespotcolors' => 1,
	'analogbalance' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'applestoreid' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'aspectratio' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'association' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'audiences' => 1,
	'audiobitrate' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiochannels' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecname' => 1,
	'audiodelay' => 1,
	'audioencoding' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audiolayer' => 1,
	'audiomode' => 1,
	'audiosamplebits' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiovendorid' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorurl' => 1,
	'aux' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'badfaxlines' => 1,
	'balance' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'batteryinfo' => 1,
	'batterylevel' => 1,
	'beatsperminute' => 1,
	'binaryfilter' => 1,
	'bitrate' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperrunlength' => 1,
	'blackleveldeltah' => 1,
	'blackleveldeltav' => 1,
	'blacklevelrepeatdim' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blocksperframe' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'bufferaverage' => 1,
	'burstshot' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calibrationdatetime' => 1,
	'camera' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameracalibration1' => 1,
	'cameracalibration2' => 1,
	'cameradatetime' => 1,
	'camerainfo' => 1,
	'cameramodel' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'cameraowner' => 1,
	'cameraprofileversion' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasetup' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canseektoend' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioqvmi' => 1,
	'cc' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfapattern2' => 1,
	'cfaplanecolor' => 1,
	'cfarepeatpatterndim' => 1,
	'channelmode' => 1,
	'charcount' => 1,
	'charcountwithspaces' => 1,
	'charset' => 1,
	'chartarget' => 1,
	'chromaticadaptation' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'ciff' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanfaxdata' => 1,
	'clipboundary' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codingmethods' => 1,
	'color' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance2' => 1,
	'colorbalance3' => 1,
	'colorbalance4' => 1,
	'colorbalanceunknown' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcomponents' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colormatrix1' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecification' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'company' => 1,
	'compatibility' => 1,
	'compilation' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compressed' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedtext' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'cont' => 1,
	'containerformat' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contenttype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastcurve' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'cpuversions' => 1,
	'crdinfo' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'cropdata' => 1,
	'cropped' => 1,
	'cross-reference' => 1,
	'crs' => 1,
	'cuepoint' => 1,
	'currentbitrate' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'data' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'dc' => 1,
	'dcmd' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'depth' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicesettingdescription' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'director' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'distribution' => 1,
	'dngadobedata' => 1,
	'dngpentaxdata' => 1,
	'dngprivatedata' => 1,
	'docclass' => 1,
	'docrights' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'ducky' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustremovaldata' => 1,
	'dvdid' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'edittagarray' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedusing' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingprocess' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encryption' => 1,
	'endpoints' => 1,
	'episodeglobaluniqueid' => 1,
	'eppim' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipment2' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif' => 1,
	'exif_profile' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposureadjust' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'extcache' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedstreamprops' => 1,
	'extenderstatus' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extrasamples' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileowner' => 1,
	'fileproperties' => 1,
	'filerul' => 1,
	'files' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filetype' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filtering' => 1,
	'finalframeblocks' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'flags' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashon' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'focallength35efl' => 1,
	'focusinfo' => 1,
	'focusinfo2' => 1,
	'focuspos' => 1,
	'footnotes' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'fotostation' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fov' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'framecount' => 1,
	'framepriority' => 1,
	'framerate' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'frametype' => 1,
	'free' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'fujifilm' => 1,
	'fujilayout' => 1,
	'gain' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'generator' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geotiffasciiparams' => 1,
	'geotiffdirectory' => 1,
	'geotiffdoubleparams' => 1,
	'geotiffversion' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'gps' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasaudio' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hcusage' => 1,
	'hdrl' => 1,
	'header' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintsampledesc' => 1,
	'http-equiv' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'identification' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'image' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedepth' => 1,
	'imagefields' => 1,
	'imageformat' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imageoffset' => 1,
	'imageprintstatus' => 1,
	'imageprocessing2' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'index' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'infolist' => 1,
	'information' => 1,
	'initialkey' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputprofile' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'iptc' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isoinfo' => 1,
	'isospeed' => 1,
	'isrc' => 1,
	'isrcnumber' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'itch' => 1,
	'item' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keys' => 1,
	'keyword' => 1,
	'kids' => 1,
	'kodak' => 1,
	'kodakbordersifd' => 1,
	'kodakeffectsifd' => 1,
	'kodakifd' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'languagelist' => 1,
	'lastkeyframetime' => 1,
	'lastmodifier' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lastsavedby' => 1,
	'lasttimestamp' => 1,
	'layercomps' => 1,
	'layersgroupinfo' => 1,
	'layerstateinfo' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensfocalrange' => 1,
	'lensshading' => 1,
	'lensspec' => 1,
	'libraryid' => 1,
	'lightness' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationtable' => 1,
	'lines' => 1,
	'linksuptodate' => 1,
	'lit' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics' => 1,
	'lyrics_synchronised' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'makeandmodel' => 1,
	'makernotes' => 1,
	'mandatorybackground' => 1,
	'marker' => 1,
	'markerid' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxval' => 1,
	'mcdi' => 1,
	'mdat' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementobserver' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacreatedate' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'medialanguagecode' => 1,
	'mediamodifydate' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'mie' => 1,
	'mimetype' => 1,
	'minimumbitrate' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsa100' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minpacketsize' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'modeextension' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'montage' => 1,
	'mood' => 1,
	'mosaicpattern' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'movieheader' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mrwinfo' => 1,
	'msstereo' => 1,
	'multiexposure' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiquality' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncapturedata' => 1,
	'nikoncaptureoffsets' => 1,
	'nikonpreview' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nomssmarttags' => 1,
	'notes' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofinks' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'objecttype' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'offsetorigin' => 1,
	'offsetxy' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2200' => 1,
	'olympus2300' => 1,
	'olympus2400' => 1,
	'olympus2500' => 1,
	'olympus2600' => 1,
	'olympus2700' => 1,
	'olympus2800' => 1,
	'olympus2900' => 1,
	'olympusjunk' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'opacity' => 1,
	'opcolor' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optimalbitrate' => 1,
	'opto-electricconvfactor' => 1,
	'orderingrestrictions' => 1,
	'organization' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'otherformat' => 1,
	'otherimage' => 1,
	'otherimagelength' => 1,
	'otherimagestart' => 1,
	'otherinfo' => 1,
	'othersampledesc' => 1,
	'outputdataobjectlist' => 1,
	'outputprofile' => 1,
	'outputresponse' => 1,
	'packets' => 1,
	'page' => 1,
	'pagecount' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagenormal' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'palette' => 1,
	'palettehistogram' => 1,
	'panasonic' => 1,
	'paragraphs' => 1,
	'parameter' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'partialpalette' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'patternangle' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'peakbitrate' => 1,
	'peakvalue' => 1,
	'pentax' => 1,
	'pentaxtags' => 1,
	'performer' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'period' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'photoeffectsdata' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshopbgrthumbnail' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopsettings' => 1,
	'photoshopthumbnail' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturecontrol' => 1,
	'picturecontrolversion' => 1,
	'pictureinfo' => 1,
	'pieceinfo' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixelsperunitx' => 1,
	'pixelsperunity' => 1,
	'pixelunits' => 1,
	'places' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playselection' => 1,
	'plus' => 1,
	'podcast' => 1,
	'podcasturl' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'pragma' => 1,
	'preferredrate' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewdate' => 1,
	'previewdescription' => 1,
	'previewduration' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewmimetype' => 1,
	'previewpict' => 1,
	'previewtime' => 1,
	'previewtype' => 1,
	'previewversion' => 1,
	'primaryafpoint' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'private' => 1,
	'proccessinginfo' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'product' => 1,
	'profile' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profilesequencedesc' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'ps2crdvmsize' => 1,
	'ps2renteringintent' => 1,
	'pstringcaption' => 1,
	'publisherurl' => 1,
	'purchasedate' => 1,
	'quickmaskinfo' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rasterpadding' => 1,
	'rawdata' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2_2' => 1,
	'rawdevelopment' => 1,
	'rawdevelopment2' => 1,
	'rawimagefullsize' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawinfo' => 1,
	'rawinfo2' => 1,
	'rawjpginfo' => 1,
	'readerrequirements' => 1,
	'recengineer' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redeyedata' => 1,
	'redeyereduction' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'reductionmatrix1' => 1,
	'reductionmatrix2' => 1,
	'redx' => 1,
	'redy' => 1,
	'refresh' => 1,
	'relatedimagefile' => 1,
	'renderingintent' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'requirements' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohdatetime1' => 1,
	'ricohdatetime2' => 1,
	'ricohjunk' => 1,
	'ricohrdc2' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'rowinterleavefactor' => 1,
	'sampleformat' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'sampletable' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scandate' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerserialnumber' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'scriptcommand' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'sensorbottomborder' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorrightborder' => 1,
	'sensortopborder' => 1,
	'serialinfo' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'shadowendpoints' => 1,
	'shakereductioninfo' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300' => 1,
	'shotinfod40' => 1,
	'shotinfod80' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'significantbits' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'softedit' => 1,
	'softwarerelease' => 1,
	'sony' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimagevolumename' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spatialfrequencyresponse' => 1,
	'spatialorientation' => 1,
	'specialeffectsopticalfilter' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'spothalftone' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srf2_key' => 1,
	'srgbrendering' => 1,
	'stamptoolcount' => 1,
	'startofframe' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitrateprops' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'stridable' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subsecdatetimeoriginal' => 1,
	'subtileblocksize' => 1,
	'subtitle' => 1,
	'subtitledescription' => 1,
	'suggestedpalette' => 1,
	'summaryinfo' => 1,
	'supermacro' => 1,
	'svgversion' => 1,
	't4options' => 1,
	't6options' => 1,
	'taggingtime' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'technician' => 1,
	'technology' => 1,
	'template' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textinfo' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'things' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeoffset' => 1,
	'timescale' => 1,
	'titlelen' => 1,
	'titleofparts' => 1,
	'titlesortorder' => 1,
	'tocitems' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totaledittime' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'track' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackcreatedate' => 1,
	'trackduration' => 1,
	'trackheader' => 1,
	'trackid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackmodifydate' => 1,
	'trackversion' => 1,
	'trackvolume' => 1,
	'transferrange' => 1,
	'transform' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tvepisode' => 1,
	'tvepisodenumber' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'typeoforiginal' => 1,
	'ucrbg' => 1,
	'uncompressed' => 1,
	'unicodealphanames' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknownblock1' => 1,
	'unknownblock2' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowninfo' => 1,
	'unknownjunk' => 1,
	'unknowntags' => 1,
	'unsharpdata' => 1,
	'unused' => 1,
	'url_list' => 1,
	'urn' => 1,
	'usedextensionnumbers' => 1,
	'useradjsba_rgbshifts' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'userselectgrouptitle' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'utm' => 1,
	'uuid' => 1,
	'uuid-exif' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-unknown' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versioninfo' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecname' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomode' => 1,
	'videoquality' => 1,
	'videosampledesc' => 1,
	'videosize' => 1,
	'videowidth' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'visibleoutputs' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'warning' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'wb_grgblevels' => 1,
	'wbadjdata' => 1,
	'wcsprofiles' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windowtarget' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wordcount' => 1,
	'workflowurl' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'writer' => 1,
	'xclippathunits' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xml' => 1,
	'xmldata' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'ytarget' => 1,
	'zoom' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

# insert any user-defined tags into our tag lookup
if (defined %Image::ExifTool::UserDefined) {
    my ($table, %tableNum, $tagID);
    my $tnum = 0; # make hash lookup to get table numbers
    foreach $table (@tableList) {
        $tableNum{$table} = $tnum++;
    }
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        $tnum = $tableNum{$table};
        unless ($tnum) {
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $userTable = $Image::ExifTool::UserDefined{$table};
        foreach $tagID (Image::ExifTool::TagTableKeys($userTable)) {
            my $newInfo = $$userTable{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = ucfirst($tagID);
            } else {
                $newInfo = $$userTable{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc($$newInfo{Name});
            # add to lookup even though we don't know it is writable
            # (to save speed by not having to load the module)
            my $lookup = $tagLookup{$lcTag};
            $lookup or $lookup = $tagLookup{$lcTag} = { };
            if ($$lookup{$tnum}) {
                my $le = $$lookup{$tnum};
                my @ids = (ref $le eq 'ARRAY') ? @{$le} : ( $le );
                # only add new tag ID if it didn't already exist
                next if grep /^$tagID$/, @ids;
                push @ids, $tagID;
                $$lookup{$tnum} = \@ids;
            } else {
                $$lookup{$tnum} = $tagID;
            }
            # add any new subdirectory tables
            next unless $$newInfo{SubDirectory};
            my $subTable = $newInfo->{SubDirectory}->{TagTable};
            next unless $subTable and not defined $tableNum{$subTable};
            next if $Image::ExifTool::UserDefined{$subTable};
            no strict 'refs';
            next unless defined %$subTable;
            $Image::ExifTool::UserDefined{$subTable} = \%$subTable;
            push @userTables, $subTable;
            # save parent table name so we can load it when necessary
            $$subTable{PARENT} = $table;
        }
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList);
    my $lookup = $tagLookup{$lcTag};
    if ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $tagID = $$lookup{$tableNum};
            my @tagIDs;
            if (ref $tagID eq 'ARRAY') {
                @tagIDs = @$tagID;
            } else {
                push @tagIDs, $tagID;
            }
            foreach $tagID (@tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2008, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
