/*
   FALCON - The Falcon Programming Language.
   FILE: config.h

   This file is partially generated before compile time
   by the configuration process, or manually finetuned.
   -------------------------------------------------------------------
   Author: Giancarlo Niccolai
   Begin: gio giu 7 2007

   -------------------------------------------------------------------
   (C) Copyright 2004: the FALCON developers (see list in AUTHORS file)

   See LICENSE file for licensing details.
*/

/** \file
   Falcon compile time configuration file.
   This file is partially generated before compile time by the configuration process,
   or manually finetuned.
*/

#ifndef FLC_CONFIG_H
#define FLC_CONFIG_H

//============================================
// Version informations
//
#define FALCON_VERSION_NUM          ( 0 <<16 | 8 <<8 | 14 )
#define FALCON_VERSION              "0.8.14.0"
#define FALCON_VERSION_NAME         "Vulture"

//============================================
// Version RCINFO
//

#define FALCON_VERSION_RCINFO 	    "0, 8, 14, 0"
#define FALCON_VERSION_RCINFO_N 	    0, 8, 14, 0

//============================================
// System informations
//

// Basic system. May be either
//   - FALCON_SYSTEM_UNIX
//   - FALCON_SYSTEM_WIN
//   - FALCON_SYSTEM_MAC

#define FALCON_SYSTEM_UNIX
/* #undef FALCON_SYSTEM_WIN */
/* #undef FALCON_SYSTEM_MAC */

#define FALCON_HOST_SYSTEM          "UNIX"
#define FALCON_LITTLE_ENDIAN        1

//============================================
// Config informations
//
#ifdef FALCON_SYSTEM_WIN
   #define FALCON_DEFAULT_BIN          "/usr\\bin"
   #define FALCON_DEFAULT_LIB          "/usr\\lib"
   #define FALCON_DEFAULT_CONFIG       "/usr\\etc"
   #define FALCON_DEFAULT_LOAD_PATH    ".;/usr\\bin"
#else
   #define FALCON_DEFAULT_BIN          "/usr/bin"
   #define FALCON_DEFAULT_LIB          "/usr/lib"
   #define FALCON_DEFAULT_CONFIG       "/etc"
   #define FALCON_DEFAULT_LOAD_PATH    ".;/usr/lib/falcon"
#endif

#endif

/* end of config.h */
