/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.impl.xs;

import com.sun.org.apache.xerces.internal.impl.xs.SchemaGrammar;
import com.sun.org.apache.xerces.internal.parsers.DOMParser;
import com.sun.org.apache.xerces.internal.parsers.SAXParser;
import com.sun.org.apache.xerces.internal.xs.XSAnnotation;
import com.sun.org.apache.xerces.internal.xs.XSNamespaceItem;
import java.io.IOException;
import java.io.StringReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSAnnotationImpl
implements XSAnnotation {
    private String fData = null;
    private SchemaGrammar fGrammar = null;

    public XSAnnotationImpl(String string, SchemaGrammar schemaGrammar) {
        this.fData = string;
        this.fGrammar = schemaGrammar;
    }

    public boolean writeAnnotation(Object object, short s) {
        if (s == 1 || s == 3) {
            this.writeToDOM((Node)object, s);
            return true;
        }
        if (s == 2) {
            this.writeToSAX((ContentHandler)object);
            return true;
        }
        return false;
    }

    public String getAnnotationString() {
        return this.fData;
    }

    public short getType() {
        return 12;
    }

    public String getName() {
        return null;
    }

    public String getNamespace() {
        return null;
    }

    public XSNamespaceItem getNamespaceItem() {
        return null;
    }

    private synchronized void writeToSAX(ContentHandler contentHandler) {
        SAXParser sAXParser = this.fGrammar.getSAXParser();
        StringReader stringReader = new StringReader(this.fData);
        InputSource inputSource = new InputSource(stringReader);
        sAXParser.setContentHandler(contentHandler);
        try {
            sAXParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private synchronized void writeToDOM(Node node, short s) {
        Document document = s == 1 ? node.getOwnerDocument() : (Document)node;
        DOMParser dOMParser = this.fGrammar.getDOMParser();
        StringReader stringReader = new StringReader(this.fData);
        InputSource inputSource = new InputSource(stringReader);
        try {
            dOMParser.parse(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Document document2 = dOMParser.getDocument();
        Element element = document2.getDocumentElement();
        Node node2 = document.importNode(element, true);
        node.insertBefore(node2, node.getFirstChild());
    }
}

