/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.message.Attachment;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.util.ReadOnlyPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MessageContextImpl
implements MessageContext {
    private Map<String, Object> fallbackMap = null;
    private Set<String> handlerScopeProps;
    Packet packet;

    void fallback() {
        if (this.fallbackMap == null) {
            this.fallbackMap = new HashMap<String, Object>();
            this.fallbackMap.putAll(this.packet.createMapView());
            this.fallbackMap.putAll(this.packet.invocationProperties);
        }
    }

    public MessageContextImpl(Packet packet) {
        this.packet = packet;
        this.handlerScopeProps = packet.getHandlerScopePropertyNames(false);
    }

    protected void updatePacket() {
        throw new UnsupportedOperationException("wrong call");
    }

    @Override
    public void setScope(String string, MessageContext.Scope scope) {
        if (!this.containsKey(string)) {
            throw new IllegalArgumentException("Property " + string + " does not exist.");
        }
        if (scope == MessageContext.Scope.APPLICATION) {
            this.handlerScopeProps.remove(string);
        } else {
            this.handlerScopeProps.add(string);
        }
    }

    @Override
    public MessageContext.Scope getScope(String string) {
        if (!this.containsKey(string)) {
            throw new IllegalArgumentException("Property " + string + " does not exist.");
        }
        if (this.handlerScopeProps.contains(string)) {
            return MessageContext.Scope.HANDLER;
        }
        return MessageContext.Scope.APPLICATION;
    }

    @Override
    public int size() {
        this.fallback();
        return this.fallbackMap.size();
    }

    @Override
    public boolean isEmpty() {
        this.fallback();
        return this.fallbackMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.fallbackMap == null) {
            if (this.packet.supports(object)) {
                return true;
            }
            return this.packet.invocationProperties.containsKey(object);
        }
        this.fallback();
        return this.fallbackMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        this.fallback();
        return this.fallbackMap.containsValue(object);
    }

    @Override
    public Object put(String string, Object object) {
        if (this.fallbackMap == null) {
            if (this.packet.supports(string)) {
                return this.packet.put(string, object);
            }
            if (!this.packet.invocationProperties.containsKey(string)) {
                this.handlerScopeProps.add(string);
            }
            return this.packet.invocationProperties.put(string, object);
        }
        this.fallback();
        if (!this.fallbackMap.containsKey(string)) {
            this.handlerScopeProps.add(string);
        }
        return this.fallbackMap.put(string, object);
    }

    @Override
    public Object get(Object object) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (this.fallbackMap == null) {
            object2 = this.packet.supports(object) ? this.packet.get(object) : this.packet.invocationProperties.get(object);
        } else {
            this.fallback();
            object2 = this.fallbackMap.get(object);
        }
        if (object.equals("javax.xml.ws.binding.attachments.outbound") || object.equals("javax.xml.ws.binding.attachments.inbound")) {
            HashMap<String, DataHandler> hashMap = (HashMap<String, DataHandler>)object2;
            if (hashMap == null) {
                hashMap = new HashMap<String, DataHandler>();
            }
            AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
            for (Attachment attachment : attachmentSet) {
                hashMap.put(attachment.getContentId(), attachment.asDataHandler());
            }
            return hashMap;
        }
        return object2;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.fallback();
        for (String string : map.keySet()) {
            if (this.fallbackMap.containsKey(string)) continue;
            this.handlerScopeProps.add(string);
        }
        this.fallbackMap.putAll(map);
    }

    @Override
    public void clear() {
        this.fallback();
        this.fallbackMap.clear();
    }

    @Override
    public Object remove(Object object) {
        this.fallback();
        this.handlerScopeProps.remove(object);
        return this.fallbackMap.remove(object);
    }

    @Override
    public Set<String> keySet() {
        this.fallback();
        return this.fallbackMap.keySet();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        this.fallback();
        return this.fallbackMap.entrySet();
    }

    @Override
    public Collection<Object> values() {
        this.fallback();
        return this.fallbackMap.values();
    }

    void fill(Packet packet) {
        if (this.fallbackMap != null) {
            for (Map.Entry<String, Object> entry : this.fallbackMap.entrySet()) {
                String string = entry.getKey();
                if (packet.supports(string)) {
                    try {
                        packet.put(string, entry.getValue());
                    }
                    catch (ReadOnlyPropertyException readOnlyPropertyException) {}
                    continue;
                }
                packet.invocationProperties.put(string, entry.getValue());
            }
            packet.createMapView().keySet().retainAll(this.fallbackMap.keySet());
            packet.invocationProperties.keySet().retainAll(this.fallbackMap.keySet());
        }
    }
}

