/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.AWTException;
import java.awt.BufferCapabilities;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsDevice;
import sun.awt.image.OffScreenImage;
import sun.awt.image.SunVolatileImage;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.RenderLoops;
import sun.java2d.loops.SurfaceType;
import sun.java2d.x11.X11SurfaceData;

public class X11GraphicsConfig
extends GraphicsConfiguration {
    protected X11GraphicsDevice screen;
    protected int visual;
    int depth;
    int colormap;
    ColorModel colorModel;
    long aData;
    boolean doubleBuffer;
    private Object disposerReferent = new Object();
    private BufferCapabilities bufferCaps;
    private static ImageCapabilities imageCaps = new ImageCapabilities(X11SurfaceData.isAccelerationEnabled());
    protected int bitsPerPixel;
    protected SurfaceType surfaceType;
    public RenderLoops solidloops;

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n, int n2, int n3, boolean bl) {
        return new X11GraphicsConfig(x11GraphicsDevice, n, n2, n3, bl);
    }

    public static X11GraphicsConfig getConfig(X11GraphicsDevice x11GraphicsDevice, int n, int n2, int n3, int n4) {
        return new X11GraphicsConfig(x11GraphicsDevice, n, n2, n3, false);
    }

    private native int getNumColors();

    private native void init(int var1, int var2);

    private native ColorModel makeColorModel();

    protected X11GraphicsConfig(X11GraphicsDevice x11GraphicsDevice, int n, int n2, int n3, boolean bl) {
        this.screen = x11GraphicsDevice;
        this.visual = n;
        this.doubleBuffer = bl;
        this.depth = n2;
        this.colormap = n3;
        this.init(n, this.screen.getScreen());
        long l = this.getAData();
        Disposer.addRecord(this.disposerReferent, new X11GCDisposerRecord(l));
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public int getDepth() {
        return this.depth;
    }

    public int getColormap() {
        return this.colormap;
    }

    public int getBitsPerPixel() {
        return this.bitsPerPixel;
    }

    public synchronized SurfaceType getSurfaceType() {
        if (this.surfaceType != null) {
            return this.surfaceType;
        }
        this.surfaceType = X11SurfaceData.getSurfaceType(this, false);
        return this.surfaceType;
    }

    public synchronized RenderLoops getSolidLoops(SurfaceType surfaceType) {
        if (this.solidloops == null) {
            this.solidloops = SurfaceData.makeRenderLoops(SurfaceType.OpaqueColor, CompositeType.SrcNoEa, surfaceType);
        }
        return this.solidloops;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            SystemColor.window.getRGB();
            this.colorModel = this.makeColorModel();
            if (this.colorModel == null) {
                this.colorModel = Toolkit.getDefaultToolkit().getColorModel();
            }
        }
        return this.colorModel;
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution(this.screen.getScreen()) / 72.0;
        double d2 = this.getYResolution(this.screen.getScreen()) / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private native double getXResolution(int var1);

    private native double getYResolution(int var1);

    public long getAData() {
        return this.aData;
    }

    public String toString() {
        return "X11GraphicsConfig[dev=" + this.screen + ",vis=0x" + Integer.toHexString(this.visual) + "]";
    }

    private static native void initIDs();

    public Rectangle getBounds() {
        return this.pGetBounds(this.screen.getScreen());
    }

    public native Rectangle pGetBounds(int var1);

    public BufferCapabilities getBufferCapabilities() {
        if (this.bufferCaps == null) {
            this.bufferCaps = this.doubleBuffer ? new XDBECapabilities() : super.getBufferCapabilities();
        }
        return this.bufferCaps;
    }

    public ImageCapabilities getImageCapabilities() {
        return imageCaps;
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffer;
    }

    private static native void dispose(long var0);

    public SurfaceData createSurfaceData(X11ComponentPeer x11ComponentPeer) {
        return X11SurfaceData.createData(x11ComponentPeer);
    }

    public Image createAcceleratedImage(Component component, int n, int n2) {
        ColorModel colorModel = this.getColorModel(1);
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new OffScreenImage(component, colorModel, writableRaster, colorModel.isAlphaPremultiplied());
    }

    private native long createBackBuffer(long var1, int var3);

    private native void swapBuffers(long var1, int var3);

    public long createBackBuffer(X11ComponentPeer x11ComponentPeer, int n, BufferCapabilities bufferCapabilities) throws AWTException {
        if (!X11GraphicsDevice.isDBESupported()) {
            throw new AWTException("Page flipping is not supported");
        }
        if (n > 2) {
            throw new AWTException("Only double or single buffering is supported");
        }
        BufferCapabilities bufferCapabilities2 = this.getBufferCapabilities();
        if (!bufferCapabilities2.isPageFlipping()) {
            throw new AWTException("Page flipping is not supported");
        }
        long l = x11ComponentPeer.getContentWindow();
        int n2 = X11GraphicsConfig.getSwapAction(bufferCapabilities.getFlipContents());
        return this.createBackBuffer(l, n2);
    }

    public native void destroyBackBuffer(long var1);

    public VolatileImage createBackBufferImage(Component component, long l) {
        return new SunVolatileImage(component, component.getWidth(), component.getHeight(), new Long(l));
    }

    public void flip(X11ComponentPeer x11ComponentPeer, Component component, VolatileImage volatileImage, int n, int n2, int n3, int n4, BufferCapabilities.FlipContents flipContents) {
        long l = x11ComponentPeer.getContentWindow();
        int n5 = X11GraphicsConfig.getSwapAction(flipContents);
        this.swapBuffers(l, n5);
    }

    private static int getSwapAction(BufferCapabilities.FlipContents flipContents) {
        if (flipContents == BufferCapabilities.FlipContents.BACKGROUND) {
            return 1;
        }
        if (flipContents == BufferCapabilities.FlipContents.PRIOR) {
            return 2;
        }
        if (flipContents == BufferCapabilities.FlipContents.COPIED) {
            return 3;
        }
        return 0;
    }

    static {
        X11GraphicsConfig.initIDs();
    }

    private static class X11GCDisposerRecord
    implements DisposerRecord {
        private long x11ConfigData;

        public X11GCDisposerRecord(long l) {
            this.x11ConfigData = l;
        }

        public synchronized void dispose() {
            if (this.x11ConfigData != 0L) {
                X11GraphicsConfig.dispose(this.x11ConfigData);
                this.x11ConfigData = 0L;
            }
        }
    }

    private static class XDBECapabilities
    extends BufferCapabilities {
        public XDBECapabilities() {
            super(imageCaps, imageCaps, BufferCapabilities.FlipContents.UNDEFINED);
        }
    }
}

