#!/bin/sh

config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/uniconf.conf.new

echo "/usr/lib/wvstreams" >> /etc/ld.so.conf

/sbin/ldconfig

( cd usr/lib/wvstreams ; rm -rf libwvutils.so )
( cd usr/lib/wvstreams ; ln -sf libwvutils.so.4.4 libwvutils.so )
( cd usr/lib/wvstreams ; rm -rf libuniconf.so )
( cd usr/lib/wvstreams ; ln -sf libuniconf.so.4.4 libuniconf.so )
( cd usr/lib/wvstreams ; rm -rf libwvbase.so )
( cd usr/lib/wvstreams ; ln -sf libwvbase.so.4.4 libwvbase.so )
( cd usr/lib/wvstreams ; rm -rf libwvstreams.so )
( cd usr/lib/wvstreams ; ln -sf libwvstreams.so.4.4 libwvstreams.so )
( cd usr/lib/wvstreams ; rm -rf libwvqt.so )
( cd usr/lib/wvstreams ; ln -sf libwvqt.so.4.4 libwvqt.so )
