/****************************************************************************
** $Id:  cmds/cmds.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#ifndef CMDSHEADER_H
#define CMDSHEADER_H
#include <QTextStream>
#include <QTextEdit>
#include <QVBoxLayout>
#include <QString>
#include <math.h>
#include <QVector>
#include <QImage>
#include <QPalette>
#include <QScrollBar>
#include <QMultiHash>
#include <QTableWidget>
#include <QSizePolicy>


#include "../extra/mousedefines.h"
#include "../dialogs/properdiag.h"
#include "../extra/primitives.h"
#include "../extra/matrixa.h"

#define UNDOLIMIT 		10

#define CMDDRAWLINE 		1
#define CMDDRAWTRIANGLE		2
#define CMDCANCEL		3
#define CMDSCANCEL		4
#define CMDZOOM 		5
#define CMDPAN			6
#define CMDROTATEVIEW		7
#define CMDGRIPONLYMOVE		8
#define CMDGRIPONLYSCALE	9
#define CMDGRIPONLYMIRROR	10
#define CMDGRIPONLYSTRETCH	11
#define CMDGRIPONLYROTATE	12
#define CMDQUICKERASE		13
#define CMDSHOWPROPERTIES	14
#define CMDROTATE3D		15
#define CMDEXTRUDE		16
#define CMDARRAY		17
#define CMDMEANNORMALS		18
#define CMDSLICE		19
#define CMDCUBE			20
#define CMDDIST			21
#define CMDSWITCH		22
#define CMDTRINORMALS		23
#define CMDSNAP			24
#define CMDREVOLVE		25
#define CMDDRAWPOLY		26
#define CMDGRIPPOINTCOLOR	27
#define CMDGRIPPOINTTEXTURE	28
#define CMDGRIPPOINTNORMAL	29
#define CMDFLIP			30
#define CMDTEX			31
#define CMDTEXSP		32
#define CMDUNDO			33
#define CMDUCSICON		34
#define SHOWTRIANGLES		35
#define SHOWLINES		36






struct dataformat{
	int format;
	float v[3];
}; 



class QMultiLineEdit;
class ProperDiag;

class cmds: public QTextEdit
{
	Q_OBJECT
public:
	cmds(QWidget* parent=0);
	~cmds();
	foundP rtlines[2];
	foundP currentpoint[1];
	foundP GriPoint[1];
	foundP SnaPoint[1];
	int SnapFlags[1];
	float *currentcolor;
	float rtcolor[3];
	float rtcolor1[3];
	int GripEditMode[1];
	int SnapMode[1];
	QVector<tselect> DataSV;
	QVector<d3line> DataSLV;
	QVector<d3triangle> DataSTV;
	QVector<d3line> UndoDataLV[UNDOLIMIT];
	QVector<d3triangle> UndoDataTV[UNDOLIMIT];
	int undoidx;
	int undocnt;
	float cscalarf[1];
	int cscalari[1];
	QStringList StrTex;
	int *ucsicon;
	int *View;
	


public slots:
	void SendText(QString str);
	void processcmd(QString str);
	void setCmdData(dataformat data);
	void setDataL(QVector<d3line> *Info,QVector<d3triangle> *Infotri,int *eview,int *mousei);


private slots:
	int equal(d3triangle* tri1,int tp1,d3triangle* tri2,int tp2);
	int CmdSelectPopView();
	int CmdCheckSnap();
	void CmdCancel();
	void cmddrawline();
	void cmddrawtriangle();
	void cmdzoom();
	void cmdpan();
	void cmdrotateview();
	void cmdpopzoom();
	void cmdpoppan();
	void cmdpoprotateview();
	void cmdgriponlymove();
	void cmdgriponlyscale();
	void cmdgriponlymirror();
	void cmdgriponlystretch();
	void cmdgriponlyrotate();
	void cmdquickerase();
	void cmdshowproperties();
	void cmdrotate3d();
	void cmdextrude();
	void cmdarray();
	void cmdmeannormals();
	void cmdslice();
	void cmdcube();
	void cmddist();
	void cmdswitch();
	void cmdtrinormals();
	void cmdsnap();
	void cmdrevolve();
	void cmddrawpoly();
	void cmdgrippointcolor();
	void cmdgrippointtexture();
	void cmdgrippointnormal();
	void cmdflip();
	void cmdtex();
	void cmdtexsp();
	void cmdundo();
	void CmdStoreUndo();
	void cmducsicon();
	void cmdshowtriangles();
	void cmdshowlines();


signals:
	void instru(const QString &);
	void SetMouseMode(int);
	void ZoomVar(float var);

private:
	QString instruction;
	QVector<d3line> *DataLV;
	QVector<d3triangle> *DataTV;
	QHash<QString,int> cmdlist;
	int step;
	QString currentcmd;
	QString SecCmd;
	int CommandActive;
	dataformat currentdata;
	float tempdataF[7];
	int tempdataI[3];
	d3triangle tempdataTRI[1];
	int popStats[3];
	int *MouseMode;
	int PopViewMode;
	int PopStep;
	ProperDiag* Props;
	int Array_NItems;
	

};


#endif
