/****************************************************************************
** $Id:  dialogs/helpwindow.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "helpwindow.h"


HelpWindow::HelpWindow( const QString& home_, const QString& path,QWidget* parent)
    : QMainWindow( parent,0)
{

	browser = new QTextBrowser( this );

	browser->setSearchPaths(QStringList()<<path);
	setCentralWidget( browser );

	if ( !home_.isEmpty() )
		browser->setSource( home_ );

	connect( browser, SIGNAL( highlighted( const QString&) ),statusBar(), SLOT( showMessage(const QString&)));

	resize( 640,700 );

	QAction * fileCloseAction;
	fileCloseAction= new QAction(tr("&Close"),this);
	fileCloseAction->setStatusTip(tr("Close file"));
	connect( fileCloseAction, SIGNAL( triggered() ) , this, SLOT( close() ) );

	QMenu *file;
	file = menuBar()->addMenu(tr("&File"));
	file->addAction(fileCloseAction);
	setAttribute(Qt::WA_DeleteOnClose);

	browser->setFocus();

}




HelpWindow::~HelpWindow()
{

}
