/****************************************************************************
** $Id:  extra/matrixa.cpp
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/

#include "matrixa.h"

void MatrixMultd(double *m2,double *m1,double *res){


	res[0]=m1[0]*m2[0]+m1[1]*m2[4]+m1[2]*m2[8]+m1[3]*m2[12];
	res[1]=m1[0]*m2[1]+m1[1]*m2[5]+m1[2]*m2[9]+m1[3]*m2[13];
	res[2]=m1[0]*m2[2]+m1[1]*m2[6]+m1[2]*m2[10]+m1[3]*m2[14];
	res[3]=m1[0]*m2[3]+m1[1]*m2[7]+m1[2]*m2[11]+m1[3]*m2[15];

	res[4]=m1[4]*m2[0]+m1[5]*m2[4]+m1[6]*m2[8]+m1[7]*m2[12];
	res[5]=m1[4]*m2[1]+m1[5]*m2[5]+m1[6]*m2[9]+m1[7]*m2[13];
	res[6]=m1[4]*m2[2]+m1[5]*m2[6]+m1[6]*m2[10]+m1[7]*m2[14];
	res[7]=m1[4]*m2[3]+m1[5]*m2[7]+m1[6]*m2[11]+m1[7]*m2[15];

	res[8]=m1[8]*m2[0]+m1[9]*m2[4]+m1[10]*m2[8]+m1[11]*m2[12];
	res[9]=m1[8]*m2[1]+m1[9]*m2[5]+m1[10]*m2[9]+m1[11]*m2[13];
	res[10]=m1[8]*m2[2]+m1[9]*m2[6]+m1[10]*m2[10]+m1[11]*m2[14];
	res[11]=m1[8]*m2[3]+m1[9]*m2[7]+m1[10]*m2[11]+m1[11]*m2[15];

	res[12]=m1[12]*m2[0]+m1[13]*m2[4]+m1[14]*m2[8]+m1[15]*m2[12];
	res[13]=m1[12]*m2[1]+m1[13]*m2[5]+m1[14]*m2[9]+m1[15]*m2[13];
	res[14]=m1[12]*m2[2]+m1[13]*m2[6]+m1[14]*m2[10]+m1[15]*m2[14];
	res[15]=m1[12]*m2[3]+m1[13]*m2[7]+m1[14]*m2[11]+m1[15]*m2[15];
	
}

void TriNormal(d3triangle *m1){

	float tempdataF[6];
	double var[1];
	
	tempdataF[0]=m1->v2[0]-m1->v1[0];
	tempdataF[1]=m1->v2[1]-m1->v1[1];
	tempdataF[2]=m1->v2[2]-m1->v1[2];
	tempdataF[3]=m1->v3[0]-m1->v1[0];
	tempdataF[4]=m1->v3[1]-m1->v1[1];
	tempdataF[5]=m1->v3[2]-m1->v1[2];
				
	m1->n3[0]=m1->n2[0]=m1->n1[0]=(tempdataF[1]*tempdataF[5]-tempdataF[2]*tempdataF[4]);
	m1->n3[1]=m1->n2[1]=m1->n1[1]=(tempdataF[2]*tempdataF[3]-tempdataF[0]*tempdataF[5]);
	m1->n3[2]=m1->n2[2]=m1->n1[2]=(tempdataF[0]*tempdataF[4]-tempdataF[1]*tempdataF[3]);
	var[0]=sqrt(m1->n1[0]*m1->n1[0]+m1->n1[1]*m1->n1[1]+m1->n1[2]*m1->n1[2]);
	m1->n3[0]/=var[0];m1->n2[0]/=var[0];m1->n1[0]/=var[0];
	m1->n3[1]/=var[0];m1->n2[1]/=var[0];m1->n1[1]/=var[0];
	m1->n3[2]/=var[0];m1->n2[2]/=var[0];m1->n1[2]/=var[0];


}




