/****************************************************************************
** $Id:  fgui/cadformdxf.h
** AutoQ3D a qt 3d model editor program
**
** Copyright (C) 2005-2007 -Gonzalo Reynaga Garcia. <gonzaloreynaga@yahoo.com>
**
** This program is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public Licence
** as published by the Free Software Foundation; either version 2 
** of the License, or (at your option) any later option.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
** 
*****************************************************************************/
#ifndef CADFORM_DXF_H
#define CADFORM_DXF_H
#include "../cadform.h"

namespace

{

float ACITable[][3]=

  {
	
	{1.0, 1.0, 1.0},
	{1.0, 0.0, 0.0},
	{1.0, 1.0, 0.0},
	{0.0, 1.0, 0.0},
	{0.0, 1.0, 1.0},
	{0.0, 0.0, 1.0},
	{1.0, 0.0, 1.0},
	{1.0, 1.0, 1.0},
	{0.5, 0.5, 0.5},
	{0.75294, 0.75294, 0.75294},
	{1.0, 0.0, 0.0},
	{1.0, 0.5, 0.5},
	{0.8, 0.0, 0.0},
	{0.8, 0.0, 0.0},
	{0.8, 0.4, 0.4},
	{0.6, 0.298039, 0.298039},
	{0.5, 0.0, 0.0},
	{0.5, 0.247058, 0.247058},
	{0.298039, 0.0, 0.0},
	{0.298039, 0.149019, 0.149019},
	{0.5, 0.247058, 0.0},
	{1.0, 0.623529, 0.5},
	{0.8, 0.2, 0.0},
	{0.8, 0.5, 0.4},
	{0.6, 0.149019, 0.0},
	{0.6, 0.372549, 0.298039},
	{0.5, 0.121568, 0.0},
	{0.5, 0.309803, 0.247058},
	{0.298039, 0.074509, 0.0},
	{0.298039, 0.184313, 0.149014},
	{1.0, 0.5, 0.0},
	{1.0, 0.749019, 0.5},
	{0.8, 0.4, 0.0},
	{0.8, 0.6, 0.4},
	{0.6, 0.298039, 0.0},
	{0.8, 0.6, 0.4},
	{0.6, 0.447058, 0.298039},
	{0.5, 0.372549, 0.247058},
	{0.298039, 0.149019, 0.0},
	{0.298039, 0.223529, 0.149019},
	{1.0, 0.749019, 0.0},
	{1.0, 0.874509, 0.5},
	{0.8, 0.6, 0.0},
	{0.8, 0.698039, 0.4},
	{0.6, 0.447058, 0.0},
	{0.6, 0.521568, 0.298039},
	{0.5, 0.372549, 0.0},
	{0.5, 0.435294, 0.247058},
	{0.298039, 0.223529, 0.0},
	{0.298039, 0.258823, 0.149019},
	{1.0, 1.0, 0.0},
	{1.0, 1.0, 0.5},
	{0.8, 0.8, 0.0},
	{0.8, 0.8, 0.4},
	{0.6, 0.6, 0.0},
	{0.6, 0.6, 0.298039},
	{0.5, 0.5, 0.0},
	{0.5, 0.5, 0.247058},
	{0.298039, 0.298039, 0.0},
	{0.298039, 0.298039, 0.149019},
	{0.749019, 1.0, 0.0},
	{0.874509, 1.0, 0.5},
	{0.6, 0.8, 0.0},
	{0.698039, 0.8, 0.4},
	{0.447058, 0.6, 0.0},
	{0.521568, 0.6, 0.298039},
	{0.372549, 0.5, 0.0},
	{0.435294, 0.5, 0.247058},
	{0.223529,0.298039,0.0},
	{0.258823, 0.298039, 0.149019},
	{0.5,1.0,0.0},
	{0.749019,1.0,0.5},
	{0.4,0.8,0.0},
	{0.6,0.8,0.4},
	{0.298039,0.6,0.0},
	{0.447058,0.6,0.298039},
	{0.247058,0.5,0.0},
	{0.372549,0.5,0.247058},
	{0.149019,0.298039,0.0},
	{0.223529,0.298039,0.149019},
	{0.247058,1.0,0.0},
	{0.623529,1.0,0.5},
	{0.2,0.8,0.0},
	{0.5,0.8,0.4},
	{0.149019,0.623529,0.0},
	{0.372549,0.6,0.298039},
	{0.121568,0.5,0.0},
	{0.309803,0.5,0.247058},
	{0.074509,0.298039,0.0},
	{0.184313,0.298039,0.149019},
	{0.0,1.0,0.0},	
	{0.5,1.0,0.5},
	{0.0,0.8,0.0},
	{0.4,0.8,0.4},
	{0.0,0.6,0.0},
	{0.298039,0.6,0.298039},
	{0.0,0.5,0.0},
	{0.247058,0.5,0.247058},
	{0.0,0.298039,0.0},
	{0.149019,0.298039,0.149019},
	{0.0,1.0,0.247058},
	{0.5,1.0,0.623529},
	{0.0,0.8,0.2},
	{0.4,0.8,0.5},
	{0.0,0.6,0.149019},
	{0.298039,0.6,0.372549},
	{0.0,0.5,0.121568},
	{0.247058,0.5,0.309803},
	{0.0,0.298039,0.074509},
	{0.149019,0.298039,0.184313},
	{0.0,1.0,0.5},
	{0.5,1.0,0.749019},
	{0.0,0.8,0.4},
	{0.4,0.8,0.6},
	{0.0,0.6,0.298039},
	{0.298039,0.6,0.447058},
	{0.0,0.5,0.247058},
	{0.247058,0.5,0.372549},
	{0.0,0.298039,0.149019},
	{0.149019,0.298039,0.223529},
	{0.0,1.0,0.749019},
	{0.5,1.0,0.874509},
	{0.0,0.8,0.6},
	{0.4,0.8,0.698039},
	{0.0,0.6,0.447058},
	{0.298039,0.6,0.521568},
	{0.0,0.5,0.372549},
	{0.247058,0.5,0.435294},
	{0.0,0.298039,0.223529},
	{0.149019,0.298039,0.258823},
	{0.0,1.0,1.0},
	{0.5,1.0,1.0},
	{0.0,0.8,0.8},
	{0.4,0.8,0.8},
	{0.0,0.6,0.6},
	{0.298039,0.6,0.6},
	{0.0,0.5,0.5},
	{0.247058,0.5,0.5},
	{0.0,0.298039,0.298039},
	{0.149019,0.298039,0.298039},
	{0.0,0.749019,1.0},
	{0.5,0.874509,1.0},
	{0.0,0.6,0.8},
	{0.4,0.698039,0.8},
	{0.0,0.447058,0.6},
	{0.298039,0.521568,0.6},
	{0.0,0.372549,0.5},
	{0.247058,0.435294,0.5},
	{0.0,0.223529,0.298039},
	{0.149019,0.258823,0.298039},
	{0.0,0.5,1.0},
	{0.5,0.749019,1.0},
	{0.0,0.4,0.8},
	{0.4,0.6,0.8},
	{0.0,0.298039,0.6},
	{0.298039,0.447058,0.6},
	{0.0,0.247058,0.5},
	{0.247058,0.372549,0.5},
	{0.0,0.149019,0.298039},
	{0.149019,0.223529,0.298039},
	{0.0,0.247058,1.0},
	{0.5,0.623529,1.0},
	{0.0,0.2,0.8},
	{0.4,0.5,0.8},
	{0.0,0.149019,0.6},
	{0.298039,0.372549,0.6},
	{0.0,0.121568,0.5},
	{0.247058,0.309803,0.5},
	{0.0,0.074509,0.298039},
	{0.149019,0.184313,0.298039},
	{0.0,0.0,1.0},
	{0.5,0.5,1.0},
	{0.0,0.0,0.8},
	{0.4,0.4,0.8},
	{0.0,0.0,0.6},
	{0.298039,0.298039,0.6},
	{0.0,0.0,0.5},
	{0.247058,0.247058,0.5},
	{0.0,0.0,0.298039},
	{0.149019,0.149019,0.298039},
	{0.247058,0.0,1.0},
	{0.623529,0.5,1.0},
	{0.2,0.0,0.8},
	{0.5,0.4,0.8},
	{0.149019,0.0,0.6},
	{0.372549,0.298039,0.6},
	{0.121568,0.0,0.5},
	{0.298039,0.247058,0.5},
	{0.074509,0.0,0.298039},
	{0.184313,0.149019,0.298039},
	{0.5,0.0,1.0},
	{0.749019,0.5,1.0},
	{0.4,0.0,0.8},
	{0.6,0.4,0.8},
	{0.298039,0.0,0.6},
	{0.447058,0.298039,0.6},
	{0.247058,0.0,0.5},
	{0.372549,0.247058,0.5},
	{0.149019,0.0,0.298039},
	{0.223529,0.149019,0.298039},
	{0.749019,0.0,1.0},
	{0.874509,0.5,1.0},
	{0.6,0.0,0.8},
	{0.698039,0.4,0.8},
	{0.447058,0.0,0.6},
	{0.521568,0.298039,0.6},
	{0.372549,0.0,0.5},
	{0.435294,0.247058,0.5},
	{0.223529,0.0,0.298039},
	{0.258823,0.149019,0.298039},
	{1.0,0.0,1.0},
	{1.0,0.5,1.0},
	{0.8,0.0,0.8},
	{0.8,0.4,0.8},
	{0.6,0.0,0.6},
	{0.6,0.298039,0.6},
	{0.5,0.0,0.5},
	{0.5,0.247058,0.5},
	{0.298039,0.0,0.298039},
	{0.298039,0.149019,0.298039},
	{1.0,0.0,0.749019},
	{1.0,0.5,0.874509},
	{0.8,0.0,0.6},
	{0.8,0.4,0.698039},
	{0.6,0.0,0.447058},
	{0.6,0.298039,0.521568},
	{0.5,0.0,0.372549},
	{0.5,0.247058,0.435294},
	{0.298039,0.0,0.223529},
	{0.298039,0.149019,0.258823},
	{1.0,0.0,0.5},
	{1.0,0.5,0.749019},
	{0.8,0.0,0.4},
	{0.8,0.4,0.6},
	{0.6,0.0,0.298039},
	{0.6,0.298039,0.447058},
	{0.5,0.0,0.247058},
	{0.5,0.247058,0.372549},
	{0.298039,0.0,0.149019},
	{0.298039,0.149019,0.223529},
	{1.0,0.0,0.247058},
	{1.0,0.5,0.623529},
	{0.8,0.0,0.2},
	{0.8,0.4,0.5},
	{0.6,0.0,0.149019},
	{0.6,0.298039,0.372549},
	{0.5,0.0,0.121568},
	{0.5,0.247058,0.309803},
	{0.298039,0.0,0.074509},
	{0.298039,0.149019,0.184313},
	{0.2,0.2,0.2},
	{0.356862,0.356862,0.356862},
	{0.517647,0.517647,0.517647},
	{0.678431,0.678431,0.678431},
	{0.839215,0.839215,0.839215},
	{1.0,1.0,1.0}
};



}


void CadForm::InsertDXF(){

	int size=0;
	float numf[3];
	float tempf[6];
	double var[0];
	int idxcolor=0;
	int entities=false;
	int aversion;
	int supver=1;
	QString textread;

	QString fn = QFileDialog::getOpenFileName(this,QString(tr("Insert DXF file")),filename,tr("DXF model(*.dxf)") );
	QString tempo;
	if ( !fn.isEmpty() ) {
	
	QFile f( fn );
	
	if ( !f.open( QIODevice::ReadOnly ) ){
		
		QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open failed")),tr("OK") );
		f.close();
	
	}else{
		filename=fn;
		
		QTextStream t(&f);
		while((!t.atEnd())&&supver){
			textread=t.readLine().simplified();
			
			if(!textread.compare("SECTION")){
				t.readLine();
				
				if(!t.readLine().simplified().compare("ENTITIES")){
					entities=true;t.readLine();
				}
			}
			
			if(!textread.compare("$ACADVER")){
				t.readLine();
				sscanf(t.readLine().simplified().toAscii(),"AC%d",&aversion);
				if(aversion==1008||aversion==1009||aversion==1015||aversion==1018){
					supver=1;
				}else{
					supver=0;
					QMessageBox::critical( this,"Error",QString(tr("DXF version not supported")),tr("OK"));
				}
			}
			if(!textread.compare("ENDSEC")){entities=false;t.readLine();}
			
			if(entities){
			
				if(!textread.compare("3DFACE")){
					size=DataTV.size();DataTV.resize(size+1);
					if(aversion==1008){
						t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();
					}
					if(aversion==1009){
						t.readLine();t.readLine();t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();
					
					}
					if(aversion==1015||aversion==1018){
						t.readLine();t.readLine();t.readLine();t.readLine();t.readLine();
						t.readLine();t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();t.readLine();t.readLine();
					
					}
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v1[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v1[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v1[2]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v2[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v2[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v2[2]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v3[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v3[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataTV[size].v3[2]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&numf[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&numf[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&numf[2]);t.readLine();
					
				DataTV[size].c1[0]=ACITable[idxcolor][0];DataTV[size].c1[1]=ACITable[idxcolor][1];DataTV[size].c1[2]=ACITable[idxcolor][2];
				DataTV[size].c2[0]=ACITable[idxcolor][0];DataTV[size].c2[1]=ACITable[idxcolor][1];DataTV[size].c2[2]=ACITable[idxcolor][2];
				DataTV[size].c3[0]=ACITable[idxcolor][0];DataTV[size].c3[1]=ACITable[idxcolor][1];DataTV[size].c3[2]=ACITable[idxcolor][2];
					
				tempf[0]=DataTV[size].v2[0]-DataTV[size].v1[0];
				tempf[1]=DataTV[size].v2[1]-DataTV[size].v1[1];
				tempf[2]=DataTV[size].v2[2]-DataTV[size].v1[2];
				tempf[3]=DataTV[size].v3[0]-DataTV[size].v1[0];
				tempf[4]=DataTV[size].v3[1]-DataTV[size].v1[1];
				tempf[5]=DataTV[size].v3[2]-DataTV[size].v1[2];
				
				DataTV[size].n3[0]=DataTV[size].n2[0]=DataTV[size].n1[0]=(tempf[1]*tempf[5]-tempf[2]*tempf[4]);
				DataTV[size].n3[1]=DataTV[size].n2[1]=DataTV[size].n1[1]=(tempf[2]*tempf[3]-tempf[0]*tempf[5]);
				DataTV[size].n3[2]=DataTV[size].n2[2]=DataTV[size].n1[2]=(tempf[0]*tempf[4]-tempf[1]*tempf[3]);
				var[0]=sqrt(DataTV[size].n1[0]*DataTV[size].n1[0]+DataTV[size].n1[1]*DataTV[size].n1[1]+DataTV[size].n1[2]*DataTV[size].n1[2]);
				DataTV[size].n3[0]/=var[0];DataTV[size].n2[0]/=var[0];DataTV[size].n1[0]/=var[0];
				DataTV[size].n3[1]/=var[0];DataTV[size].n2[1]/=var[0];DataTV[size].n1[1]/=var[0];
				DataTV[size].n3[2]/=var[0];DataTV[size].n2[2]/=var[0];DataTV[size].n1[2]/=var[0];
					
					DataTV[size].t1[0]=0.0;DataTV[size].t1[1]=1.0;
					DataTV[size].t2[0]=1.0;DataTV[size].t2[1]=1.0;
					DataTV[size].t3[0]=1.0;DataTV[size].t3[1]=0.0;
					DataTV[size].texture=0;
					
					if(numf[0]!=DataTV[size].v3[0]||numf[1]!=DataTV[size].v3[1]||numf[2]!=DataTV[size].v3[2]){
				
				
				size=DataTV.size();DataTV.resize(size+1);
				DataTV[size].c1[0]=ACITable[idxcolor][0];DataTV[size].c1[1]=ACITable[idxcolor][1];DataTV[size].c1[2]=ACITable[idxcolor][2];
				DataTV[size].c2[0]=ACITable[idxcolor][0];DataTV[size].c2[1]=ACITable[idxcolor][1];DataTV[size].c2[2]=ACITable[idxcolor][2];
				DataTV[size].c3[0]=ACITable[idxcolor][0];DataTV[size].c3[1]=ACITable[idxcolor][1];DataTV[size].c3[2]=ACITable[idxcolor][2];
				
				DataTV[size].v1[0]=DataTV[size-1].v1[0];DataTV[size].v1[1]=DataTV[size-1].v1[1];DataTV[size].v1[2]=DataTV[size-1].v1[2];
				DataTV[size].v2[0]=DataTV[size-1].v3[0];DataTV[size].v2[1]=DataTV[size-1].v3[1];DataTV[size].v2[2]=DataTV[size-1].v3[2];
				DataTV[size].v3[0]=numf[0];DataTV[size].v3[1]=numf[1];DataTV[size].v3[2]=numf[2];
				
				tempf[0]=DataTV[size].v2[0]-DataTV[size].v1[0];
				tempf[1]=DataTV[size].v2[1]-DataTV[size].v1[1];
				tempf[2]=DataTV[size].v2[2]-DataTV[size].v1[2];
				tempf[3]=DataTV[size].v3[0]-DataTV[size].v1[0];
				tempf[4]=DataTV[size].v3[1]-DataTV[size].v1[1];
				tempf[5]=DataTV[size].v3[2]-DataTV[size].v1[2];
				
				DataTV[size].n3[0]=DataTV[size].n2[0]=DataTV[size].n1[0]=(tempf[1]*tempf[5]-tempf[2]*tempf[4]);
				DataTV[size].n3[1]=DataTV[size].n2[1]=DataTV[size].n1[1]=(tempf[2]*tempf[3]-tempf[0]*tempf[5]);
				DataTV[size].n3[2]=DataTV[size].n2[2]=DataTV[size].n1[2]=(tempf[0]*tempf[4]-tempf[1]*tempf[3]);
				var[0]=sqrt(DataTV[size].n1[0]*DataTV[size].n1[0]+DataTV[size].n1[1]*DataTV[size].n1[1]+DataTV[size].n1[2]*DataTV[size].n1[2]);
				DataTV[size].n3[0]/=var[0];DataTV[size].n2[0]/=var[0];DataTV[size].n1[0]/=var[0];
				DataTV[size].n3[1]/=var[0];DataTV[size].n2[1]/=var[0];DataTV[size].n1[1]/=var[0];
				DataTV[size].n3[2]/=var[0];DataTV[size].n2[2]/=var[0];DataTV[size].n1[2]/=var[0];
					
					DataTV[size].t1[0]=0.0;DataTV[size].t1[1]=1.0;
					DataTV[size].t2[0]=1.0;DataTV[size].t2[1]=1.0;
					DataTV[size].t3[0]=1.0;DataTV[size].t3[1]=0.0;
					DataTV[size].texture=0;
				
					}
			
				
				}
				if(!textread.compare("LINE")){
				size=DataLV.size();DataLV.resize(size+1);
					if(aversion==1008){
						t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();
					}
					if(aversion==1009){
						t.readLine();t.readLine();t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();
					
					}
					if(aversion==1015||aversion==1018){
						t.readLine();t.readLine();t.readLine();t.readLine();t.readLine();
						t.readLine();t.readLine();t.readLine();t.readLine();
						sscanf(t.readLine().simplified().toAscii(),"%d",&idxcolor);
						t.readLine();t.readLine();t.readLine();
					
					}
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v1[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v1[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v1[2]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v2[0]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v2[1]);t.readLine();
					sscanf(t.readLine().simplified().toAscii(),"%f",&DataLV[size].v2[2]);t.readLine();
				DataLV[size].c1[0]=ACITable[idxcolor][0];DataLV[size].c1[1]=ACITable[idxcolor][1];DataLV[size].c1[2]=ACITable[idxcolor][2];
				DataLV[size].c2[0]=ACITable[idxcolor][0];DataLV[size].c2[1]=ACITable[idxcolor][1];DataLV[size].c2[2]=ACITable[idxcolor][2];
				}
				
			}
			
			}
		
		f.close();

		
	}
	
	
    }else {
	statusBar()->showMessage( "Loading aborted", 2000 );
    }
}

void CadForm::ExportDXF(){

	int i,j,vci=0;
	unsigned long int cn=0xE5;
	QString scn;
	float mvc=3.0;
	float numte[4];
	QString fn = QFileDialog::getSaveFileName(this,QString(tr("Export DXF")),filename,tr("DXF model(*.dxf)"));
	if((int)(fn.length()-4)==fn.lastIndexOf(".dxf")){
		
		}else{
			fn = fn+".dxf";
		}
	
	if ( !fn.isEmpty() ) {
	
		QFile f( fn );
		QTextStream twrite( &f );
		if ( !f.open( QIODevice::WriteOnly ) ){
		
			QMessageBox::critical( this,tr("Fatal error"),QString(tr("Could not write to %1")).arg(fn),tr("OK"));
			f.close();
	
		}else{
			QFile ftest(ProgramPath+"testmin.txt");
	
	
			if ( !ftest.open( QIODevice::ReadOnly ) ){
			
				QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open testmin.txt failed")),tr("OK") );
				f.close();
	
			}else{
		
				QTextStream t(&ftest);
				QString s = t.readAll();
				ftest.close();
				twrite<<s<<"\n";
			}
			
			
			for(i=0;i<DataLV.size();i++,cn++){
				mvc=200000.0;
				for(j=0;j<256;j++){
					numte[0]=255.0*(ACITable[j][0]-DataLV[i].c1[0]);numte[1]=255.0*(ACITable[j][1]-DataLV[i].c1[1]);numte[2]=255.0*(ACITable[j][2]-DataLV[i].c1[2]);
					numte[3]=(numte[0]*numte[0])+(numte[1]*numte[1])+(numte[2]*numte[2]);
					if(numte[3]<mvc){vci=j;mvc=numte[3];}
					
				}
			
				scn.setNum(cn,16);
				twrite<<"0\nLINE\n5\n"<<scn.toUpper()<<"\n330\n1F\n100\nAcDbEntity\n8\n0\n62\n"<<vci<<"\n100\nAcDbLine\n10\n"<<DataLV[i].v1[0]<<"\n20\n"<<DataLV[i].v1[1]<<"\n30\n"<<DataLV[i].v1[2]<<"\n11\n"<<DataLV[i].v2[0]<<"\n21\n"<<DataLV[i].v2[1]<<"\n31\n"<<DataLV[i].v2[2]<<"\n";
				if(cn==0xE7){cn=0xFF;}
			}
			
			for(i=0;i<DataTV.size();i++,cn++){
				mvc=200000.0;
				for(j=0;j<256;j++){
					numte[0]=255.0*(ACITable[j][0]-DataTV[i].c1[0]);numte[1]=255.0*(ACITable[j][1]-DataTV[i].c1[1]);numte[2]=255.0*(ACITable[j][2]-DataTV[i].c1[2]);
					numte[3]=(numte[0]*numte[0])+(numte[1]*numte[1])+(numte[2]*numte[2]);
					if(numte[3]<mvc){vci=j;mvc=numte[3];}
				}
				scn.setNum(cn,16);
				twrite<<"0\n3DFACE\n5\n"<<scn.toUpper()<<"\n330\n1F\n100\nAcDbEntity\n8\n0\n62\n"<<vci<<"\n100\nAcDbFace\n10\n"<<DataTV[i].v1[0]<<"\n20\n"<<DataTV[i].v1[1]<<"\n30\n"<<DataTV[i].v1[2]<<"\n11\n"<<DataTV[i].v2[0]<<"\n21\n"<<DataTV[i].v2[1]<<"\n31\n"<<DataTV[i].v2[2]<<"\n12\n"<<DataTV[i].v3[0]<<"\n22\n"<<DataTV[i].v3[1]<<"\n32\n"<<DataTV[i].v3[2]<<"\n13\n"<<DataTV[i].v3[0]<<"\n23\n"<<DataTV[i].v3[1]<<"\n33\n"<<DataTV[i].v3[2]<<"\n";
				
				if(cn==0xE7){cn=0xFF;}
			}
			
			
			
			
			QFile ftest2(ProgramPath+"testfin.txt");
			if ( !ftest2.open( QIODevice::ReadOnly ) ){
				QMessageBox::critical( this,tr("Fatal error"),QString(tr("Open testfin.txt failed")),tr("OK") );
				ftest2.close();
			}else{
		
				QTextStream t2(&ftest2);
				QString s2 = t2.readAll();
				ftest2.close();
				twrite<<s2;
			}
		}
		
		f.close();
		
		
	}




}


#endif

