#include "dff.h"
#include <iostream>
#include <string.h>

using std::string;

/*	This is the code of a guy named _muzz_ at http://gtaforums.com with some modifications by me, Colossus,
	to adapt it to Cpsed structure. His work is a direct translation of the delphi code of a guy named KCow
	who discovered the specs of the dff format.
*/

LoadDFF::LoadDFF ()
{
}

LoadDFF::~LoadDFF ()
{
}

uint LoadDFF::getuint()
{
	uint r = 0;
	if (size > 0) fread (&r, 1, 4, in);
	return r;
}


word LoadDFF::getword()
{
	word r = 0;
	if (size > 0) fread(&r, 1, 2, in);
	return r;
}


char LoadDFF::getChar()
{
	char c = 0;
	if (size > 0) fread(&c, 1, 1, in);
	return c;
}


void LoadDFF::getbytes(void *dest, int n)
{
	if (size > 0) fread(dest, 1, n, in);
}


uint LoadDFF::getSize()
{
	return size;
}


void LoadDFF::setPosition(uint pos)
{
	if (pos >= size) {
		eof = true;
	} else {
		fseek(in, pos, SEEK_SET);
		eof = false;
	}
}


uint LoadDFF::getPosition()
{
	if (eof) {
		return size;
	} else {
		return ftell(in);
	}
}

int LoadDFF::ImportDFF ( TextureLoader *TextureLoaderClass , string dffname )
{
	uint g, m, v;
	byte min = 30;
	in = fopen ( dffname.c_str(), "rb" );
	if (! in ) return (0);
	else
	{
		fseek(in, 0, SEEK_END);
		size = ftell(in);
		fseek(in, 0, SEEK_SET);
	}
	eof = false;
	clump = new TDFFClump;
	nclump = 0;
	memset(clump, 0, sizeof(TDFFClump));
	if ( getSize() != 0) LoadFromStream();
	fclose (in);
	for (g = 0; g < clump->GeometryList.GeometryCount; g++)
	{
		for (m = 0; m < clump->GeometryList.Geometry[g].MaterialList.MaterialCount; m++)
		{
			TDFFMaterial &mat = clump->GeometryList.Geometry[g].MaterialList.Material[m];
			
			//Added by Colossus on 27/09/04 to load the textures in TGA format
			if ( strlen ( mat.Texture.Name ) > 0 )
        		{
				if ( TextureLoaderClass->TextureMap.count ( mat.Texture.Name ) == 0 )
				{
					dffname = TextureLoaderClass->RemoveMeshFileNameFromPath ( dffname );
					int result = TextureLoaderClass->CreateTexture (  dffname , mat.Texture.Name , ID );
					if (result == -1) printf ("*** Can't load texture: %s ***\n" ,  mat.Texture.Name );
				}
			}
			//End
		}
		TDFFDataGeometry &dg = clump->GeometryList.Geometry[g].Data;
		if (dg.Color)
		{
			for (v = 0; v < dg.Header.VertexCount; v++)
			{
				if (dg.Color[v].r < min) dg.Color[v].r = min;
				if (dg.Color[v].g < min) dg.Color[v].g = min;
				if (dg.Color[v].b < min) dg.Color[v].b = min;
			}
		}
	}
	//Added by Colossus on 16/10/04 to allow drawing the frames ( in the car models ) of the doors, windscreen, etc.in the right position
	for ( v = 0; v < clump->FrameList.Data.FrameCount; v++ )
	{
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[0] = clump->FrameList.Data.Frame[ v ].Matrix.v[0];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[1] = clump->FrameList.Data.Frame[ v ].Matrix.v[1];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[2] = clump->FrameList.Data.Frame[ v ].Matrix.v[2];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[3] = 0.0f;
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[4] = clump->FrameList.Data.Frame[ v ].Matrix.v[3];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[5] = clump->FrameList.Data.Frame[ v ].Matrix.v[4];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[6] = clump->FrameList.Data.Frame[ v ].Matrix.v[5];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[7] = 0.0f;
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[8] = clump->FrameList.Data.Frame[ v ].Matrix.v[6];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[9] = clump->FrameList.Data.Frame[ v ].Matrix.v[7];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[10] = clump->FrameList.Data.Frame[ v ].Matrix.v[8];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[11] = 0.0f;
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[12] = clump->FrameList.Data.Frame[ v ].Coord.v[0];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[13] = clump->FrameList.Data.Frame[ v ].Coord.v[1];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[14] = clump->FrameList.Data.Frame[ v ].Coord.v[2];
		clump->FrameList.Data.Frame[ v ].Copy_of_Matrix.v[15] = 1.0f;
		if ( (int) clump->FrameList.Data.Frame[ v ].Parent < 0 )
		{
			clump->FrameList.Data.Frame[ v ].LTM = clump->FrameList.Data.Frame[ v ].Copy_of_Matrix;
		}
		else
		{
			g = clump->FrameList.Data.Frame[ v ].Parent;
			clump->FrameList.Data.Frame[ v ].LTM = MatrixMultiply ( clump->FrameList.Data.Frame[ v ].Copy_of_Matrix , clump->FrameList.Data.Frame[ g ] );
		}
	}
	//End
	
	//dump();		//Print DFF structure data
	return 1;
}

	//Added by Colossus on 16/10/04 to allow drawing the frames ( in the car models ) of the doors, windscreen, etc.in the right position
TMatrix4f LoadDFF::MatrixMultiply ( TMatrix4f one, TDFFFrame &two )
{
	TMatrix4f dum;
	dum.v[0] = one.v[0] * two.Matrix.v[0] + one.v[1] * two.Matrix.v[3] + one.v[2] * two.Matrix.v[6] + one.v[3] * two.Coord.v[0];
	dum.v[1] = one.v[0] * two.Matrix.v[1] + one.v[1] * two.Matrix.v[4] + one.v[2] * two.Matrix.v[7] + one.v[3] * two.Coord.v[1];
	dum.v[2] = one.v[0] * two.Matrix.v[2] + one.v[1] * two.Matrix.v[5] + one.v[2] * two.Matrix.v[8] + one.v[3] * two.Coord.v[2];
	dum.v[3] = 0.0f;
	dum.v[4] = one.v[4] * two.Matrix.v[0] + one.v[5] * two.Matrix.v[3] + one.v[6] * two.Matrix.v[6] + one.v[7] * two.Coord.v[0];
	dum.v[5] = one.v[4] * two.Matrix.v[1] + one.v[5] * two.Matrix.v[4] + one.v[6] * two.Matrix.v[7] + one.v[7] * two.Coord.v[1];
	dum.v[6] = one.v[4] * two.Matrix.v[2] + one.v[5] * two.Matrix.v[5] + one.v[6] * two.Matrix.v[8] + one.v[7] * two.Coord.v[2];
	dum.v[7] = 0.0f;
	dum.v[8] = one.v[8] * two.Matrix.v[0] + one.v[9] * two.Matrix.v[3] + one.v[10] * two.Matrix.v[6] + one.v[11] * two.Coord.v[0];
	dum.v[9] = one.v[8] * two.Matrix.v[1] + one.v[9] * two.Matrix.v[4] + one.v[10] * two.Matrix.v[7] + one.v[11] * two.Coord.v[1];
	dum.v[10] = one.v[8] * two.Matrix.v[2] + one.v[9] * two.Matrix.v[5] + one.v[10] * two.Matrix.v[8] + one.v[11] * two.Coord.v[2];
	dum.v[11] = 0.0f;
	dum.v[12] = one.v[12] * two.Matrix.v[0] + one.v[13] * two.Matrix.v[3] + one.v[14] * two.Matrix.v[6] + one.v[15] * two.Coord.v[0];
	dum.v[13] = one.v[12] * two.Matrix.v[1] + one.v[13] * two.Matrix.v[4] + one.v[14] * two.Matrix.v[7] + one.v[15] * two.Coord.v[1];
	dum.v[14] = one.v[12] * two.Matrix.v[2] + one.v[13] * two.Matrix.v[5] + one.v[14] * two.Matrix.v[8] + one.v[15] * two.Coord.v[2];
	dum.v[15] = 1.0f;
	return dum;
}
	//End

void LoadDFF::LoadFromStream()
{
	THeader MainHeader;
	MainHeader.Start = 0;
	MainHeader.Tag = 0;
	MainHeader.Size = getSize();
	MainHeader.Data1 = 0;
	MainHeader.Data2 = 0;
	MainHeader.Back = 0;
	ParseHeaders(MainHeader, 0, 16);
}


void LoadDFF::GetNextHeader(THeader &OutHeader)
{
	OutHeader.Start = getPosition();
	OutHeader.Tag = getuint();
	OutHeader.Size = getuint();
	OutHeader.Data1 = getword();
	OutHeader.Data2 = getword();
	OutHeader.Back = getPosition();
}


void LoadDFF::ParseHeaders(THeader &ParseHeader, uint Level, uint Parent)
{
	THeader InHeader;
	bool MoreData = true;
	while (MoreData)
	{
		ls[0] = 0;
		for (uint i = 0; i < Level * 2; i++) strcat(ls, " ");
			GetNextHeader(InHeader);
		switch (InHeader.Tag)
		{
			case rwCLUMP:
				nclump++;
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwDATA:
				ParseData(InHeader, Parent);
				break;

			case rwFRAMELIST:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwGEOMETRYLIST:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwGEOMETRY:
				clump->GeometryList.GeometryCount++;
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwMATERIALLIST:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwMATERIAL:
				clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].MaterialList.MaterialCount++;
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwTEXTURE:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwATOMIC:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwEXTENSION:
				if (InHeader.Size > 0) ParseHeaders(InHeader, Level + 1, Parent);
				break;

			case rwFRAME:
				ParseString(InHeader, Parent);
				break;

			case rwSTRING:
				ParseString(InHeader, Parent);
				break;

			case rwMATERIALSPLIT:
				ParseMaterialSplit();
				break;

			case rwMORPH_PLG:
				break;

			case rwSKYMIPMAPVAL:
				break;

			case rwHANIM_PLG:
				break;

			case rwLIGHT:
				break;

			case rwTEXTUREDICTIONARY:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			case rwTEXTURENATIVE:
				ParseHeaders(InHeader, Level + 1, InHeader.Tag);
				break;

			default:
				break;
		}

		setPosition(InHeader.Back + InHeader.Size);
		if (( getPosition() >= (ParseHeader.Back + ParseHeader.Size)) || InHeader.Tag == 0) MoreData = false;
	}
}


void LoadDFF::ParseData(THeader &ParseHeader, uint Parent)
{
	switch (Parent)
	{
		case rwCLUMP:
			clump->Data.ObjectCount = getuint();
			break;

		case rwFRAMELIST:
		{
			TDFFDataFrameList &dfl = clump->FrameList.Data;
			dfl.FrameUpTo = 0;
			dfl.FrameCount = getuint();
			dfl.Frame = new TDFFFrame[dfl.FrameCount];
			for (uint i = 0; i < dfl.FrameCount; i++)
			{
				dfl.Frame[i].Name[0] = 0;
				getbytes(dfl.Frame[i].Matrix.v, 9 * sizeof(float));
				getbytes(dfl.Frame[i].Coord.v, 3 * sizeof(float));
				dfl.Frame[i].Parent = getuint();
				dfl.Frame[i].Other1 = getword();
				dfl.Frame[i].Other2 = getword();
			}
		}
		break;

	case rwGEOMETRYLIST:
		clump->GeometryList.Data.GeometryCount = getuint();
		clump->GeometryList.Geometry = new TDFFGeometry[clump->GeometryList.Data.GeometryCount];
		memset(clump->GeometryList.Geometry, 0, clump->GeometryList.Data.GeometryCount * sizeof(TDFFGeometry));
		break;

	case rwGEOMETRY:
		{
			TDFFDataGeometry &dg = clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].Data;
			
			getbytes(&dg.Header, sizeof(TDFFHeaderDataGeometry));
			
			if (ParseHeader.Data2 != 4099) {
				getbytes(&dg.LightHeader, sizeof(TDFFLightHeaderDataGeometry));
			} else {
				memset(&dg.LightHeader, 0, sizeof(TDFFLightHeaderDataGeometry));
			}
		
			if ((dg.Header.Flags1 & rwOBJECT_VERTEX_COLOR) == rwOBJECT_VERTEX_COLOR) {
				dg.Color = new TColorub[dg.Header.VertexCount];
				getbytes(dg.Color, dg.Header.VertexCount * sizeof(TColorub));
			}

			if ((dg.Header.Flags1 & rwOBJECT_VERTEX_UV) == rwOBJECT_VERTEX_UV) {
				dg.UV = new TVector2f[dg.Header.VertexCount];
				getbytes(dg.UV, dg.Header.VertexCount * sizeof(TVector2f));
			}

			dg.Face = new TDFFFace[dg.Header.TriangleCount];
			getbytes(dg.Face, (dg.Header.TriangleCount) * sizeof(TDFFFace));

			getbytes(&dg.Extra, sizeof(TDFFExtraDataGeometry));

			dg.Vertex = new TVector3f[dg.Header.VertexCount];
			getbytes(dg.Vertex, dg.Header.VertexCount * sizeof(TVector3f));

			if ((dg.Header.Flags1 & rwOBJECT_VERTEX_NORMAL) == rwOBJECT_VERTEX_NORMAL) {
				dg.Normal = new TVector3f[dg.Header.VertexCount];
				getbytes(dg.Normal, dg.Header.VertexCount * sizeof(TVector3f));
			}
		}
		break;

	case rwMATERIALLIST:
		{
			TDFFMaterialList &ml = clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].MaterialList;
			ml.Data.MaterialCount = getuint();
			ml.Data.Other = getuint();
			ml.Material = new TDFFMaterial[ml.Data.MaterialCount];
			memset(ml.Material, 0, ml.Data.MaterialCount * sizeof(TDFFMaterial));
		}
		break;

	case rwMATERIAL:
		{
			TDFFGeometry &geom = clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1];
			TDFFMaterial &mat = geom.MaterialList.Material[geom.MaterialList.MaterialCount - 1];
			getbytes(&mat.Data, sizeof(TDFFDataMaterial));
		}
		break;

	case rwTEXTURE:
		getuint();	// filter flags?
		break;

	case rwATOMIC:
		{
			TDFFAtomic *a = clump->Atomic;
			if (a) {
				while (a->next) a = a->next;
				a->next = new TDFFAtomic;
				a = a->next;
			} else {
				clump->Atomic = new TDFFAtomic;
				a = clump->Atomic;
			}
			a->next = 0;
			getbytes(&a->Data, sizeof (TDFFDataAtomic));
		}
		break;

	default:
		break;
	}
}


void LoadDFF::ParseString(THeader &ParseHeader, uint Parent)
{
	switch (Parent)
	{
		case rwFRAMELIST:
		{
			TDFFDataFrameList &dfl = clump->FrameList.Data;
			int n = ParseHeader.Size;
			if (n > 63) n = 63;
			getbytes(dfl.Frame[dfl.FrameUpTo].Name, n);
			dfl.Frame[dfl.FrameUpTo].Name[n] = 0;
			dfl.FrameUpTo++;
		}
		break;

		case rwTEXTURE: 
		{
			TDFFTexture &t = clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].MaterialList.Material[clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].MaterialList.MaterialCount - 1].Texture;
			int n = ParseHeader.Size;
			if (n > 31) n = 31;
			if (t.Name[0]) {
				getbytes(t.Alpha, n);
				t.Alpha[n] = 0;
			} else {
				getbytes(t.Name, n);
				t.Name[n] = 0;
			}
		} 
		break;
	}
}


void LoadDFF::ParseMaterialSplit()
{
	uint i;
	TDFFMaterialSplit &ms = clump->GeometryList.Geometry[clump->GeometryList.GeometryCount - 1].MaterialSplit;

	getbytes(&ms.Header, sizeof(TDFFHeaderMaterialSplit));
	ms.Split = new TDFFSplit[ms.Header.SplitCount];

	for (i = 0; i < ms.Header.SplitCount; i++) {
		TDFFSplit &sp = ms.Split[i];

		sp.FaceCount = getuint();
		sp.MaterialIndex = getuint();
		sp.Index = new uint[sp.FaceCount];
		getbytes(sp.Index, sp.FaceCount * sizeof(uint));
	}
}

void LoadDFF::dump()
{
	uint f, g, m, sp;
	for (f = 0; f < clump->FrameList.Data.FrameCount; f++)
	{
		TDFFFrame &frm = clump->FrameList.Data.Frame[f];
		printf("frame: %d\n", f);
		printf("  name:     %s\n", frm.Name);
		printf("  rotation: %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f %.2f\n", frm.Matrix.v[0], frm.Matrix.v[1], frm.Matrix.v[2], frm.Matrix.v[3], frm.Matrix.v[4], frm.Matrix.v[5], frm.Matrix.v[6], frm.Matrix.v[7], frm.Matrix.v[8]);
		printf("  position: %.2f %.2f %.2f\n", frm.Coord.v[0], frm.Coord.v[1], frm.Coord.v[2]);
		printf("  parent:   %d\n", frm.Parent);
	}

	printf("\n");
	for (g = 0; g < clump->GeometryList.GeometryCount; g++) {
		printf("Geometry: %d\n", g);
		TDFFGeometry &geom = clump->GeometryList.Geometry[g];

		printf("  TriangleCount: %d\n", geom.Data.Header.TriangleCount);
		printf("  VertexCount:   %d\n", geom.Data.Header.VertexCount);
		if (geom.Data.Color) printf("  OBJECT_VERTEX_COLOR\n");
		if (geom.Data.UV) printf("  OBJECT_VERTEX_UV\n");
		if (geom.Data.Normal) printf("  OBJECT_VERTEX_NORMAL\n");

		printf("  nMaterial: %d\n", geom.MaterialList.MaterialCount);
		for (m = 0; m < geom.MaterialList.MaterialCount; m++) {
			TDFFMaterial &mat = geom.MaterialList.Material[m];
			
			printf("    material: %d\n", m);
			printf("      tex:    %s\n", mat.Texture.Name);
			printf("      alpha:  %s\n", mat.Texture.Alpha);
		}

		printf("  MaterialSplit\n");
		printf("  Data:       %d\n", geom.MaterialSplit.Header.Data);
		printf("  SplitCount: %d\n", geom.MaterialSplit.Header.SplitCount);
		printf("  FaceCount:  %d\n", geom.MaterialSplit.Header.FaceCount);
		for (sp = 0; sp < geom.MaterialSplit.Header.SplitCount; sp++) {
			TDFFSplit &spl = geom.MaterialSplit.Split[sp];

			printf("    Split: %d\n", sp);
			printf("      FaceCount: %d\n", spl.FaceCount);
			printf("      Material:  %d\n", spl.MaterialIndex);
		}
	}

	printf("\n");
	TDFFAtomic *a = clump->Atomic;
	m = 0;
	while (a)
	{
		printf("Atomic: %d\n", m);
		printf("  FrameNum:    %d\n", a->Data.FrameNum);
		printf("  GeometryNum: %d\n", a->Data.GeometryNum);
		m++;
		a = a->next;
	}
}

void LoadDFF::Release()
{
	uint g, s;
	delete[] clump->FrameList.Data.Frame;
	for (g = 0; g < clump->GeometryList.GeometryCount; g++)
	{
		TDFFGeometry &geom = clump->GeometryList.Geometry[g];
		if (geom.Data.Color) delete[] geom.Data.Color;
		if (geom.Data.UV) delete[] geom.Data.UV;
		if (geom.Data.Face) delete[] geom.Data.Face;
		if (geom.Data.Vertex) delete[] geom.Data.Vertex;
		if (geom.Data.Normal) delete[] geom.Data.Normal;
		if (geom.MaterialList.Material) delete[] geom.MaterialList.Material;
		for (s = 0; s < geom.MaterialSplit.Header.SplitCount; s++)
		{
			if (geom.MaterialSplit.Split[s].Index) delete[] geom.MaterialSplit.Split[s].Index;
		}
		if (geom.MaterialSplit.Split) delete[] geom.MaterialSplit.Split;
	}
	
	TDFFAtomic *a,*na;
	a = clump->Atomic;	
	while (a)
	{
		na = a->next;
		delete a;
		a = na;
	}
	delete clump;
}
