#include <GL/glu.h>
#include <stdio.h>
#include "dff_types.h"
#include <string.h>
#include "textureloader.h"

using std::string;

class LoadDFF
{
	public:
	LoadDFF ();
	~LoadDFF ();
	int		ImportDFF ( TextureLoader *TextureLoaderClass , string dffname );
	uint		getSize();
	void		setPosition(unsigned);
	uint		getPosition();
	uint		getuint();
	word	getword();
	char		getChar();
	void		getbytes(void*, int);
	char		dffname[64];
	char		txdname[64];
	char		ls[256];
	int		id;
	float		glm[16];
	GLuint	solidID;
	GLuint	alphaID;
	int		hasAlpha;
	float		ddMin, ddMax;
	int		flags;
	int		interior;
	int		nclump;
	int		vlevel;
	FILE		*in;
	uint		size;
	uint		ID;
	bool		eof;
	void		dump();
	void		LoadFromStream();
	//Added by Colossus on 16/10/04 to load the several frames to the right place
	TMatrix4f	MatrixMultiply ( TMatrix4f one, TDFFFrame &frm );
	void		GetNextHeader(THeader&);
	void		ParseHeaders(THeader&, uint, uint);
	void		ParseData(THeader&, uint);
	void		ParseString(THeader&, uint);
	void		ParseMaterialSplit();
	void		Release();
	char		*getNextItem(char*, char*);
	TDFFClump	*clump;
};
