/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
#ifndef ITEMDIALOG_H
#define ITEMDIALOG_H

#include <qvariant.h>
#include <qpixmap.h>
#include <qdialog.h>
#include <math.h>
#include "glwidget.h"
#include "undo.h"

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QSpacerItem;
class QLabel;
class QLineEdit;
class QPushButton;
class QListBox;
class QListBoxItem;
class QCheckBox;
class QSlider;

class GLWidget;
class Undo;

class ItemDialogClass : public QDialog
{
    Q_OBJECT

public:
    ItemDialogClass( GLWidget *pointer , QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~ItemDialogClass();
    
    bool ka , Add_Flag;
    unsigned int ChoosedModel;
    float Xpos , Ypos , Zpos , FxRot , FyRot , FzRot;
    void UpdateModelString ();
    QString ModelName;
    GLWidget *GlWidgetClass;
    Undo *UndoClass;
    QPushButton* Zrot_increase;
    QPushButton* Xpos_decrease;
    QPushButton* Zpos_increase_fast;
    QPushButton* Zrot_increase_fast;
    QPushButton* Xrot_decrease_fast;
    QPushButton* Yrot_decrease;
    QPushButton* Zrot_decrease;
    QLabel* Zpos_label;
    QPushButton* Yrot_increase_fast;
    QPushButton* Yrot_decrease_fast;
    QPushButton* Xpos_increase;
    QPushButton* Ypos_decrease;
    QPushButton *Ypos_increase_fast;
    QPushButton* Ypos_increase;
    QPushButton* Yrot_increase;
    QPushButton* Xpos_decrease_fast;
    QLabel* rotation;
    QPushButton* Xrot_decrease;
    QPushButton* Zpos_increase;
    QPushButton* Zpos_decrease;
    QPushButton* Ypos_decrease_fast;
    QPushButton* Zpos_decrease_fast;
    QLabel* Xpos_label;
    QPushButton* Xrot_increase_fast;
    QPushButton* Xpos_increase_fast;
    QLabel* Yrot_label;
    QPushButton* Zrot_decrease_fast;
    QLabel* position;
    QPushButton* Xrot_increase;
    QLabel* Xrot;
    QLabel* Ypos_label;
    QLabel* Xrot_label;
    QLabel* Yrot;
    QLabel* Zrot_label;
    QLabel* Zrot;
    QLineEdit* model_string;
    QLabel* id_number;
    QCheckBox* keep_aspect;
    QCheckBox* Scale;
    QListBox* texture_listbox;
    QLabel* id_label;
    QLabel* textLabel2;
    QLineEdit* filename_edit;
    QLabel* textLabel1;
    QLabel* textLabel1_2;
    QLabel* model_label;
    QSlider* scaleX;
    QSlider* scaleY;
    QSlider* scaleZ;

public slots:
	virtual void languageChange();
	void setSliderState (bool);
	void setAspectState ( bool );
	void ChangeScaleX ( int );
	void ChangeScaleY ( int );
	void ChangeScaleZ ( int );
	void Xpos_inc_fast();
	void Xpos_dec_fast();
	void Xpos_dec();
	void Xpos_inc();
	void Ypos_inc_fast();
	void Ypos_dec_fast();
	void Ypos_dec();
	void Ypos_inc();
	void Zpos_inc_fast();
	void Zpos_dec_fast();
	void Zpos_dec();
	void Zpos_inc();
	
	void Xrot_inc_fast();
	void Xrot_dec_fast();
	void Xrot_dec();
	void Xrot_inc();
	void Yrot_inc_fast();
	void Yrot_dec_fast();
	void Yrot_dec();
	void Yrot_inc();
	void Zrot_inc_fast();
	void Zrot_dec_fast();
	void Zrot_dec();
	void Zrot_inc();
	
signals:
	void valueChanged ( int );
	
private:
    QPixmap image0;
    QPixmap image1;
    QPixmap image2;
    QPixmap image3;

};

#endif // ITEMDIALOG_H
