/***************************************************************************
 *   Copyright (C) 2004 by Colossus (Giuseppe Torelli)                     *
 *   gt67@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef UNDO_H
#define UNDO_H

#include <vector>
#include "glwidget.h"
#include "glwindow.h"

using namespace std;

enum type { moveX , moveY,  moveZ, rotateX, rotateY, rotateZ, deleteModel, deleteScene, unLoadModel};

struct UndoStruct
{
	type action;
	vector <uint> id_To_Delete;
	string modelname;
	float amount;
	uint id;
	inline UndoStruct () {}
	inline UndoStruct ( type _action , float _amount, uint _id ) : action ( _action) , amount (_amount) , id ( _id) {}
	inline UndoStruct ( type _action , string _modelname , uint _id ) : action ( _action) , modelname ( _modelname) , id ( _id) {}
	inline UndoStruct ( type _action , vector <uint>  _id_To_Delete , string _modelname  ) : action (_action) , id_To_Delete ( _id_To_Delete ) , modelname ( _modelname ) {}
};

class GLWidget;
class GlWindow;

class Undo
{
public:
	Undo ( GLWidget *pointer , GlWindow* dummy );
	~Undo();
	int ArrayIndex;
	void AddAction ( type action, float amount , uint id );
	void AddAction ( type action, string dummyname , uint id );
	void AddAction ( type action, vector <uint> id_To_Delete , string modelname );
	void UndoAction();
	void RedoAction();
	vector <UndoStruct> UndoArray;

private:
	GlWindow	*GlWindowClass;
	GLWidget	*GlWidgetClass;
};
#endif // UNDO_H
