/***************************************************************************
                          definiteintegralfunction.h  -  description
                             -------------------
    begin                : Mon Nov 11 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DEFINITEINTEGRALFUNCTION_H
#define DEFINITEINTEGRALFUNCTION_H

#include "mathfunction.h"

class QPainter;
class QPointArray;
class BasicGraph;

/**
 * \author Fungmeista
 * \brief BasicGraph uses this to calculate the definite integral of a function
 * \note This numerically calculates the definite integral using the Trapazoid Rule.  This means that for non-continuous functions it will not return correct values for
 *       the definite integral since it is not defined.
 */
class DefiniteIntegralFunction : public MathFunction
{
	public:
		DefiniteIntegralFunction(BasicGraph * = 0, int expression_count = 0, double precision=0.5);
		~DefiniteIntegralFunction();

	protected:
		void calculate_and_draw(QPainter *);
		void draw_stored(QPainter *);

	private:
		double precision;
		QPointArray *pointsStorage;
};

#endif //DEFINITEINTEGRALFUNCTION_H
