/***************************************************************************
                          densityplot.h  -  description
                             -------------------
    begin                : Sat May 25 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami442@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DENSITYPLOT_H
#define DENSITYPLOT_H

#include "expressiongraph.h"

class FungParser;

/**
 * \author Fungmeista
 * \brief A class plotting the density of an expression using variances in color 'value' on an x-y grid
 */
class DensityPlot : public ExpressionGraph
{
	Q_OBJECT

	public:
		DensityPlot ( QWidget *parent=0, const char *name=0 );
		~DensityPlot();

		virtual inline int getGraphType() const{return DENSITYPLOT;}

	protected:
		virtual const char * independent_vars(){return "x,y";}
		virtual const char * dependent_var(int=0){return "z";}
		virtual void drawExpression(QPainter *painter, Expression &);
		virtual int setXYForTrace(const double, const double, double *, double *, Expression &);
                virtual void updateCoords();
};

#endif //DensityPlot_H
