/***************************************************************************
                          frequencyplot.h  -  description
                             -------------------
    begin                : Sun May 11 2003
    copyright            : (C) 2003 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef FREQUENCYPLOT_H
#define FREQUENCYPLOT_H

#include "plotmodule.h"

#include <vector>

/**
 * \author Fungmeista
 * \brief A base class for a Stat Plot's plot modes
 */
class FrequencyPlot : public PlotModule
{
	public: 
		FrequencyPlot(std::vector<double> & xlist, int classes, bool show, const QColor & color);
		virtual ~FrequencyPlot(){}
		//bool operator==(const PlotModule &);

		virtual void drawPlot( QPainter *, int *, StatPlotGraph *graph, double xScale, double yScale );
		virtual void trace( double, double, double *, double * );
		virtual std::string updateCoords( double, double );

		virtual void zoomStat( double *xmin, double *xmax, double *ymin, double *ymax );
		
	private:
		double _interval;
		std::vector<double> _frequency;
		double _min;

		std::vector<double> _xlist;
		int _classes;
};

#endif
