/***************************************************************************
                          glpolargraph.h  -  description
                             -------------------
    begin                : Fri Oct 18 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GLPOLARGRAPH_H
#define GLPOLARGRAPH_H

#include "glexpressiongraph.h"

/**
 * \author Fungmeista
 * \brief Plots/graphs three dimensional implicit functions as "z" with respect to "x" and "y".  Currently this class is in alpha stage.
 */
class GLPolarGraph : public GLExpressionGraph
{
	Q_OBJECT

	public:
		GLPolarGraph(QWidget *parent=0, const char *name=0);
		~GLPolarGraph();

		int setPolarMin(GLfloat);
		int setPolarMax(GLfloat);
		int setAzimuthalMin(GLfloat);
		int setAzimuthalMax(GLfloat);

		GLfloat getPolarMin() const{return tMin;}
		GLfloat getPolarMax() const{return tMax;}
		GLfloat getAzimuthalMin() const{return aMin;}
		GLfloat getAzimuthalMax() const{return aMax;}
		
		virtual inline int getGraphType() const{return GLPOLARGRAPH;}

	protected:
		virtual const char * independent_vars() const{return "a,p";}
		virtual const char * dependent_var() const{return "r";}
		void trace(GLfloat mouseX, GLfloat mouseY, FungParser &parsed_function, GLfloat *x, GLfloat *y, GLfloat *z);

		inline virtual GLfloat traceDepX(GLfloat x) const{return (x-getXMin())/((getXMax()-getXMin())/(aMax-aMin))+aMin;}
		inline virtual GLfloat traceDepY(GLfloat y) const{return (y-getYMin())/((getYMax()-getYMin())/(tMax-tMin))+tMin;}

		virtual Cartesian3DCoord2DVector getValues( FungParser &fp, GLfloat *, GLfloat * );

	private:
		GLfloat tMin,tMax,aMin,aMax;

};

#endif

