/***************************************************************************
                          rectcoord.h  -  description
                             -------------------
    begin                : Sun May 26 2002
    copyright            : (C) 2002 by Fungmeista
    email                : mizunoami44@sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef RECTCOORD_H
#define RECTCOORD_H

#define PI 3.141592653589

class PolarCoord;

/**
 * \author Fungmeista
 * \brief A class for storing a rectangular coordinate and can convert it into a polar coordinate.
 */
class RectCoord
{
	public:
		static const int RADIANS = 0;
		static const int DEGREES = 1;

		RectCoord(double x=0,double y=0);
		PolarCoord toPolar(int mode=RADIANS, bool bearing=true);
		inline double getX() const{return x;}
		inline double getY() const{return y;}

	private:
		double x,y;
};

#endif
