/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.plugin.PlugIn;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class FITS_Writer
implements PlugIn {
    public void run(String path) {
        ImagePlus imp = IJ.getImage();
        ImageProcessor ip = imp.getProcessor();
        int numImages = imp.getImageStackSize();
        int bitDepth = imp.getBitDepth();
        if (bitDepth == 24) {
            IJ.error("RGB images are not supported");
            return;
        }
        File f = new File(path);
        String directory = f.getParent() + File.separator;
        String name = f.getName();
        if (f.exists()) {
            f.delete();
        }
        int numBytes = 0;
        if (bitDepth == 8) {
            ip = ip.convertToShort(false);
        } else if (imp.getCalibration().isSigned16Bit()) {
            ip = ip.convertToFloat();
        }
        if (ip instanceof ShortProcessor) {
            numBytes = 2;
        } else if (ip instanceof FloatProcessor) {
            numBytes = 4;
        }
        int fillerLength = 2880 - numBytes * imp.getWidth() * imp.getHeight() % 2880;
        this.createHeader(path, ip, numBytes);
        this.writeData(path, ip);
        char[] endFiller = new char[fillerLength];
        this.appendFile(endFiller, path);
    }

    void createHeader(String path, ImageProcessor ip, int numBytes) {
        int numCards = 5;
        String bitperpix = "";
        if (numBytes == 2) {
            bitperpix = "                  16";
        } else if (numBytes == 4) {
            bitperpix = "                 -32";
        } else if (numBytes == 1) {
            bitperpix = "                   8";
        }
        this.appendFile(this.writeCard("SIMPLE", "                   T", ""), path);
        this.appendFile(this.writeCard("BITPIX", bitperpix, ""), path);
        this.appendFile(this.writeCard("NAXIS", "                   2", ""), path);
        this.appendFile(this.writeCard("NAXIS1", "                 " + ip.getWidth(), "image width"), path);
        this.appendFile(this.writeCard("NAXIS2", "                 " + ip.getHeight(), "image height"), path);
        int fillerSize = 2880 - (numCards * 80 + 3) % 2880;
        char[] end = new char[]{'E', 'N', 'D'};
        char[] filler = new char[fillerSize];
        for (int i = 0; i < fillerSize; ++i) {
            filler[i] = 32;
        }
        this.appendFile(end, path);
        this.appendFile(filler, path);
    }

    char[] writeCard(String title, String value, String comment) {
        char[] card = new char[80];
        for (int i = 0; i < 80; ++i) {
            card[i] = 32;
        }
        this.s2ch(title, card, 0);
        card[8] = 61;
        this.s2ch(value, card, 10);
        card[31] = 47;
        this.s2ch(comment, card, 32);
        return card;
    }

    void s2ch(String str, char[] ch, int offset) {
        int j = 0;
        for (int i = offset; i < str.length() + offset; ++i) {
            ch[i] = str.charAt(j++);
        }
    }

    void appendFile(char[] line, String path) {
        try {
            FileWriter output = new FileWriter(path, true);
            output.write(line);
            output.close();
        }
        catch (IOException e) {
            IJ.showStatus("Error writing file!");
            return;
        }
    }

    void writeData(String path, ImageProcessor ip) {
        int w = ip.getWidth();
        int h = ip.getHeight();
        ip.flipVertical();
        if (ip instanceof ShortProcessor) {
            short[] pixels = (short[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = 0; i < pixels.length; ++i) {
                    dos.writeShort(pixels[i]);
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.write("Error writing file!");
                return;
            }
        }
        if (ip instanceof FloatProcessor) {
            float[] pixels = (float[])ip.getPixels();
            try {
                DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path, true)));
                for (int i = 0; i < pixels.length; ++i) {
                    dos.writeFloat(pixels[i]);
                }
                dos.close();
            }
            catch (IOException e) {
                IJ.write("Error writing file!");
                return;
            }
        }
        ip.flipVertical();
    }
}

