/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.LUT;
import java.awt.AWTEvent;
import java.awt.Checkbox;
import java.awt.Label;

public class HyperStackReducer
implements PlugIn,
DialogListener {
    ImagePlus imp;
    int channels1;
    int slices1;
    int frames1;
    int channels2;
    int slices2;
    int frames2;
    double imageSize;
    static boolean keep = true;

    public HyperStackReducer() {
    }

    public HyperStackReducer(ImagePlus imp) {
        this.imp = imp;
    }

    public void run(String arg) {
        int mode;
        this.imp = IJ.getImage();
        if (!this.imp.isHyperStack() && !this.imp.isComposite()) {
            IJ.error("Reducer", "HyperStack required");
            return;
        }
        int width = this.imp.getWidth();
        int height = this.imp.getHeight();
        this.imageSize = (double)(width * height * this.imp.getBytesPerPixel()) / 1048576.0;
        this.channels1 = this.channels2 = this.imp.getNChannels();
        this.slices1 = this.slices2 = this.imp.getNSlices();
        this.frames1 = this.frames2 = this.imp.getNFrames();
        int c1 = this.imp.getChannel();
        int z1 = this.imp.getSlice();
        int t2 = this.imp.getFrame();
        int n = mode = this.imp.isComposite() ? ((CompositeImage)this.imp).getMode() : -1;
        if (!this.showDialog()) {
            return;
        }
        String title2 = keep ? WindowManager.getUniqueName(this.imp.getTitle()) : this.imp.getTitle();
        int bitDepth = this.imp.getBitDepth();
        int size = this.channels2 * this.slices2 * this.frames2;
        ImagePlus imp2 = null;
        if (keep) {
            imp2 = IJ.createImage(title2, bitDepth + "-bit", width, height, size);
            if (imp2 == null) {
                return;
            }
        } else {
            ImageStack stack2 = new ImageStack(width, height, size);
            stack2.setPixels(this.imp.getProcessor().getPixels(), 1);
            imp2 = new ImagePlus(title2, stack2);
            stack2.setPixels(null, 1);
        }
        imp2.setDimensions(this.channels2, this.slices2, this.frames2);
        this.reduce(imp2);
        imp2.setOpenAsHyperStack(true);
        if (this.channels2 > 1 && this.imp.isComposite()) {
            imp2 = new CompositeImage(imp2, mode);
        }
        imp2.show();
        if (!keep) {
            this.imp.changes = false;
            this.imp.close();
        }
    }

    public void reduce(ImagePlus imp2) {
        int channels = imp2.getNChannels();
        int slices = imp2.getNSlices();
        int frames = imp2.getNFrames();
        int c1 = this.imp.getChannel();
        int z1 = this.imp.getSlice();
        int t1 = this.imp.getFrame();
        int i = 1;
        int n = channels * slices * frames;
        ImageStack stack = this.imp.getStack();
        ImageStack stack2 = imp2.getStack();
        for (int c = 1; c <= channels; ++c) {
            if (channels == 1) {
                c = c1;
            }
            LUT lut = this.imp.isComposite() ? ((CompositeImage)this.imp).getChannelLut() : null;
            this.imp.setPosition(c, 1, 1);
            ImageProcessor ip = this.imp.getProcessor();
            double min = ip.getMin();
            double max = ip.getMax();
            for (int z = 1; z <= slices; ++z) {
                if (slices == 1) {
                    z = z1;
                }
                for (int t = 1; t <= frames; ++t) {
                    IJ.showProgress(i++, n);
                    if (frames == 1) {
                        t = t1;
                    }
                    ip = stack.getProcessor(this.imp.getStackIndex(c, z, t));
                    int n2 = imp2.getStackIndex(c, z, t);
                    if (stack2.getPixels(n2) != null) {
                        stack2.getProcessor(n2).insert(ip, 0, 0);
                        continue;
                    }
                    stack2.setPixels(ip.getPixels(), n2);
                }
            }
            if (lut != null) {
                if (imp2.isComposite()) {
                    ((CompositeImage)imp2).setChannelLut(lut);
                } else {
                    imp2.getProcessor().setColorModel(lut);
                }
            }
            imp2.getProcessor().setMinAndMax(min, max);
        }
        this.imp.setPosition(c1, z1, t1);
        imp2.resetStack();
        imp2.setPosition(1, 1, 1);
        imp2.setCalibration(this.imp.getCalibration());
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Reduce");
        gd.setInsets(10, 20, 5);
        gd.addMessage("Create Image With:");
        gd.setInsets(0, 35, 0);
        if (this.channels1 != 1) {
            gd.addCheckbox(this.channels1 + " channels", true);
        }
        gd.setInsets(0, 35, 0);
        if (this.slices1 != 1) {
            gd.addCheckbox(this.slices1 + " slices", true);
        }
        gd.setInsets(0, 35, 0);
        if (this.frames1 != 1) {
            gd.addCheckbox(this.frames1 + " frames", true);
        }
        gd.setInsets(5, 20, 0);
        gd.addMessage(this.getNewDimensions() + "      ");
        gd.setInsets(15, 20, 0);
        gd.addCheckbox("Keep Source", keep);
        gd.addDialogListener(this);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        if (this.channels1 != 1) {
            int n = this.channels2 = gd.getNextBoolean() ? this.channels1 : 1;
        }
        if (this.slices1 != 1) {
            int n = this.slices2 = gd.getNextBoolean() ? this.slices1 : 1;
        }
        if (this.frames1 != 1) {
            this.frames2 = gd.getNextBoolean() ? this.frames1 : 1;
        }
        keep = gd.getNextBoolean();
        return true;
    }

    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {
        Checkbox cb;
        if (e == null) {
            return false;
        }
        Object source = e.getSource();
        Checkbox checkbox = cb = source instanceof Checkbox ? (Checkbox)source : null;
        if (cb == null) {
            return true;
        }
        String label = cb.getLabel();
        if (label.indexOf("channels") != -1) {
            int n = this.channels2 = cb.getState() ? this.channels1 : 1;
        }
        if (label.indexOf("slices") != -1) {
            int n = this.slices2 = cb.getState() ? this.slices1 : 1;
        }
        if (label.indexOf("frames") != -1) {
            this.frames2 = cb.getState() ? this.frames1 : 1;
        }
        ((Label)gd.getMessage()).setText(this.getNewDimensions());
        return true;
    }

    String getNewDimensions() {
        String s = this.channels2 + "x" + this.slices2 + "x" + this.frames2;
        s = s + " (" + (int)Math.round(this.imageSize * (double)this.channels2 * (double)this.slices2 * (double)this.frames2) + "MB)";
        return s;
    }
}

