/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.io.SaveDialog;
import ij.plugin.PlugIn;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public class PNG_Writer
implements PlugIn {
    ImagePlus imp;

    public void run(String path) {
        if (!IJ.isJava14()) {
            IJ.showMessage("PNG Writer", "The command requires java 1.4 or later");
            return;
        }
        this.imp = WindowManager.getCurrentImage();
        if (this.imp == null) {
            IJ.noImage();
            return;
        }
        if (path.equals("")) {
            SaveDialog sd = new SaveDialog("Save as PNG...", this.imp.getTitle(), ".png");
            String name = sd.getFileName();
            if (name == null) {
                return;
            }
            String dir = sd.getDirectory();
            path = dir + name;
        }
        try {
            this.writeImage(this.imp, path);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (msg == null || msg.equals("")) {
                msg = "" + e;
            }
            IJ.showMessage("PNG Writer", "An error occured writing the file.\n \n" + msg);
        }
        IJ.showStatus("");
    }

    void writeImage(ImagePlus imp, String path) throws Exception {
        int width = imp.getWidth();
        int height = imp.getHeight();
        BufferedImage bi = new BufferedImage(width, height, 1);
        Graphics2D g = (Graphics2D)bi.getGraphics();
        g.drawImage(imp.getImage(), 0, 0, null);
        File f = new File(path);
        ImageIO.write((RenderedImage)bi, "png", f);
    }
}

