/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin;

import ij.CompositeImage;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.gui.Toolbar;
import ij.measure.Calibration;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;
import ij.process.StackProcessor;
import ij.util.Tools;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.util.Vector;

public class Scaler
implements PlugIn,
TextListener,
FocusListener {
    private ImagePlus imp;
    private static String xstr = "0.5";
    private static String ystr = "0.5";
    private static int newWidth;
    private static int newHeight;
    private static boolean newWindow;
    private static boolean interpolate;
    private static boolean fillWithBackground;
    private static boolean processStack;
    private double xscale;
    private double yscale;
    private String title = "Untitled";
    private Vector fields;
    private double bgValue;
    private boolean constainAspectRatio = true;
    private TextField xField;
    private TextField yField;
    private TextField widthField;
    private TextField heightField;
    private Rectangle r;
    private Object fieldWithFocus;

    public void run(String arg) {
        ImageProcessor ip;
        this.imp = IJ.getImage();
        Roi roi = this.imp.getRoi();
        if (roi != null && !roi.isArea()) {
            this.imp.killRoi();
        }
        if (!this.showDialog(ip = this.imp.getProcessor())) {
            return;
        }
        if (ip.getWidth() > 1 && ip.getHeight() > 1) {
            ip.setInterpolate(interpolate);
        } else {
            ip.setInterpolate(false);
        }
        ip.setBackgroundValue(this.bgValue);
        this.imp.startTiming();
        try {
            if (newWindow && this.imp.getStackSize() > 1 && processStack) {
                this.createNewStack(this.imp, ip);
            } else {
                this.scale(ip);
            }
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory("Scale");
        }
        IJ.showProgress(1.0);
    }

    void createNewStack(ImagePlus imp, ImageProcessor ip) {
        Rectangle r = ip.getRoi();
        boolean crop = r.width != imp.getWidth() || r.height != imp.getHeight();
        int nSlices = imp.getStackSize();
        ImageStack stack1 = imp.getStack();
        ImageStack stack2 = new ImageStack(newWidth, newHeight);
        boolean interp = interpolate;
        if (imp.getWidth() == 1 || imp.getHeight() == 1) {
            interp = false;
        }
        for (int i = 1; i <= nSlices; ++i) {
            IJ.showStatus("Scale: " + i + "/" + nSlices);
            ImageProcessor ip1 = stack1.getProcessor(i);
            String label = stack1.getSliceLabel(i);
            if (crop) {
                ip1.setRoi(r);
                ip1 = ip1.crop();
            }
            ip1.setInterpolate(interp);
            ImageProcessor ip2 = ip1.resize(newWidth, newHeight);
            if (ip2 != null) {
                stack2.addSlice(label, ip2);
            }
            IJ.showProgress(i, nSlices);
        }
        ImagePlus imp2 = imp.createImagePlus();
        imp2.setStack(this.title, stack2);
        Calibration cal = imp2.getCalibration();
        if (cal.scaled()) {
            cal.pixelWidth *= 1.0 / this.xscale;
            cal.pixelHeight *= 1.0 / this.yscale;
        }
        int[] dim = imp.getDimensions();
        imp2.setDimensions(dim[2], dim[3], dim[4]);
        IJ.showProgress(1.0);
        if (imp.isHyperStack()) {
            imp2.setOpenAsHyperStack(true);
        }
        if (imp.isComposite()) {
            imp2 = new CompositeImage(imp2, ((CompositeImage)imp).getMode());
        }
        imp2.show();
        imp2.changes = true;
    }

    void scale(ImageProcessor ip) {
        if (newWindow) {
            Rectangle r = ip.getRoi();
            ImagePlus imp2 = this.imp.createImagePlus();
            imp2.setProcessor(this.title, ip.resize(newWidth, newHeight));
            Calibration cal = imp2.getCalibration();
            if (cal.scaled()) {
                cal.pixelWidth *= 1.0 / this.xscale;
                cal.pixelHeight *= 1.0 / this.yscale;
            }
            imp2.show();
            this.imp.trimProcessor();
            imp2.trimProcessor();
            imp2.changes = true;
        } else {
            if (processStack && this.imp.getStackSize() > 1) {
                Undo.reset();
                StackProcessor sp = new StackProcessor(this.imp.getStack(), ip);
                sp.scale(this.xscale, this.yscale, this.bgValue);
            } else {
                ip.snapshot();
                Undo.setup(1, this.imp);
                ip.setSnapshotCopyMode(true);
                ip.scale(this.xscale, this.yscale);
                ip.setSnapshotCopyMode(false);
            }
            this.imp.killRoi();
            this.imp.updateAndDraw();
            this.imp.changes = true;
        }
    }

    boolean showDialog(ImageProcessor ip) {
        int bitDepth = this.imp.getBitDepth();
        boolean isStack = this.imp.getStackSize() > 1;
        this.r = ip.getRoi();
        int width = newWidth;
        if (width == 0) {
            width = this.r.width;
        }
        int height = (int)((double)width * (double)this.r.height / (double)this.r.width);
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        if (this.xscale != 0.0 && this.yscale != 0.0) {
            width = (int)((double)this.r.width * this.xscale);
            height = (int)((double)this.r.height * this.yscale);
        } else {
            xstr = "-";
            ystr = "-";
        }
        GenericDialog gd = new GenericDialog("Scale");
        gd.addStringField("X Scale (0.05-25):", xstr);
        gd.addStringField("Y Scale (0.05-25):", ystr);
        gd.setInsets(5, 0, 5);
        gd.addStringField("Width (pixels):", "" + width);
        gd.addStringField("Height (pixels):", "" + height);
        this.fields = gd.getStringFields();
        for (int i = 0; i < 3; ++i) {
            ((TextField)this.fields.elementAt(i)).addTextListener(this);
            ((TextField)this.fields.elementAt(i)).addFocusListener(this);
        }
        this.xField = (TextField)this.fields.elementAt(0);
        this.yField = (TextField)this.fields.elementAt(1);
        this.widthField = (TextField)this.fields.elementAt(2);
        this.heightField = (TextField)this.fields.elementAt(3);
        this.fieldWithFocus = this.xField;
        gd.addCheckbox("Interpolate", interpolate);
        if (bitDepth == 8 || bitDepth == 24) {
            gd.addCheckbox("Fill with Background Color", fillWithBackground);
        }
        if (isStack) {
            gd.addCheckbox("Process Entire Stack", processStack);
        }
        gd.addCheckbox("Create New Window", newWindow);
        this.title = WindowManager.getUniqueName(this.imp.getTitle());
        gd.setInsets(10, 0, 0);
        gd.addStringField("Title:", this.title, 12);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        xstr = gd.getNextString();
        ystr = gd.getNextString();
        this.xscale = Tools.parseDouble(xstr, 0.0);
        this.yscale = Tools.parseDouble(ystr, 0.0);
        String wstr = gd.getNextString();
        newWidth = (int)Tools.parseDouble(wstr, 0.0);
        newHeight = (int)Tools.parseDouble(gd.getNextString(), 0.0);
        if (newHeight != 0 && (wstr.equals("-") || wstr.equals("0"))) {
            newWidth = (int)((double)newHeight * (double)this.r.width / (double)this.r.height);
        }
        if (newWidth == 0 || newHeight == 0) {
            IJ.error("Invalid width or height entered");
            return false;
        }
        if (this.xscale > 25.0) {
            this.xscale = 25.0;
        }
        if (this.yscale > 25.0) {
            this.yscale = 25.0;
        }
        if (this.xscale > 0.0 && this.yscale > 0.0) {
            newWidth = (int)((double)this.r.width * this.xscale);
            newHeight = (int)((double)this.r.height * this.yscale);
        }
        interpolate = gd.getNextBoolean();
        if (bitDepth == 8 || bitDepth == 24) {
            fillWithBackground = gd.getNextBoolean();
        }
        if (isStack) {
            processStack = gd.getNextBoolean();
        }
        if (!(newWindow = gd.getNextBoolean()) && this.xscale == 0.0) {
            this.xscale = (double)newWidth / (double)this.r.width;
            this.yscale = (double)newHeight / (double)this.r.height;
        }
        this.title = gd.getNextString();
        if (fillWithBackground) {
            Color bgc = Toolbar.getBackgroundColor();
            if (bitDepth == 8) {
                this.bgValue = ip.getBestIndex(bgc);
            } else if (bitDepth == 24) {
                this.bgValue = bgc.getRGB();
            }
        } else if (bitDepth == 8) {
            this.bgValue = ip.isInvertedLut() ? 0.0 : 255.0;
        } else if (bitDepth == 24) {
            this.bgValue = -1.0;
        }
        return true;
    }

    public void textValueChanged(TextEvent e) {
        int newWidth;
        Object source = e.getSource();
        double newXScale = this.xscale;
        double newYScale = this.yscale;
        if (source == this.xField && this.fieldWithFocus == this.xField) {
            String newXText = this.xField.getText();
            newXScale = Tools.parseDouble(newXText, 0.0);
            if (newXScale == 0.0) {
                return;
            }
            if (newXScale != this.xscale) {
                int newWidth2 = (int)(newXScale * (double)this.r.width);
                this.widthField.setText("" + newWidth2);
                if (this.constainAspectRatio) {
                    this.yField.setText(newXText);
                    int newHeight = (int)(newXScale * (double)this.r.height);
                    this.heightField.setText("" + newHeight);
                }
            }
        } else if (source == this.yField && this.fieldWithFocus == this.yField) {
            String newYText = this.yField.getText();
            newYScale = Tools.parseDouble(newYText, 0.0);
            if (newYScale == 0.0) {
                return;
            }
            if (newYScale != this.yscale) {
                int newHeight = (int)(newYScale * (double)this.r.height);
                this.heightField.setText("" + newHeight);
            }
        } else if (source == this.widthField && this.fieldWithFocus == this.widthField && (newWidth = (int)Tools.parseDouble(this.widthField.getText(), 0.0)) != 0) {
            int newHeight = (int)((double)newWidth * (double)this.r.height / (double)this.r.width);
            this.heightField.setText("" + newHeight);
            this.xField.setText("-");
            this.yField.setText("-");
            newXScale = 0.0;
            newYScale = 0.0;
        }
        this.xscale = newXScale;
        this.yscale = newYScale;
    }

    public void focusGained(FocusEvent e) {
        this.fieldWithFocus = e.getSource();
        if (this.fieldWithFocus == this.widthField) {
            this.constainAspectRatio = true;
        } else if (this.fieldWithFocus == this.yField) {
            this.constainAspectRatio = false;
        }
    }

    public void focusLost(FocusEvent e) {
    }

    static {
        newWindow = true;
        interpolate = true;
        processStack = true;
    }
}

