/*
				  Image Info Dialog
 */

#ifndef IMGINFODLG_H
#define IMGINFODLG_H

#include <gtk/gtk.h>


typedef struct _imginfodlg_struct	imginfodlg_struct;


/*
 *	Image Info Dialog:
 */
struct _imginfodlg_struct {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	GtkWidget	*main_vbox,
			*thumb_pm,
			*img_vbox,
			*img_parm_label,
			*img_val_label,
			*file_vbox,
			*file_parm_label,
			*file_val_label,
			*dpy_vbox,
			*dpy_parm_label,
			*dpy_val_label,
			*comments_frame,
			*comments_label,
			*ok_btn;
};
#define IMGINFODLG(p)	((imginfodlg_struct *)(p))


extern imginfodlg_struct *ImgInfoDlgNew(GtkWidget *ref_toplevel);
extern void ImgInfoDlgSetValues(
	imginfodlg_struct *d,
	const guint8 *rgba,
	gint width, gint height,
	gint depth,			/* Bytes Per Pixel */
	gulong line,			/* Bytes Per Line*/
	gint nframes,
	gulong size,			/* Total Bytes */      
	gint alpha_channel,		/* 0 = None
					 * 1 = Allocated But Uniform
					 * 2 = Allocated & Defined */
	const guint8 *bg_color,		/* 4 bytes RGBA */
	gint x, gint y,
	gint base_width, gint base_height,    
	gboolean has_changes,

	const gchar *file_name,
	const gchar *file_format,
	gulong file_size,		/* Bytes */
	const gchar *title,
	const gchar *author,
	const gchar *creator,
	const gchar *comments,
	gulong last_modified,

	const gchar *display,		/* X Display Address */
	const gchar *visual_type,	/* X Visual Type */
	gint display_depth		/* X Depth In Bits Per Pixel */
);
extern gboolean ImgInfoDlgIsMapped(imginfodlg_struct *d);
extern void ImgInfoDlgMap(imginfodlg_struct *d);
extern void ImgInfoDlgUnmap(imginfodlg_struct *d);
extern void ImgInfoDlgDelete(imginfodlg_struct *d);


#endif	/* IMGINFODLG_H */
