/*
				  Print
 */

#ifndef PRINT_H
#define PRINT_H

#if !defined(WIN32)

#include <gtk/gtk.h>
#ifdef HAVE_LIBENDEAVOUR2
# include <endeavour2.h>
#endif
#include "imgview.h"
#include "print_values.h"

#if defined(HAVE_XPRINT)
typedef struct _iv_print_xprint_printer_struct	iv_print_xprint_printer_struct;
#define IV_PRINT_XPRINT_PRINTER(p)	((iv_print_xprint_printer_struct *)(p))
typedef struct _iv_print_xprint_medium_struct	iv_print_xprint_medium_struct;
#define IV_PRINT_XPRINT_MEDIUM(p)	((iv_print_xprint_medium_struct *)(p))


/*
 *	X Print Printer:
 */
struct _iv_print_xprint_printer_struct {
	gchar		*name,
			*description;
};


/*
 *	X Print Medium:
 */
struct _iv_print_xprint_medium_struct {
	gchar		*name,
			*tray;		/* Tray that this medium is on */
	gfloat		x_mm,		/* Offset in millimeters */
			y_mm,
			width_mm,	/* Size in millimeters */
			height_mm;
};
#endif


#if defined(HAVE_XPRINT)
/* print_xprint.c */
extern iv_print_xprint_printer_struct *iv_print_xprint_printer_new(void);
extern void iv_print_xprint_printer_delete(iv_print_xprint_printer_struct *m);
extern void iv_print_xprint_printers_list_delete(GList *glist);

extern iv_print_xprint_medium_struct *iv_print_xprint_medium_new(void);
extern void iv_print_xprint_medium_delete(iv_print_xprint_medium_struct *m);
extern void iv_print_xprint_mediums_list_delete(GList *glist);

extern GList *iv_print_xprint_get_printers_list(
	const gchar *xp_address
);
extern GList *iv_print_xprint_get_printer_trays(
	const gchar *xp_address,
	const gchar *printer_name
);
extern GList *iv_print_xprint_get_printer_mediums(
	const gchar *xp_address,
	const gchar *printer_name
);
extern GList *iv_print_xprint_get_printer_orientations(
	const gchar *xp_address,
	const gchar *printer_name
);
extern GList *iv_print_xprint_get_printer_resolutions(
	const gchar *xp_address,
	const gchar *printer_name
);
extern gint iv_print_xprint_get_medium_size(
	const gchar *xp_address,
	const gchar *printer_name,
	const gchar *tray_name,
	const gchar *medium_name,
	const gchar *orientation_name,
	const gint dpi,
	gint *width_rtn, gint *height_rtn
);

extern gint iv_print_xprint(
	imgview_image_struct *img,		/* Image to print */
	gint frame_num,				/* Frame on image to print */
	const print_values_struct *pv,		/* Print values */ 
	const guint8 *bg_color,			/* 4 bytes RGBA */
	GtkWidget *toplevel
);
#endif

/* print.c */
extern imgview_image_struct *PrintRenderImageFromValues(
	imgview_image_struct *img,
	const print_values_struct *pv,
	const guint8 *bg_color,			/* 4 bytes RGBA */
	gint (*progress_cb)(const gulong, const gulong, gpointer),
	gpointer progress_data
);
extern void PrintAdjustImageColor(
	imgview_image_struct *img,
	const print_values_struct *pv,
	gint (*progress_cb)(const gulong, const gulong, gpointer),
	gpointer progress_data
);

#ifdef HAVE_LIBENDEAVOUR2
/* print_lpr.c or print_xprint.c */
extern gint iv_print(
	imgview_image_struct *img,		/* Image to print */
	const print_values_struct *pv,		/* Print values */
	const guint8 *bg_color,			/* 4 bytes RGBA */
	GtkWidget *toplevel,
	edv_context_struct *edv2_ctx
);
#else
extern gint iv_print(
	imgview_image_struct *img,		/* Image to print */
	const print_values_struct *pv,		/* Print values */
	const guint8 *bg_color,			/* 4 bytes RGBA */
	GtkWidget *toplevel
);
#endif

#endif	/* !WIN32 */

#endif	/* PRINT_H */
