#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include "guiutils.h"
#include "screenshotdlg.h"
#include "config.h"

#include "images/icon_li_16x16.xpm"
#include "images/icon_camera_20x20.xpm"
#include "images/icon_camera_32x32.xpm"
#include "images/icon_camera_48x48.xpm"
#include "images/icon_cancel_20x20.xpm"


typedef struct _Dialog			Dialog;
#define DIALOG(p)			((Dialog *)(p))


static gint delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void screenshot_cb(GtkWidget *widget, gpointer data);
static void cancel_cb(GtkWidget *widget, gpointer data);

static void build_std_dialog(
	Dialog *d,
	const gint width, const gint height,
	const gchar *title,
	GtkWidget *ref_toplevel,
	GtkWidget **toplevel_rtn, GtkWidget **client_vbox_rtn,
	GtkAccelGroup **accelgrp_rtn
);

gboolean iv_screenshot_query(
	GtkWidget *ref_toplevel,
	gulong *delay,			/* In milliseconds */
	gboolean *hide_windows,
	gboolean *include_decorations
);


/*
 *	Dialog:
 */
struct _Dialog {

	GtkWidget	*toplevel;
	GtkAccelGroup	*accelgrp;
	gint		freeze_count,
			busy_count;
	gboolean	got_response;

	GtkWidget	*delay_spin,
			*include_decorations_check,
			*hide_windows_check;

};


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define ABSOLUTE(x)     (((x) < 0) ? ((x) * -1) : (x))


/*
 *	Toplevel GtkWindow "delete_event" signal callback.
 */
static gint delete_event_cb(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	Dialog *d = DIALOG(data);
	if(d == NULL)
	    return(FALSE);

	d->got_response = FALSE;
	gtk_main_quit();

	return(TRUE);
}

/*
 *	Screenshot callback.
 */
static void screenshot_cb(GtkWidget *widget, gpointer data)
{
	Dialog *d = DIALOG(data);
	if(d == NULL)
	    return;

	d->got_response = TRUE;
	gtk_main_quit();
}

/*
 *	Cancel callback.
 */
static void cancel_cb(GtkWidget *widget, gpointer data)
{
	Dialog *d = DIALOG(data);
	if(d == NULL)
	    return;

	d->got_response = FALSE;
	gtk_main_quit();
}

/*
 *	Builds a standard toplevel dialog and returns the pointers to
 *	the created widgets.
 */
static void build_std_dialog(
	Dialog *d,
	const gint width, const gint height,
	const gchar *title,
	GtkWidget *ref_toplevel,
	GtkWidget **toplevel_rtn, GtkWidget **client_vbox_rtn,
	GtkAccelGroup **accelgrp_rtn
)
{
	gint	bw = GUI_BUTTON_HLABEL_WIDTH_DEF,
		bh = GUI_BUTTON_HLABEL_HEIGHT_DEF,
		border_major = 5;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
	GtkWidget *w, *parent, *parent2;
	GtkWidget *toplevel, *main_vbox;


	/* Create keyboard accelerator group */
	accelgrp = gtk_accel_group_new();
	if(accelgrp_rtn != NULL)
	    *accelgrp_rtn = accelgrp;

	/* Create toplevel */
	toplevel = parent = w = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_widget_set_usize(w, width, height);
	gtk_window_set_title(GTK_WINDOW(w), title);
#ifdef PROG_NAME
	gtk_window_set_wmclass(
	    GTK_WINDOW(w), "dialog", PROG_NAME
	);
#endif
	gtk_widget_realize(w);
	window = w->window;
	if(window != NULL)
	{
	    gdk_window_set_decorations(
		window,
		GDK_DECOR_BORDER | GDK_DECOR_TITLE
	    );
	    gdk_window_set_functions(
		window,
		GDK_FUNC_MOVE | GDK_FUNC_CLOSE
	    );
	    GUISetWMIcon(window, (guint8 **)icon_camera_48x48_xpm);
	}
	gtk_signal_connect(
	    GTK_OBJECT(w), "delete_event",
	    GTK_SIGNAL_FUNC(delete_event_cb), d
	);
	gtk_container_border_width(GTK_CONTAINER(w), 0);
	gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
	if((ref_toplevel != NULL) ?
	    GTK_IS_WINDOW(ref_toplevel) : FALSE
	)
	{
	    gtk_window_set_modal(GTK_WINDOW(toplevel), TRUE);
	    gtk_window_set_transient_for(
		GTK_WINDOW(toplevel), GTK_WINDOW(ref_toplevel)
	    );
	}
	if(toplevel_rtn != NULL)
	    *toplevel_rtn = toplevel;

	main_vbox = w = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), w);
	gtk_widget_show(w);
	parent = w;

	w = gtk_vbox_new(FALSE, border_major);
	gtk_container_border_width(GTK_CONTAINER(w), border_major);
	gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	gtk_widget_show(w);
	parent2 = w;
	if(client_vbox_rtn != NULL)
	    *client_vbox_rtn = w;

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(main_vbox), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Buttons */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(main_vbox), w, FALSE, FALSE, border_major);
	gtk_widget_show(w);
	parent2 = w;

	/* Screenshot button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_camera_20x20_xpm,
	    "Screenshot",
	    NULL
	);
	gtk_widget_set_usize(w, bw, bh);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(screenshot_cb), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_s, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_s);
	gtk_widget_grab_focus(w);
	gtk_widget_grab_default(w);
	gtk_widget_show(w);

	/* Cancel button */
	w = GUIButtonPixmapLabelH(
	    (guint8 **)icon_cancel_20x20_xpm,
#if defined(PROG_LANGUAGE_SPANISH)
	    "Cancele",
#elif defined(PROG_LANGUAGE_FRENCH)
	    "Annuler",
#elif defined(PROG_LANGUAGE_GERMAN)
	    "Heben",
#elif defined(PROG_LANGUAGE_ITALIAN)
	    "Annullar",
#elif defined(PROG_LANGUAGE_DUTCH)
	    "Annuler",
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	    "Cancela",
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	    "Kanseler",
#else
	    "Cancel",
#endif
	    NULL
	);
	gtk_widget_set_usize(w, bw, bh);
	GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_signal_connect(
	    GTK_OBJECT(w), "clicked",
	    GTK_SIGNAL_FUNC(cancel_cb), d
	);
	gtk_accel_group_add(
	    accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	gtk_accel_group_add(
	    accelgrp, GDK_c, GDK_CONTROL_MASK, GTK_ACCEL_VISIBLE,
	    GTK_OBJECT(w), "clicked"
	);
	GUIButtonLabelUnderline(w, GDK_c);
	gtk_widget_show(w);
}


/*
 *	Queries user for Screenshot.
 *
 *	Returns TRUE on Screenshot or FALSE on Cancel.
 */
gboolean iv_screenshot_query(
	GtkWidget *ref_toplevel,
	gulong *delay,			/* In milliseconds */
	gboolean *hide_windows,
	gboolean *include_decorations
)
{
	const gint	width = 400,
			height = -1,
			border_major = 5,
			border_minor = 2;
	gboolean got_response;
	GtkAccelGroup	*accelgrp = NULL;
	GtkWidget	*toplevel = NULL,
			*client_vbox = NULL;

	/* Create the screenshot dialog */
	Dialog *d = DIALOG(g_malloc0(sizeof(Dialog)));
	build_std_dialog(
	    d,
	    width, height,
	    "Screenshot",
	    ref_toplevel,
	    &toplevel, &client_vbox, &accelgrp
	);
	d->toplevel = toplevel;
	d->accelgrp = accelgrp;
	d->freeze_count = 0;
	d->busy_count = 0;
	d->got_response = FALSE;

	d->freeze_count++;

	if((toplevel != NULL) && (client_vbox != NULL))
	{
	    GdkWindow	*window = toplevel->window;
	    GtkAdjustment *adj;
	    GtkStyle	*style = gtk_widget_get_style(toplevel);
	    GtkWidget	*w,
			*parent = client_vbox,
			*parent2, *parent3, *parent4;

	    w = gtk_hbox_new(FALSE, border_major);
	    gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	    gtk_widget_show(w);
	    parent = w;

	    /* Left column vbox */
	    w = gtk_vbox_new(TRUE, 0);
	    gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Icon */
	    w = gtk_pixmap_new_from_xpm_d(
		toplevel->window, NULL,
		(guint8 **)icon_camera_32x32_xpm
	    );
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);


	    /* Right column vbox */
	    w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
	    gtk_widget_show(w);
	    parent2 = w;

	    /* Vbox for Instructions */
	    w = gtk_vbox_new(FALSE, 0);
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent3 = w;

#define ADD_LINE(_p_,_d_,_s_)	{	\
 GtkWidget *p2, *p3;			\
					\
 /* Hbox */				\
 w = gtk_hbox_new(FALSE, 0);		\
 gtk_box_pack_start(			\
  GTK_BOX(_p_), w, FALSE, FALSE, 0	\
 );					\
 gtk_widget_show(w);			\
 p2 = w;				\
					\
 /* Icon */				\
 if((_d_) != NULL) {			\
  w = gtk_vbox_new(FALSE, 0);		\
  gtk_box_pack_start(			\
   GTK_BOX(p2), w, FALSE, FALSE, 0	\
  );					\
  gtk_widget_show(w);			\
  p3 = w;				\
  w = gtk_pixmap_new_from_xpm_d(	\
   window,				\
   (style != NULL) ?			\
    &style->bg[GTK_STATE_NORMAL] : NULL,\
   (guint8 **)(_d_)			\
  );					\
  gtk_box_pack_start(			\
   GTK_BOX(p3), w, FALSE, FALSE, 0	\
  );					\
  gtk_widget_show(w);			\
 }					\
					\
 /* Label */				\
 w = gtk_label_new(_s_);		\
 gtk_label_set_justify(			\
  GTK_LABEL(w), GTK_JUSTIFY_LEFT	\
 );					\
 gtk_box_pack_start(			\
  GTK_BOX(p2), w, FALSE, FALSE, 0	\
 );					\
 gtk_widget_show(w);			\
}

#if defined(PROG_LANGUAGE_SPANISH)
	    ADD_LINE(
		parent3, NULL,
"Despues de la demora:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La prensa Button1 para tomar un screenshot de una sola\nventana."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La prensa y el obstaculo Button2 para tomar un screenshot\nde un area rectangular."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La prensa Button3 para cancelar el screenshot."
	    );
	    ADD_LINE(
		parent3, NULL,
"(Para tomar un screenshot de la prensa Button1 entera de\nsobremesa sobre la sobremesa)"
	    );
#elif defined(PROG_LANGUAGE_FRENCH)
	    ADD_LINE(
		parent3, NULL,
"Apres le retard:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"De presse Button1 pour prendre un screenshot d'une\nfenetre seule."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La presse et traine Button2 pour prendre un screenshot\nd'un secteur rectangulaire."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"De presse Button3 pour annuler le screenshot."  
	    );
	    ADD_LINE(
		parent3, NULL,
"(Pour prendre un screenshot du plan de travail entier de\npresse Button1 par-dessus le plan de travail)"
	    );
#elif defined(PROG_LANGUAGE_GERMAN)
	    ADD_LINE(
		parent3, NULL,
"Nach der verspatung:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse Button1, einen screenshot von einem einzelnen\npenster zu nehmen."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse und widerstand Button2, einen screenshot von\neinem rechteckigen gebiet zu nehmen."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse Button3, den screenshot aufzuheben."  
	    );
	    ADD_LINE(
		parent3, NULL,
"(Um einen screenshot von der ganzen schreibtisch presse\nButton1 uber dem schreibtisch zu nehmen)"
	    );
#elif defined(PROG_LANGUAGE_ITALIAN)
	    ADD_LINE(
		parent3, NULL,
"Dopo il ritardo:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La stampa Button1 di portare uno screenshot di una\nfinestra sola."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La stampa e trascina Button2 per portare uno screenshot\ndi un'area rettangolare."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"La stampa Button3 di annullare lo screenshot."
	    );
	    ADD_LINE(
		parent3, NULL,
"(Per portare uno screenshot della stampa di desktop\nintero Button1 sopra il desktop)"
	    );
#elif defined(PROG_LANGUAGE_DUTCH)
	    ADD_LINE(
		parent3, NULL,
"Na de vertraging:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Pers Button1 zal een screenshot van een enkel raam nemen."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Druk en ruk Button2 om een screenshot van een rechthoekig\ngebied te nemen."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Pers Button3 zal de screenshot annuleren."
	    );
	    ADD_LINE(
		parent3, NULL,
"(Om een screenshot van de volledige bureau pers Button1\nover het bureau te nemen)"
	    );
#elif defined(PROG_LANGUAGE_PORTUGUESE)
	    ADD_LINE(
		parent3, NULL,
"Depois da demora:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Button1 de prensa tomar um screenshot de uma unica\njanela."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"A prensa e Button2 de obstaculo tomar um screenshot de\numa area retangular."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Button3 de prensa cancelar o screenshot."  
	    );
	    ADD_LINE(
		parent3, NULL,
"(Tomar um screenshot do Button1 inteiro de prensa de area\nde trabalho sobre a area de trabalho)"
	    );
#elif defined(PROG_LANGUAGE_NORWEGIAN)
	    ADD_LINE(
		parent3, NULL,
"Etter utsettelsen:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse Button1 ta en screenshot av et enkelt vindu."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse og hindring Button2 ta en screenshot av et\nrektanguleart omrade."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Presse Button3 kansellere screenshot."  
	    );
	    ADD_LINE(
		parent3, NULL,
"(Ta en screenshot av den hele skrivebordpresse Button1\nover skrivebordet)"
	    );
#else
	    ADD_LINE(
		parent3, NULL,
"After the delay:"
	    );
	    parent4 = w = gtk_vbox_new(FALSE, border_major);
	    gtk_box_pack_start(
		GTK_BOX(parent3), w, FALSE, FALSE, 12
	    );
	    gtk_widget_show(w);
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Press Button1 to take a screenshot of a single window."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Press and drag Button2 to take a screenshot of a\nrectangular area."
	    );
	    ADD_LINE(
		parent4, icon_li_16x16_xpm,
"Press Button3 to cancel the screenshot."
	    );
	    ADD_LINE(
		parent3, NULL,
"(To take a screenshot of the entire desktop press Button1\nover the desktop)"
	    );
#endif

#undef ADD_LINE

	    w = gtk_hseparator_new();
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);

	    /* GtkVBox for screenshot values */
	    w = gtk_vbox_new(FALSE, border_minor);
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent3 = w;

	    /* Delay (in seconds) */
	    w = gtk_hbox_new(FALSE, border_minor);
	    gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent4 = w;
	    /* GtkLabel */
	    w = gtk_label_new("Delay:");
	    gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    /* GtkSpinButton */
	    adj = (GtkAdjustment *)gtk_adjustment_new(
		(gfloat)((delay != NULL) ? *delay : 0) / 1000.0f,
		0.0f,
		10.0f * 60.0f * 1000.0f,	/* Max 10 minutes */
		1.0f,
		5.0f,
		0.0f
	    );
	    d->delay_spin = w = gtk_spin_button_new(
		adj,
		1.0,	/* Climb rate (0.0 to 1.0) */
		0	/* Digits */
	    );
	    gtk_widget_set_usize(w, 60, -1);
	    gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	    GUISetWidgetTip(w,
"Set the delay before the GUI is \"locked\" (have everything hold\
 still) for you to take the screenshot"
	    );
	    gtk_widget_show(w);
	    /* Units GtkLabel */
	    w = gtk_label_new("seconds");
	    gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);

	    /* GtkHBox for Include Decorations & Hide Windows */
	    w = gtk_hbox_new(FALSE, border_minor);
	    gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    parent4 = w;
	    /* Include Decorations GtkCheckButton */
	    d->include_decorations_check = w =
		gtk_check_button_new_with_label("Include Decorations");
	    gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	    GUISetWidgetTip(w,
"Check this to include window decorations when you take a\
 screenshot of a single window"
 	    );
	    gtk_widget_show(w);
	    /* Hide Windows GtkCheckButton */
	    d->hide_windows_check = w = gtk_check_button_new_with_label(
		"Hide Windows"
	    );
	    gtk_box_pack_start(GTK_BOX(parent4), w, FALSE, FALSE, 0);
	    GUISetWidgetTip(w,
"Check this to hide this application's windows while you take the\
 screenshot"
	    );
	    gtk_widget_show(w);

	    /* Set the initial values */
	    if(delay != NULL)
		gtk_spin_button_set_value(
		    GTK_SPIN_BUTTON(d->delay_spin),
		    (gfloat)(*delay / 1000.0f)
		);
	    if(include_decorations != NULL)
		gtk_toggle_button_set_active(
		    GTK_TOGGLE_BUTTON(d->include_decorations_check),
		    *include_decorations
		);
	    if(hide_windows != NULL)
		gtk_toggle_button_set_active(
		    GTK_TOGGLE_BUTTON(d->hide_windows_check),
		    *hide_windows
		);
	}

	d->freeze_count--;

	/* Map the dialog  */
	gtk_widget_show_raise(toplevel);

	/* Push a GTK main level and wait for user response */
	gtk_main();

	/* Got user response? */
	got_response = d->got_response;
	if(got_response)
	{
	    if(delay != NULL)
		*delay = (gulong)GTK_ENTRY_GET_VALUEL(d->delay_spin) * 1000l;

	    if(include_decorations != NULL)
		*include_decorations = GTK_TOGGLE_BUTTON_GET_ACTIVE(
		    d->include_decorations_check
		);

	    if(hide_windows != NULL)
		*hide_windows = GTK_TOGGLE_BUTTON_GET_ACTIVE(
		    d->hide_windows_check
		);
	}

	/* Destroy the dialog */
	gtk_widget_hide(toplevel);
	gtk_window_set_modal(GTK_WINDOW(toplevel), FALSE);
	gtk_window_set_transient_for(GTK_WINDOW(toplevel), NULL);

	GTK_WIDGET_DESTROY(d->delay_spin);
	GTK_WIDGET_DESTROY(d->include_decorations_check);
	GTK_WIDGET_DESTROY(d->hide_windows_check);
	GTK_WIDGET_DESTROY(d->toplevel);
	GTK_ACCEL_GROUP_UNREF(d->accelgrp);
	g_free(d);

	return(got_response);
}
