#!/usr/bin/perl

=cut

This -ugly- Perl script helps making a binary distribution package out of compiled K-3D directory.
Here are the steps:

- after compiling K-3D, go to k3d/ root directory (the one where you type `make`)
- move distribution/makedist.pl (this script) to k3d/ root directory
- launch it: ./makedist.pl
- the binary files are in ../k3d-binary/
- now pack the whole thing e.g. `tar zcvf k3d-0.2.5.2-debian-sid.tgz k3d-0.2.5.2`
- then upload it on sourceforge:
    ftp upload.sourceforge.net
    login: anonymous
    passwd: <your email>
    bin
    cd /incoming
    put k3d-0.4.0.0-debian-sid.tgz
- send a mail to current K-3D maintainer for him to release the file :)

=cut


my $BINARYDIR = '.libs';


my $dir = `pwd`;
chomp $dir;

my ($path, $dirname) = ($dir =~ /(.*\/)(.*)/);

my $newdir = $path.$dirname.'-binary';
CMD("mkdir -p $newdir");

# copy data directories
for(qw(dialogtemplates scripts shaders share tutorials))
	{
	CMD("cp -rf $dir/$_ $newdir/");
	}

# copy binaries
for(qw(application renderframe renderjob))
	{
	CMD("cp -rf $dir/$_/$BINARYDIR/* $newdir/");
	}
CMD("cp -f $dir/shaderpreprocessor/gpp $newdir/");

# copy libraries
CMD("mkdir -p $newdir/libs");
for(qw(k3dui k3dembed k3dsdk sdpgl sdpgtk sdpsl sdpxml))
	{
	CMD("cp -rf $dir/$_/$BINARYDIR/*\.so* $newdir/libs/");
	}
# copy plugins
CMD("mkdir -p $newdir/plugins");
for(`find $dir/modules/ -name \"?*\" -type d`)
	{
	chomp;
	my $current_dir = $_;

	my ($dir_name) = ($current_dir =~ /.*\/(.*)/);
	next if($dir_name eq 'CVS');

	CMD("cp -Pf --preserve=link $current_dir/$BINARYDIR/*\.so* $newdir/plugins");
	}


CMD("cp -rf $dir/distribution/start-k3d $newdir/");


# Strip binaries
CMD("strip $newdir/libs/*.so.*.*");
CMD("strip $newdir/plugins/*.so.*.*");
CMD("strip $newdir/lt-k3d-bin $newdir/k3d-renderframe $newdir/k3d-renderjob $newdir/gpp");


# Remove useless files
CMD("rm -f $newdir/k3d-bin");
DelFiles($newdir, '.cvsignore');
DelFiles($newdir, 'Makefile');
DelFiles($newdir, 'Makefile.in');
DelFiles($newdir, 'Makefile.am');


sub	CMD
{
	my ($cmd) = @_;

	print "CMD : $cmd\n";
	system($cmd);
}

sub	DelFiles
{
	my ($dir, $name) = @_;

	for(`find $dir -name \"$name\" -type f`)
		{
		chomp;
		CMD("rm -f $_");
		}
}


