/***************************************************************************
                          kalbumview.h  -  description
                             -------------------
    begin                : Tue Jan 22 14:13:58 CET 2002
    copyright            : (C) 2002 by Graham Morrison
    email                : kalbum@paldandy.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KALBUMVIEW_H
#define KALBUMVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qptrlist.h>

//include files added by GMM
#include <kpixmap.h>
#include <kio/job.h>
#include <kio/netaccess.h>
#include <kstddirs.h>
#include <kpopupmenu.h>
#include <ktar.h>
#include "kalbumdoc.h"
#include "photoalbum.h"
#include "kalbumcredits.h"
#include "kalbumviewdlg.h"
#include "kalmimesource.h"


class KalbumDoc;

/** The KalbumView class provides the view widget for the KalbumApp instance.
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KalbumView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KalbumApp class to manipulate and display
 * the document structure provided by the KalbumDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KalbumView : public KalbumViewDlg
{
    Q_OBJECT
public:
    /** Constructor for the main view */
    KalbumView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KalbumView();

    /** returns a pointer to the document connected to the view instance. Mind that this method requires a KalbumApp instance as a parent
     * widget to get to the window document pointer by calling the KalbumApp::getDocument() method.
     *
     * @see KalbumApp#getDocument
     */
    KalbumDoc *getDocument() const;

    /** Returns photo data for selected Icon */
    PhotoAlbum *getPhoto(KalbumViewItem *chosen);

    PhotoAlbum *nextPhoto(PhotoAlbum *photo);
    PhotoAlbum *prevPhoto(PhotoAlbum *photo);

    /** DnD functionality */
    void dragEnterEvent(QDragEnterEvent *event);

    /** contains the implementation for printing functionality */
    void print(QPrinter *pPrinter);

    bool addPhotoItem(const KURL& url=0);
    bool addPhotoItem(PhotoAlbum *photo);
    bool addPhotoItem(const KURL& url, PhotoAlbum *before);
    bool addPhotoItem(PhotoAlbum *photo, PhotoAlbum *before);
    bool allSelected();
    void setSelected();
    void copyPhotoItem();
    void cutPhotoItem();
    void pastePhotoItem();
    void editPhotoItem();
    void deletePhotoItem(PhotoAlbum *photo);
    void deleteSelected();
    void editMoveUp();
    void editMoveDown();
    void deleteAll();
    void sortDateInc();
    void sortDateDec();
    void sortTitleInc();
    void sortTitleDec();
    void statusMsg(const QString &text);
    void updateProgress();
    void updateProgress(int current);
    void updateProgress(int current, int max);
    bool savePhotoAlbum(const KURL& url);
    bool loadPhotoAlbum(const KURL& url);
    void colourHTML(const KURL& src, const KURL& des, int saturation, int hue);
    bool exportHTML(const KURL& url);
    bool exportHTML();
    bool exportWAR(const KURL& url);
    KTar *exportWARdir(KTar *tar, const KURL& url, QString directory);
    bool exportOriginal(const KURL& url);    
    bool makeHTML(const KURL& src, const KURL& des);
    int	 exportThumbs(const KURL& url);
    int	 exportImages(const KURL& url);
    int  countPhoto();
    QImage scaleImage(QImage buffer, int x, int y);
    QImage effectImage(QImage buffer, int rotate);
    bool writeString(QString stringHTML, const KURL& url);
    QString linkPhoto(QString htmldata);
    QString linkPhoto(QString htmldata, KalbumViewItem *positem);
    QString linkThumb(QString htmldata, QString first_photo);
    QString linkThumb(QString htmldata, QString first_photo, int photo_number, int max_photo);
    QString readString(const KURL& url);
    QString getPrecision(QString str_number);
    QString makeHTMLthumb(QString htmldata, int photo_number);
    QString makeHTMLthumb(QString htmldata, int photo_number, PhotoAlbum *photo);
    QString makeHTMLphoto(QString htmldata, PhotoAlbum *photo);
    QString makeHTMLtitle(QString htmldata);
    QPtrList<PhotoAlbum> getPhotoData();

public slots:
    /** Enables the user to get a better look at the photo and to add their own comments.
    */
    void slotPhotoProp(QIconViewItem *i);
    void slotDropEvent (QDropEvent *event, int drop_index);
    void slotSelection();
    void slotRHClick();
    void slotCut();
    void slotCopy();
    void slotPaste();
    void slotMoveLeft();
    void slotMoveRight();
    void slotEditPhoto();
    void slotPrevImage();
    void slotNextImage();
    void slotAlbumChanged(KalbumCredits album);
    void slotModifiedImage(PhotoAlbum *photo_tmp, int selected);
    void slotUpdateTotal();

signals:

    void setModified();
    void incProgress();
    void setProgress(int current);
    void resetProgress(int current, int max);
    void setCopyEnabled(bool set);
    void setCutEnabled(bool set);
    void setMoveUpEnabled(bool set);
    void setMoveDownEnabled(bool set);
    void setEditPhotoEnabled(bool set);
    void albumChanged(KalbumCredits album);
    void setStatusMsg(const QString &text);
    void albumNew();
    void executedIcon();
    void selectionChanged(QPtrList <PhotoAlbum> photolist);
    void updateSelected(int selected);
    void updateTotal(int total);

public:
    /** the PhotoAlbum data
    */
    static QPtrList<PhotoAlbum> *album;
    static KalbumCredits credits;

protected:

    KPopupMenu* popIconView;

private:

  KalbumApp* appParent;
  KTarGz* tarBall;


};

#endif // KALBUMVIEW_H
