/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* effectconfig.h
 */
#ifndef effectconfig_h
#define effectconfig_h

#include <qwidget.h>

namespace KoverArtist
{
   class Effect;
}

class KColorButton;
class QComboBox;
class QSlider;
class QLabel;
class QColor;


/** A high level gui widget for changing the various configuration elements
 * of a koverartist effect.
 */
class EffectConfig: public QWidget
{
   Q_OBJECT
   typedef QWidget Inherited;

public:
   EffectConfig(KoverArtist::Effect* e, QWidget* parent=0, const char* name=0);
   virtual ~EffectConfig();

signals:
   /** Emitted when the user changed effect settings. */
   void changed();

public slots:
   /** Update the gui elements from the effect. */
   virtual void update();

   virtual void setType(int);
   virtual void setColor1(const QColor&);
   virtual void setColor2(const QColor&);
   virtual void setSize(int);
   virtual void setTrans(int);

protected slots:
   virtual void sendChanged();

protected:
   KoverArtist::Effect *mEffect;
   KColorButton *mBtnColor1, *mBtnColor2;
   QSlider *mSldSize, *mSldTrans;
   QLabel *mLblSize, *mLblTrans, *mLblSizeVal, *mLblTransVal;
   QComboBox *mCboType;
};

#endif /*effectconfig_h*/
