/*
   Copyright (C) 2006 by Stefan Taferner <taferner@kde.org>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "pref.h"

#include "cdinfo.h"
#include "prefcddb.h"
#include "prefgeneral.h"
#include "settings.h"

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qgroupbox.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

#include <iostream>



KoverArtistPreferences::KoverArtistPreferences()
:KDialogBase(IconList, i18n("KoverArtist Preferences"),
             Default|Ok|Apply|Cancel, Ok)
{
   QFrame *frame;

   KIconLoader *ildr = KGlobal::iconLoader();

   frame = addPage(i18n("General"), i18n("General Options"),
                   ildr->loadIcon("kfm_home", KIcon::Desktop, KIcon::SizeMedium));
   mPgGen = new KoverArtistPrefGeneral(frame);
   mPgGen->setMinimumSize(mPgGen->sizeHint());

   frame = addPage(i18n("Audio-CDs"), i18n("Audio-CD And CDDB Options"),
                   ildr->loadIcon("cd", KIcon::Desktop, KIcon::SizeMedium));
   mPgCddb = new KoverArtistPrefCddb(frame);
   mPgCddb->setMinimumSize(mPgCddb->sizeHint());

   fromConfig();

   QSize sz = configDialogSize("KoverArtistPreferences");
   if (sz.height()<100) sz = QSize(700, 600);
   setInitialSize(sz);
}


void KoverArtistPreferences::fromConfig(const KoverArtist::Settings* aStg)
{
   if (!aStg) aStg = KoverArtist::Settings::instance();

   mPgGen->fromConfig(aStg);
   mPgCddb->fromConfig(aStg);
}


void KoverArtistPreferences::toConfig(KoverArtist::Settings* aStg)
{
   if (!aStg) aStg = KoverArtist::Settings::instance();

   mPgGen->toConfig(aStg);
   mPgCddb->toConfig(aStg);

   saveDialogSize("KoverArtistPreferences");

   aStg->sync();
}


bool KoverArtistPreferences::isValid() const
{
   if (!mPgGen->isValid()) return false;
   if (!mPgCddb->isValid()) return false;

   return true;
}


void KoverArtistPreferences::slotOk()
{
   if (!isValid()) return;

   toConfig();
   accept();
}


void KoverArtistPreferences::slotApply()
{
   if (isValid()) toConfig();
}


void KoverArtistPreferences::slotDefault()
{
   KoverArtist::Settings def;
   fromConfig(&def);
}


#include "pref.moc"
